/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.util;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.spark.PrestoSparkRetryExecutionSettings;
import com.facebook.presto.spark.PrestoSparkSessionContext;
import com.facebook.presto.spark.PrestoSparkSessionProperties;
import com.facebook.presto.spark.classloader_interface.RetryExecutionStrategy;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class PrestoSparkRetryExecutionUtils {
    private static final Logger log = Logger.get(PrestoSparkSessionContext.class);

    private PrestoSparkRetryExecutionUtils() {
    }

    public static PrestoSparkRetryExecutionSettings getRetryExecutionSettings(RetryExecutionStrategy retryExecutionStrategy, Session session) {
        log.info(String.format("Applying retry execution strategy: %s. Query Id: %s", retryExecutionStrategy.name(), session.getQueryId().getId()));
        switch (retryExecutionStrategy) {
            case DISABLE_BROADCAST_JOIN: {
                ImmutableMap.Builder prestoSettings = new ImmutableMap.Builder();
                prestoSettings.put((Object)"join_distribution_type", (Object)FeaturesConfig.JoinDistributionType.PARTITIONED.name());
                return new PrestoSparkRetryExecutionSettings((Map<String, String>)ImmutableMap.of(), (Map<String, String>)prestoSettings.build());
            }
            case INCREASE_CONTAINER_SIZE: {
                return new PrestoSparkRetryExecutionSettings(PrestoSparkSessionProperties.getOutOfMemoryRetrySparkConfigs(session), PrestoSparkSessionProperties.getOutOfMemoryRetryPrestoSessionProperties(session));
            }
            case INCREASE_HASH_PARTITION_COUNT: {
                ImmutableMap.Builder prestoSettingsWithScaledPartitionCount = new ImmutableMap.Builder();
                Long updatedPartitionCount = Math.round((double)SystemSessionProperties.getHashPartitionCount((Session)session) * PrestoSparkSessionProperties.getHashPartitionCountScalingFactorOnOutOfMemory(session));
                prestoSettingsWithScaledPartitionCount.put((Object)"hash_partition_count", (Object)updatedPartitionCount.toString());
                return new PrestoSparkRetryExecutionSettings((Map<String, String>)ImmutableMap.of(), (Map<String, String>)prestoSettingsWithScaledPartitionCount.build());
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_RETRY_EXECUTION_STRATEGY, "Retry execution strategy not supported: " + retryExecutionStrategy);
    }
}

