/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.util;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.RuntimeMetric;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.operator.NativeExecutionInfo;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskStats;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.text.CaseUtils;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.util.AccumulatorV2;
import scala.Option;

public class PrestoSparkStatsCollectionUtils {
    public static final String SPARK_INTERNAL_ACCUMULATOR_PREFIX = "internal.metrics.";
    public static final String PRESTO_NATIVE_OPERATOR_STATS_SEP = "internal";
    public static final String PRESTO_NATIVE_OPERATOR_STATS_PREFIX = "velox.";
    private static final Logger log = Logger.get(PrestoSparkStatsCollectionUtils.class);

    private PrestoSparkStatsCollectionUtils() {
    }

    public static void collectMetrics(TaskInfo taskInfo) {
        int taskId = -1;
        int stageId = -1;
        try {
            taskId = taskInfo.getTaskId().getId();
            stageId = taskInfo.getTaskId().getStageExecutionId().getStageId().getId();
            Set<RuntimeStats> runtimeStatsSet = PrestoSparkStatsCollectionUtils.collectRuntimeStats(taskInfo);
            PrestoSparkStatsCollectionUtils.collectMetrics(runtimeStatsSet);
        }
        catch (Exception e) {
            log.error("An error occurred while processing taskId=%s  stageId=%s", new Object[]{taskId, stageId, e});
        }
    }

    public static void collectMetrics(Set<RuntimeStats> runtimeStatsSet) {
        runtimeStatsSet.forEach(runStats -> runStats.getMetrics().entrySet().forEach(entry -> {
            String prestoKey = (String)entry.getKey();
            String sparkInternalAccumulatorKey = PrestoSparkStatsCollectionUtils.getSparkInternalAccumulatorKey(prestoKey);
            PrestoSparkStatsCollectionUtils.collectMetric(sparkInternalAccumulatorKey, prestoKey, (RuntimeMetric)entry.getValue());
        }));
    }

    static void collectMetric(String sparkInternalAccumulatorKey, String prestoKey, RuntimeMetric metric) {
        boolean isSparkUnitMs = sparkInternalAccumulatorKey.contains("Ms");
        long metricVal = PrestoSparkStatsCollectionUtils.getMetricValue(metric, isSparkUnitMs);
        PrestoSparkStatsCollectionUtils.incSparkInternalAccumulator(sparkInternalAccumulatorKey, prestoKey, metricVal);
    }

    static String getSparkInternalAccumulatorKey(String prestoKey) {
        if (prestoKey.contains(SPARK_INTERNAL_ACCUMULATOR_PREFIX)) {
            int index = prestoKey.indexOf(PRESTO_NATIVE_OPERATOR_STATS_SEP);
            return prestoKey.substring(index);
        }
        String[] strs = prestoKey.split("\\.");
        if (strs == null || strs.length < 2) {
            log.debug("Fail to build spark internal key for %s format not supported", new Object[]{prestoKey});
            return "";
        }
        String prestoNewKey = String.format("%1$s%2$s", strs[0], strs[strs.length - 1]);
        if (prestoNewKey.contains("_")) {
            prestoNewKey = CaseUtils.toCamelCase((String)prestoKey, (boolean)false, (char[])new char[]{'_'});
        }
        return String.format("%1$s%2$s%3$s", SPARK_INTERNAL_ACCUMULATOR_PREFIX, PRESTO_NATIVE_OPERATOR_STATS_PREFIX, prestoNewKey);
    }

    static Set<RuntimeStats> collectRuntimeStats(TaskInfo taskInfo) {
        HashSet<RuntimeStats> stats = new HashSet<RuntimeStats>();
        if (taskInfo.getStats() == null) {
            return stats;
        }
        for (PipelineStats pipelineStats : taskInfo.getStats().getPipelines()) {
            if (pipelineStats == null) continue;
            for (OperatorStats operatorStats : pipelineStats.getOperatorSummaries()) {
                NativeExecutionInfo nativeExecutionInfo;
                if (operatorStats == null || !operatorStats.getOperatorType().equals("NativeExecutionOperator") || (nativeExecutionInfo = (NativeExecutionInfo)operatorStats.getInfo()) == null) continue;
                for (TaskStats taskStats : nativeExecutionInfo.getTaskStats()) {
                    if (taskStats == null) continue;
                    RuntimeStats runtimeStat = taskStats.getRuntimeStats();
                    stats.add(runtimeStat);
                }
            }
        }
        return stats;
    }

    static long getMetricValue(RuntimeMetric metric, boolean isSparkUnitMs) {
        long sum = metric.getSum();
        if (metric.getUnit().equals((Object)RuntimeUnit.NANO) && isSparkUnitMs) {
            sum = TimeUnit.NANOSECONDS.toMillis(sum);
        }
        return sum;
    }

    static void incSparkInternalAccumulator(String sparkInternalAccuName, String prestoKey, Object metric) {
        TaskMetrics tm = TaskContext.get().taskMetrics();
        if (tm != null) {
            Option acc2 = tm.nameToAccums().get((Object)sparkInternalAccuName);
            if (!acc2.isEmpty()) {
                AccumulatorV2 acc = (AccumulatorV2)acc2.get();
                acc.add(metric);
            } else {
                log.debug("Fail to find spark internal accumulator matching key: %s prestoKey = %s ", new Object[]{sparkInternalAccuName, prestoKey});
            }
        }
    }
}

