/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.util;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.Session;
import com.facebook.presto.transaction.TransactionInfo;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.Future;

public class PrestoSparkTransactionUtils {
    private PrestoSparkTransactionUtils() {
    }

    public static void commit(Session session, TransactionManager transactionManager) {
        MoreFutures.getFutureValue((Future)transactionManager.asyncCommit(PrestoSparkTransactionUtils.getTransactionInfo(session, transactionManager).getTransactionId()));
    }

    public static void rollback(Session session, TransactionManager transactionManager) {
        MoreFutures.getFutureValue((Future)transactionManager.asyncAbort(PrestoSparkTransactionUtils.getTransactionInfo(session, transactionManager).getTransactionId()));
    }

    public static TransactionInfo getTransactionInfo(Session session, TransactionManager transactionManager) {
        Optional transaction = session.getTransactionId().flatMap(arg_0 -> ((TransactionManager)transactionManager).getOptionalTransactionInfo(arg_0));
        Preconditions.checkState((boolean)transaction.isPresent(), (Object)"transaction is not present");
        Preconditions.checkState((boolean)((TransactionInfo)transaction.get()).isAutoCommitContext(), (Object)"transaction doesn't have auto commit context enabled");
        return (TransactionInfo)transaction.get();
    }
}

