/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.server;

import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.Transport;
import com.facebook.drift.transport.netty.server.ResponseOrderingHandler;
import com.facebook.drift.transport.netty.server.ThriftServerHandler;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ThriftProtocolDetection
extends ByteToMessageDecoder {
    private static final int UNFRAMED_MESSAGE_FLAG = Integer.MIN_VALUE;
    private static final int UNFRAMED_MESSAGE_MASK = Integer.MIN_VALUE;
    private static final int BINARY_PROTOCOL_VERSION_MASK = -65536;
    private static final int BINARY_PROTOCOL_VERSION_1 = -2147418112;
    private static final int COMPACT_PROTOCOL_VERSION_MASK = -14745600;
    private static final int COMPACT_PROTOCOL_VERSION_1 = -2113863680;
    private static final int COMPACT_PROTOCOL_VERSION_2 = -2113798144;
    private static final int HEADER_MAGIC = 0xFFF0000;
    private static final int HEADER_MAGIC_MASK = -65536;
    private static final int HTTP_POST_MAGIC = Ints.fromBytes((byte)80, (byte)79, (byte)83, (byte)84);
    private final ThriftServerHandler thriftServerHandler;
    private final DataSize maxFrameSize;
    private final boolean assumeClientsSupportOutOfOrderResponses;

    public ThriftProtocolDetection(ThriftServerHandler thriftServerHandler, DataSize maxFrameSize, boolean assumeClientsSupportOutOfOrderResponses) {
        this.maxFrameSize = Objects.requireNonNull(maxFrameSize, "maxFrameSize is null");
        this.thriftServerHandler = Objects.requireNonNull(thriftServerHandler, "thriftServerHandler is null");
        this.assumeClientsSupportOutOfOrderResponses = assumeClientsSupportOutOfOrderResponses;
    }

    protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 4) {
            return;
        }
        int magic = in.getInt(in.readerIndex());
        if (magic == HTTP_POST_MAGIC) {
            in.clear();
            context.close();
            return;
        }
        if ((magic & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            Optional<Protocol> protocol = ThriftProtocolDetection.detectProtocol(magic);
            if (!protocol.isPresent()) {
                in.clear();
                context.close();
                return;
            }
            this.switchToTransport(context, Transport.UNFRAMED, protocol);
            return;
        }
        if (in.readableBytes() < 8) {
            return;
        }
        int magic2 = in.getInt(in.readerIndex() + 4);
        if ((magic2 & 0xFFFF0000) == 0xFFF0000) {
            this.switchToTransport(context, Transport.HEADER, Optional.empty());
            return;
        }
        Optional<Protocol> protocol = ThriftProtocolDetection.detectProtocol(magic2);
        if (!protocol.isPresent()) {
            in.clear();
            context.close();
            return;
        }
        this.switchToTransport(context, Transport.FRAMED, protocol);
    }

    private static Optional<Protocol> detectProtocol(int magic) {
        if ((magic & 0xFFFF0000) == -2147418112) {
            return Optional.of(Protocol.BINARY);
        }
        if ((magic & 0xFF1F0000) == -2113863680) {
            return Optional.of(Protocol.COMPACT);
        }
        if ((magic & 0xFF1F0000) == -2113798144) {
            return Optional.of(Protocol.FB_COMPACT);
        }
        return Optional.empty();
    }

    private void switchToTransport(ChannelHandlerContext context, Transport transport, Optional<Protocol> protocol) {
        ChannelPipeline pipeline = context.pipeline();
        transport.addFrameHandlers(pipeline, protocol, this.maxFrameSize, this.assumeClientsSupportOutOfOrderResponses);
        pipeline.addLast(new ChannelHandler[]{new ResponseOrderingHandler()});
        pipeline.addLast(new ChannelHandler[]{this.thriftServerHandler});
        pipeline.remove((ChannelHandler)this);
    }
}

