/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc.optimization.function;

import com.facebook.presto.plugin.jdbc.optimization.JdbcExpression;
import com.facebook.presto.plugin.jdbc.optimization.function.JdbcTranslationUtil;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;

public class OperatorTranslators {
    private OperatorTranslators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="bigint")
    public static JdbcExpression add(@SqlType(value="bigint") JdbcExpression left, @SqlType(value="bigint") JdbcExpression right) {
        return new JdbcExpression(JdbcTranslationUtil.infixOperation("+", left, right), JdbcTranslationUtil.forwardBindVariables(left, right));
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="bigint")
    public static JdbcExpression subtract(@SqlType(value="bigint") JdbcExpression left, @SqlType(value="bigint") JdbcExpression right) {
        return new JdbcExpression(JdbcTranslationUtil.infixOperation("-", left, right), JdbcTranslationUtil.forwardBindVariables(left, right));
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static JdbcExpression equal(@SqlType(value="bigint") JdbcExpression left, @SqlType(value="bigint") JdbcExpression right) {
        return new JdbcExpression(JdbcTranslationUtil.infixOperation("=", left, right), JdbcTranslationUtil.forwardBindVariables(left, right));
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static JdbcExpression notEqual(@SqlType(value="bigint") JdbcExpression left, @SqlType(value="bigint") JdbcExpression right) {
        return new JdbcExpression(JdbcTranslationUtil.infixOperation("<>", left, right), JdbcTranslationUtil.forwardBindVariables(left, right));
    }

    @ScalarFunction(value="not")
    @SqlType(value="boolean")
    public static JdbcExpression not(@SqlType(value="boolean") JdbcExpression expression) {
        return new JdbcExpression(String.format("(NOT(%s))", expression.getExpression()), expression.getBoundConstantValues());
    }
}

