/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnAssign;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnAssignFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.parquet.read.ParquetRecordReaderWrapper;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import parquet.hadoop.ParquetInputFormat;

public class VectorizedParquetInputFormat
extends FileInputFormat<NullWritable, VectorizedRowBatch>
implements VectorizedInputFormatInterface {
    private static final Log LOG = LogFactory.getLog(VectorizedParquetInputFormat.class);
    private final ParquetInputFormat<ArrayWritable> realInput;

    public VectorizedParquetInputFormat(ParquetInputFormat<ArrayWritable> realInput) {
        this.realInput = realInput;
    }

    public RecordReader<NullWritable, VectorizedRowBatch> getRecordReader(InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        try {
            return new VectorizedParquetRecordReader(this.realInput, (FileSplit)split, conf, reporter);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Cannot create a VectorizedParquetRecordReader", e);
        }
    }

    private static class VectorizedParquetRecordReader
    implements RecordReader<NullWritable, VectorizedRowBatch> {
        private static final Log LOG = LogFactory.getLog(VectorizedParquetRecordReader.class);
        private final ParquetRecordReaderWrapper internalReader;
        private VectorizedRowBatchCtx rbCtx;
        private ArrayWritable internalValues;
        private Void internalKey;
        private VectorColumnAssign[] assigners;

        public VectorizedParquetRecordReader(ParquetInputFormat<ArrayWritable> realInput, FileSplit split, JobConf conf, Reporter reporter) throws IOException, InterruptedException {
            this.internalReader = new ParquetRecordReaderWrapper(realInput, (InputSplit)split, conf, reporter);
            try {
                this.rbCtx = new VectorizedRowBatchCtx();
                this.rbCtx.init((Configuration)conf, split);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public NullWritable createKey() {
            this.internalKey = this.internalReader.createKey();
            return NullWritable.get();
        }

        public VectorizedRowBatch createValue() {
            VectorizedRowBatch outputBatch = null;
            try {
                outputBatch = this.rbCtx.createVectorizedRowBatch();
                this.internalValues = this.internalReader.createValue();
            }
            catch (HiveException e) {
                throw new RuntimeException("Error creating a batch", e);
            }
            return outputBatch;
        }

        public long getPos() throws IOException {
            return this.internalReader.getPos();
        }

        public void close() throws IOException {
            this.internalReader.close();
        }

        public float getProgress() throws IOException {
            return this.internalReader.getProgress();
        }

        public boolean next(NullWritable key, VectorizedRowBatch outputBatch) throws IOException {
            if (this.assigners != null) assert (outputBatch.numCols == this.assigners.length);
            outputBatch.reset();
            int maxSize = outputBatch.getMaxSize();
            try {
                while (outputBatch.size < maxSize) {
                    if (!this.internalReader.next(this.internalKey, this.internalValues)) {
                        outputBatch.endOfFile = true;
                        break;
                    }
                    Writable[] writables = this.internalValues.get();
                    if (null == this.assigners) {
                        this.assigners = VectorColumnAssignFactory.buildAssigners(outputBatch, writables);
                    }
                    for (int i = 0; i < writables.length; ++i) {
                        this.assigners[i].assignObjectValue(writables[i], outputBatch.size);
                    }
                    ++outputBatch.size;
                }
            }
            catch (HiveException e) {
                throw new RuntimeException(e);
            }
            return outputBatch.size > 0;
        }
    }
}

