/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorGroupByOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinOuterFilteredOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorSMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterStringOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.PreOrderWalker;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.TaskGraphWalker;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.VectorGroupByDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.udf.UDFAcos;
import org.apache.hadoop.hive.ql.udf.UDFAsin;
import org.apache.hadoop.hive.ql.udf.UDFAtan;
import org.apache.hadoop.hive.ql.udf.UDFBin;
import org.apache.hadoop.hive.ql.udf.UDFConv;
import org.apache.hadoop.hive.ql.udf.UDFCos;
import org.apache.hadoop.hive.ql.udf.UDFDayOfMonth;
import org.apache.hadoop.hive.ql.udf.UDFDegrees;
import org.apache.hadoop.hive.ql.udf.UDFExp;
import org.apache.hadoop.hive.ql.udf.UDFHex;
import org.apache.hadoop.hive.ql.udf.UDFHour;
import org.apache.hadoop.hive.ql.udf.UDFLength;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFLog10;
import org.apache.hadoop.hive.ql.udf.UDFLog2;
import org.apache.hadoop.hive.ql.udf.UDFMinute;
import org.apache.hadoop.hive.ql.udf.UDFMonth;
import org.apache.hadoop.hive.ql.udf.UDFRadians;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.UDFRegExp;
import org.apache.hadoop.hive.ql.udf.UDFSecond;
import org.apache.hadoop.hive.ql.udf.UDFSign;
import org.apache.hadoop.hive.ql.udf.UDFSin;
import org.apache.hadoop.hive.ql.udf.UDFSqrt;
import org.apache.hadoop.hive.ql.udf.UDFSubstr;
import org.apache.hadoop.hive.ql.udf.UDFTan;
import org.apache.hadoop.hive.ql.udf.UDFToBoolean;
import org.apache.hadoop.hive.ql.udf.UDFToByte;
import org.apache.hadoop.hive.ql.udf.UDFToDouble;
import org.apache.hadoop.hive.ql.udf.UDFToFloat;
import org.apache.hadoop.hive.ql.udf.UDFToInteger;
import org.apache.hadoop.hive.ql.udf.UDFToLong;
import org.apache.hadoop.hive.ql.udf.UDFToShort;
import org.apache.hadoop.hive.ql.udf.UDFToString;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCeil;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcat;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateAdd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateDiff;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateSub;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFElt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFloor;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInitCap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPDivide;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMinus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMultiply;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPosMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToIntervalDayTime;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToIntervalYearMonth;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class Vectorizer
implements PhysicalPlanResolver {
    protected static final transient Log LOG = LogFactory.getLog(Vectorizer.class);
    Pattern supportedDataTypesPattern;
    List<Task<? extends Serializable>> vectorizableTasks = new ArrayList<Task<? extends Serializable>>();
    Set<Class<?>> supportedGenericUDFs = new HashSet();
    Set<String> supportedAggregationUdfs = new HashSet<String>();
    private PhysicalContext physicalContext = null;
    private HiveConf hiveConf;

    public Vectorizer() {
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append("int");
        patternBuilder.append("|smallint");
        patternBuilder.append("|tinyint");
        patternBuilder.append("|bigint");
        patternBuilder.append("|integer");
        patternBuilder.append("|long");
        patternBuilder.append("|short");
        patternBuilder.append("|timestamp");
        patternBuilder.append("|interval_year_month");
        patternBuilder.append("|interval_day_time");
        patternBuilder.append("|boolean");
        patternBuilder.append("|binary");
        patternBuilder.append("|string");
        patternBuilder.append("|byte");
        patternBuilder.append("|float");
        patternBuilder.append("|double");
        patternBuilder.append("|date");
        patternBuilder.append("|void");
        patternBuilder.append("|decimal.*");
        patternBuilder.append("|char.*");
        patternBuilder.append("|varchar.*");
        this.supportedDataTypesPattern = Pattern.compile(patternBuilder.toString());
        this.supportedGenericUDFs.add(GenericUDFOPPlus.class);
        this.supportedGenericUDFs.add(GenericUDFOPMinus.class);
        this.supportedGenericUDFs.add(GenericUDFOPMultiply.class);
        this.supportedGenericUDFs.add(GenericUDFOPDivide.class);
        this.supportedGenericUDFs.add(GenericUDFOPMod.class);
        this.supportedGenericUDFs.add(GenericUDFOPNegative.class);
        this.supportedGenericUDFs.add(GenericUDFOPPositive.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqualOrLessThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqualOrGreaterThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPGreaterThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPLessThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPNot.class);
        this.supportedGenericUDFs.add(GenericUDFOPNotEqual.class);
        this.supportedGenericUDFs.add(GenericUDFOPNotNull.class);
        this.supportedGenericUDFs.add(GenericUDFOPNull.class);
        this.supportedGenericUDFs.add(GenericUDFOPOr.class);
        this.supportedGenericUDFs.add(GenericUDFOPAnd.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqual.class);
        this.supportedGenericUDFs.add(UDFLength.class);
        this.supportedGenericUDFs.add(UDFYear.class);
        this.supportedGenericUDFs.add(UDFMonth.class);
        this.supportedGenericUDFs.add(UDFDayOfMonth.class);
        this.supportedGenericUDFs.add(UDFHour.class);
        this.supportedGenericUDFs.add(UDFMinute.class);
        this.supportedGenericUDFs.add(UDFSecond.class);
        this.supportedGenericUDFs.add(UDFWeekOfYear.class);
        this.supportedGenericUDFs.add(GenericUDFToUnixTimeStamp.class);
        this.supportedGenericUDFs.add(GenericUDFDateAdd.class);
        this.supportedGenericUDFs.add(GenericUDFDateSub.class);
        this.supportedGenericUDFs.add(GenericUDFDate.class);
        this.supportedGenericUDFs.add(GenericUDFDateDiff.class);
        this.supportedGenericUDFs.add(UDFLike.class);
        this.supportedGenericUDFs.add(UDFRegExp.class);
        this.supportedGenericUDFs.add(UDFSubstr.class);
        this.supportedGenericUDFs.add(GenericUDFLTrim.class);
        this.supportedGenericUDFs.add(GenericUDFRTrim.class);
        this.supportedGenericUDFs.add(GenericUDFTrim.class);
        this.supportedGenericUDFs.add(UDFSin.class);
        this.supportedGenericUDFs.add(UDFCos.class);
        this.supportedGenericUDFs.add(UDFTan.class);
        this.supportedGenericUDFs.add(UDFAsin.class);
        this.supportedGenericUDFs.add(UDFAcos.class);
        this.supportedGenericUDFs.add(UDFAtan.class);
        this.supportedGenericUDFs.add(UDFDegrees.class);
        this.supportedGenericUDFs.add(UDFRadians.class);
        this.supportedGenericUDFs.add(GenericUDFFloor.class);
        this.supportedGenericUDFs.add(GenericUDFCeil.class);
        this.supportedGenericUDFs.add(UDFExp.class);
        this.supportedGenericUDFs.add(UDFLn.class);
        this.supportedGenericUDFs.add(UDFLog2.class);
        this.supportedGenericUDFs.add(UDFLog10.class);
        this.supportedGenericUDFs.add(UDFLog.class);
        this.supportedGenericUDFs.add(GenericUDFPower.class);
        this.supportedGenericUDFs.add(GenericUDFRound.class);
        this.supportedGenericUDFs.add(GenericUDFPosMod.class);
        this.supportedGenericUDFs.add(UDFSqrt.class);
        this.supportedGenericUDFs.add(UDFSign.class);
        this.supportedGenericUDFs.add(UDFRand.class);
        this.supportedGenericUDFs.add(UDFBin.class);
        this.supportedGenericUDFs.add(UDFHex.class);
        this.supportedGenericUDFs.add(UDFConv.class);
        this.supportedGenericUDFs.add(GenericUDFLower.class);
        this.supportedGenericUDFs.add(GenericUDFUpper.class);
        this.supportedGenericUDFs.add(GenericUDFConcat.class);
        this.supportedGenericUDFs.add(GenericUDFAbs.class);
        this.supportedGenericUDFs.add(GenericUDFBetween.class);
        this.supportedGenericUDFs.add(GenericUDFIn.class);
        this.supportedGenericUDFs.add(GenericUDFCase.class);
        this.supportedGenericUDFs.add(GenericUDFWhen.class);
        this.supportedGenericUDFs.add(GenericUDFCoalesce.class);
        this.supportedGenericUDFs.add(GenericUDFElt.class);
        this.supportedGenericUDFs.add(GenericUDFInitCap.class);
        this.supportedGenericUDFs.add(UDFToLong.class);
        this.supportedGenericUDFs.add(UDFToInteger.class);
        this.supportedGenericUDFs.add(UDFToShort.class);
        this.supportedGenericUDFs.add(UDFToByte.class);
        this.supportedGenericUDFs.add(UDFToBoolean.class);
        this.supportedGenericUDFs.add(UDFToFloat.class);
        this.supportedGenericUDFs.add(UDFToDouble.class);
        this.supportedGenericUDFs.add(UDFToString.class);
        this.supportedGenericUDFs.add(GenericUDFTimestamp.class);
        this.supportedGenericUDFs.add(GenericUDFToDecimal.class);
        this.supportedGenericUDFs.add(GenericUDFToDate.class);
        this.supportedGenericUDFs.add(GenericUDFToChar.class);
        this.supportedGenericUDFs.add(GenericUDFToVarchar.class);
        this.supportedGenericUDFs.add(GenericUDFToIntervalYearMonth.class);
        this.supportedGenericUDFs.add(GenericUDFToIntervalDayTime.class);
        this.supportedGenericUDFs.add(GenericUDFIf.class);
        this.supportedAggregationUdfs.add("min");
        this.supportedAggregationUdfs.add("max");
        this.supportedAggregationUdfs.add("count");
        this.supportedAggregationUdfs.add("sum");
        this.supportedAggregationUdfs.add("avg");
        this.supportedAggregationUdfs.add("variance");
        this.supportedAggregationUdfs.add("var_pop");
        this.supportedAggregationUdfs.add("var_samp");
        this.supportedAggregationUdfs.add("std");
        this.supportedAggregationUdfs.add("stddev");
        this.supportedAggregationUdfs.add("stddev_pop");
        this.supportedAggregationUdfs.add("stddev_samp");
    }

    @Override
    public PhysicalContext resolve(PhysicalContext physicalContext) throws SemanticException {
        this.physicalContext = physicalContext;
        this.hiveConf = physicalContext.getConf();
        boolean vectorPath = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED);
        if (!vectorPath) {
            LOG.info("Vectorization is disabled");
            return physicalContext;
        }
        VectorizationDispatcher disp = new VectorizationDispatcher(physicalContext);
        TaskGraphWalker ogw = new TaskGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(physicalContext.getRootTasks());
        ogw.startWalking(topNodes, null);
        return physicalContext;
    }

    boolean validateMapWorkOperator(Operator<? extends OperatorDesc> op, MapWork mWork, boolean isTez) {
        boolean ret = false;
        switch (op.getType()) {
            case MAPJOIN: {
                if (op instanceof MapJoinOperator) {
                    ret = this.validateMapJoinOperator((MapJoinOperator)op);
                    break;
                }
                if (!(op instanceof SMBMapJoinOperator)) break;
                ret = this.validateSMBMapJoinOperator((SMBMapJoinOperator)op);
                break;
            }
            case GROUPBY: {
                ret = this.validateGroupByOperator((GroupByOperator)op, false, isTez);
                break;
            }
            case FILTER: {
                ret = this.validateFilterOperator((FilterOperator)op);
                break;
            }
            case SELECT: {
                ret = this.validateSelectOperator((SelectOperator)op);
                break;
            }
            case REDUCESINK: {
                ret = this.validateReduceSinkOperator((ReduceSinkOperator)op);
                break;
            }
            case TABLESCAN: {
                ret = this.validateTableScanOperator((TableScanOperator)op, mWork);
                break;
            }
            case FILESINK: 
            case LIMIT: 
            case EVENT: {
                ret = true;
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    boolean validateReduceWorkOperator(Operator<? extends OperatorDesc> op) {
        boolean ret = false;
        switch (op.getType()) {
            case MAPJOIN: {
                if (op instanceof MapJoinOperator) {
                    ret = this.validateMapJoinOperator((MapJoinOperator)op);
                    break;
                }
                if (!(op instanceof SMBMapJoinOperator)) break;
                ret = this.validateSMBMapJoinOperator((SMBMapJoinOperator)op);
                break;
            }
            case GROUPBY: {
                if (HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCE_GROUPBY_ENABLED)) {
                    ret = this.validateGroupByOperator((GroupByOperator)op, true, true);
                    break;
                }
                ret = false;
                break;
            }
            case FILTER: {
                ret = this.validateFilterOperator((FilterOperator)op);
                break;
            }
            case SELECT: {
                ret = this.validateSelectOperator((SelectOperator)op);
                break;
            }
            case REDUCESINK: {
                ret = this.validateReduceSinkOperator((ReduceSinkOperator)op);
                break;
            }
            case FILESINK: {
                ret = this.validateFileSinkOperator((FileSinkOperator)op);
                break;
            }
            case LIMIT: 
            case EVENT: {
                ret = true;
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    public Boolean nonVectorizableChildOfGroupBy(Operator<? extends OperatorDesc> op) {
        Operator<? extends OperatorDesc> currentOp = op;
        while (currentOp.getParentOperators().size() > 0) {
            if (!(currentOp = currentOp.getParentOperators().get(0)).getType().equals((Object)OperatorType.GROUPBY)) continue;
            GroupByDesc desc = (GroupByDesc)currentOp.getConf();
            boolean isVectorOutput = desc.getVectorDesc().isVectorOutput();
            if (isVectorOutput) {
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean validateSMBMapJoinOperator(SMBMapJoinOperator op) {
        SMBJoinDesc desc = (SMBJoinDesc)op.getConf();
        return this.validateMapJoinDesc(desc);
    }

    private boolean validateTableScanOperator(TableScanOperator op, MapWork mWork) {
        TableScanDesc desc = (TableScanDesc)op.getConf();
        if (desc.isGatherStats()) {
            return false;
        }
        String columns = "";
        String types = "";
        String partitionColumns = "";
        String partitionTypes = "";
        boolean haveInfo = false;
        LinkedHashMap<String, PartitionDesc> partitionDescs = mWork.getPathToPartitionInfo();
        for (Map.Entry<String, PartitionDesc> entry : partitionDescs.entrySet()) {
            PartitionDesc partDesc = entry.getValue();
            if (partDesc.getPartSpec() == null || partDesc.getPartSpec().isEmpty()) continue;
            Properties partProps = partDesc.getProperties();
            if (!haveInfo) {
                columns = partProps.getProperty("columns");
                types = partProps.getProperty("columns.types");
                partitionColumns = partProps.getProperty("partition_columns");
                partitionTypes = partProps.getProperty("partition_columns.types");
                haveInfo = true;
                continue;
            }
            String nextColumns = partProps.getProperty("columns");
            String nextTypes = partProps.getProperty("columns.types");
            String nextPartitionColumns = partProps.getProperty("partition_columns");
            String nextPartitionTypes = partProps.getProperty("partition_columns.types");
            if (!columns.equalsIgnoreCase(nextColumns)) {
                LOG.info(String.format("Could not vectorize partition %s.  Its column names %s do not match the other column names %s", entry.getKey(), nextColumns, columns));
                return false;
            }
            if (!types.equalsIgnoreCase(nextTypes)) {
                LOG.info(String.format("Could not vectorize partition %s.  Its column types %s do not match the other column types %s", entry.getKey(), nextTypes, types));
                return false;
            }
            if (!partitionColumns.equalsIgnoreCase(nextPartitionColumns)) {
                LOG.info(String.format("Could not vectorize partition %s.  Its partition column names %s do not match the other partition column names %s", entry.getKey(), nextPartitionColumns, partitionColumns));
                return false;
            }
            if (partitionTypes.equalsIgnoreCase(nextPartitionTypes)) continue;
            LOG.info(String.format("Could not vectorize partition %s.  Its partition column types %s do not match the other partition column types %s", entry.getKey(), nextPartitionTypes, partitionTypes));
            return false;
        }
        return true;
    }

    private boolean validateMapJoinOperator(MapJoinOperator op) {
        MapJoinDesc desc = (MapJoinDesc)op.getConf();
        return this.validateMapJoinDesc(desc);
    }

    private boolean validateMapJoinDesc(MapJoinDesc desc) {
        byte posBigTable = (byte)desc.getPosBigTable();
        List<ExprNodeDesc> filterExprs = desc.getFilters().get(posBigTable);
        if (!this.validateExprNodeDesc(filterExprs, VectorExpressionDescriptor.Mode.FILTER)) {
            LOG.info("Cannot vectorize map work filter expression");
            return false;
        }
        List<ExprNodeDesc> keyExprs = desc.getKeys().get(posBigTable);
        if (!this.validateExprNodeDesc(keyExprs)) {
            LOG.info("Cannot vectorize map work key expression");
            return false;
        }
        List<ExprNodeDesc> valueExprs = desc.getExprs().get(posBigTable);
        if (!this.validateExprNodeDesc(valueExprs)) {
            LOG.info("Cannot vectorize map work value expression");
            return false;
        }
        return true;
    }

    private boolean validateReduceSinkOperator(ReduceSinkOperator op) {
        ArrayList<ExprNodeDesc> keyDescs = ((ReduceSinkDesc)op.getConf()).getKeyCols();
        ArrayList<ExprNodeDesc> partitionDescs = ((ReduceSinkDesc)op.getConf()).getPartitionCols();
        ArrayList<ExprNodeDesc> valueDesc = ((ReduceSinkDesc)op.getConf()).getValueCols();
        return this.validateExprNodeDesc(keyDescs) && this.validateExprNodeDesc(partitionDescs) && this.validateExprNodeDesc(valueDesc);
    }

    private boolean validateSelectOperator(SelectOperator op) {
        List<ExprNodeDesc> descList = ((SelectDesc)op.getConf()).getColList();
        for (ExprNodeDesc desc : descList) {
            boolean ret = this.validateExprNodeDesc(desc);
            if (ret) continue;
            LOG.info("Cannot vectorize select expression: " + desc.toString());
            return false;
        }
        return true;
    }

    private boolean validateFilterOperator(FilterOperator op) {
        ExprNodeDesc desc = ((FilterDesc)op.getConf()).getPredicate();
        return this.validateExprNodeDesc(desc, VectorExpressionDescriptor.Mode.FILTER);
    }

    private boolean validateGroupByOperator(GroupByOperator op, boolean isReduce, boolean isTez) {
        GroupByDesc desc = (GroupByDesc)op.getConf();
        VectorGroupByDesc vectorDesc = desc.getVectorDesc();
        if (desc.isGroupingSetsPresent()) {
            LOG.info("Grouping sets not supported in vector mode");
            return false;
        }
        if (desc.pruneGroupingSetId()) {
            LOG.info("Pruning grouping set id not supported in vector mode");
            return false;
        }
        boolean ret = this.validateExprNodeDesc(desc.getKeys());
        if (!ret) {
            LOG.info("Cannot vectorize groupby key expression");
            return false;
        }
        ret = this.validateAggregationDesc(desc.getAggregators(), isReduce);
        if (!ret) {
            LOG.info("Cannot vectorize groupby aggregate expression");
            return false;
        }
        if (isReduce) {
            if (desc.isDistinct()) {
                LOG.info("Distinct not supported in reduce vector mode");
                return false;
            }
            if (desc.getMode() != GroupByDesc.Mode.COMPLETE && desc.getMode() != GroupByDesc.Mode.PARTIAL1 && desc.getMode() != GroupByDesc.Mode.PARTIAL2 && desc.getMode() != GroupByDesc.Mode.MERGEPARTIAL) {
                LOG.info("Reduce vector mode not supported when input for GROUP BY not sorted");
                return false;
            }
            LOG.info("Reduce GROUP BY mode is " + desc.getMode().name());
            if (!this.aggregatorsOutputIsPrimitive(desc.getAggregators(), isReduce)) {
                LOG.info("Reduce vector mode only supported when aggregate outputs are primitive types");
                return false;
            }
            if (desc.getKeys().size() > 0) {
                if (op.getParentOperators().size() > 0) {
                    LOG.info("Reduce vector mode can only handle a key group GROUP BY operator when it is fed by reduce-shuffle");
                    return false;
                }
                LOG.info("Reduce-side GROUP BY will process key groups");
                vectorDesc.setVectorGroupBatches(true);
            } else {
                LOG.info("Reduce-side GROUP BY will do global aggregation");
            }
            vectorDesc.setVectorOutput(true);
            vectorDesc.setIsReduce(true);
        }
        return true;
    }

    private boolean validateFileSinkOperator(FileSinkOperator op) {
        return true;
    }

    private boolean validateExprNodeDesc(List<ExprNodeDesc> descs) {
        return this.validateExprNodeDesc(descs, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    private boolean validateExprNodeDesc(List<ExprNodeDesc> descs, VectorExpressionDescriptor.Mode mode) {
        for (ExprNodeDesc d : descs) {
            boolean ret = this.validateExprNodeDesc(d, mode);
            if (ret) continue;
            return false;
        }
        return true;
    }

    private boolean validateAggregationDesc(List<AggregationDesc> descs, boolean isReduce) {
        for (AggregationDesc d : descs) {
            boolean ret = this.validateAggregationDesc(d, isReduce);
            if (ret) continue;
            return false;
        }
        return true;
    }

    private boolean validateExprNodeDescRecursive(ExprNodeDesc desc, VectorExpressionDescriptor.Mode mode) {
        ExprNodeGenericFuncDesc d;
        boolean r;
        ExprNodeColumnDesc c;
        if (desc instanceof ExprNodeColumnDesc && VirtualColumn.VIRTUAL_COLUMN_NAMES.contains((c = (ExprNodeColumnDesc)desc).getColumn())) {
            LOG.info("Cannot vectorize virtual column " + c.getColumn());
            return false;
        }
        String typeName = desc.getTypeInfo().getTypeName();
        boolean ret = this.validateDataType(typeName, mode);
        if (!ret) {
            LOG.info("Cannot vectorize " + desc.toString() + " of type " + typeName);
            return false;
        }
        if (desc instanceof ExprNodeGenericFuncDesc && !(r = this.validateGenericUdf(d = (ExprNodeGenericFuncDesc)desc))) {
            return false;
        }
        if (desc.getChildren() != null) {
            for (ExprNodeDesc d2 : desc.getChildren()) {
                boolean r2 = this.validateExprNodeDescRecursive(d2, VectorExpressionDescriptor.Mode.FILTER);
                if (r2) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateExprNodeDesc(ExprNodeDesc desc) {
        return this.validateExprNodeDesc(desc, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    boolean validateExprNodeDesc(ExprNodeDesc desc, VectorExpressionDescriptor.Mode mode) {
        if (!this.validateExprNodeDescRecursive(desc, mode)) {
            return false;
        }
        try {
            ValidatorVectorizationContext vc = new ValidatorVectorizationContext();
            if (vc.getVectorExpression(desc, mode) == null) {
                LOG.info("getVectorExpression returned null");
                return false;
            }
        }
        catch (Exception e) {
            LOG.info("Failed to vectorize", e);
            return false;
        }
        return true;
    }

    private boolean validateGenericUdf(ExprNodeGenericFuncDesc genericUDFExpr) {
        if (VectorizationContext.isCustomUDF(genericUDFExpr)) {
            return true;
        }
        GenericUDF genericUDF = genericUDFExpr.getGenericUDF();
        if (genericUDF instanceof GenericUDFBridge) {
            Class<? extends UDF> udf = ((GenericUDFBridge)genericUDF).getUdfClass();
            return this.supportedGenericUDFs.contains(udf);
        }
        return this.supportedGenericUDFs.contains(genericUDF.getClass());
    }

    private boolean validateAggregationDesc(AggregationDesc aggDesc, boolean isReduce) {
        String udfName = aggDesc.getGenericUDAFName().toLowerCase();
        if (!this.supportedAggregationUdfs.contains(udfName)) {
            LOG.info("Cannot vectorize groupby aggregate expression: UDF " + udfName + " not supported");
            return false;
        }
        if (aggDesc.getParameters() != null && !this.validateExprNodeDesc(aggDesc.getParameters())) {
            LOG.info("Cannot vectorize groupby aggregate expression: UDF parameters not supported");
            return false;
        }
        try {
            ValidatorVectorizationContext vc = new ValidatorVectorizationContext();
            if (vc.getAggregatorExpression(aggDesc, isReduce) == null) {
                LOG.info("getAggregatorExpression returned null");
                return false;
            }
        }
        catch (Exception e) {
            LOG.info("Failed to vectorize", e);
            return false;
        }
        return true;
    }

    private boolean aggregatorsOutputIsPrimitive(List<AggregationDesc> descs, boolean isReduce) {
        for (AggregationDesc d : descs) {
            boolean ret = this.aggregatorsOutputIsPrimitive(d, isReduce);
            if (ret) continue;
            return false;
        }
        return true;
    }

    private boolean aggregatorsOutputIsPrimitive(AggregationDesc aggDesc, boolean isReduce) {
        VectorAggregateExpression vectorAggrExpr;
        ValidatorVectorizationContext vc = new ValidatorVectorizationContext();
        try {
            vectorAggrExpr = vc.getAggregatorExpression(aggDesc, isReduce);
        }
        catch (Exception e) {
            LOG.info("Vectorization of aggreation should have succeeded ", e);
            return false;
        }
        ObjectInspector outputObjInspector = vectorAggrExpr.getOutputObjectInspector();
        return outputObjInspector.getCategory() == ObjectInspector.Category.PRIMITIVE;
    }

    private boolean validateDataType(String type, VectorExpressionDescriptor.Mode mode) {
        boolean result = this.supportedDataTypesPattern.matcher(type = type.toLowerCase()).matches();
        if (result && mode == VectorExpressionDescriptor.Mode.PROJECTION && type.equals("void")) {
            return false;
        }
        return result;
    }

    private VectorizationContext getVectorizationContext(RowSchema rowSchema, String contextName, Map<Integer, String> typeNameMap) {
        VectorizationContext vContext = new VectorizationContext(contextName);
        int i = 0;
        for (ColumnInfo c : rowSchema.getSignature()) {
            if (this.isVirtualColumn(c)) continue;
            vContext.addInitialColumn(c.getInternalName());
            typeNameMap.put(i, c.getTypeName());
            ++i;
        }
        vContext.finishedAddingInitialColumns();
        return vContext;
    }

    private void fixupParentChildOperators(Operator<? extends OperatorDesc> op, Operator<? extends OperatorDesc> vectorOp) {
        if (op.getParentOperators() != null) {
            vectorOp.setParentOperators(op.getParentOperators());
            for (Operator<OperatorDesc> p : op.getParentOperators()) {
                p.replaceChild(op, vectorOp);
            }
        }
        if (op.getChildOperators() != null) {
            vectorOp.setChildOperators(op.getChildOperators());
            for (Operator<OperatorDesc> c : op.getChildOperators()) {
                c.replaceParent(op, vectorOp);
            }
        }
    }

    private boolean isBigTableOnlyResults(MapJoinDesc desc) {
        int smallTableIndicesSize;
        int[] smallTableIndices;
        Byte[] order = desc.getTagOrder();
        byte posBigTable = (byte)desc.getPosBigTable();
        Byte posSingleVectorMapJoinSmallTable = order[0] == posBigTable ? order[1] : order[0];
        List<ExprNodeDesc> smallTableExprs = desc.getExprs().get(posSingleVectorMapJoinSmallTable);
        if (desc.getValueIndices() != null && desc.getValueIndices().get(posSingleVectorMapJoinSmallTable) != null) {
            smallTableIndices = desc.getValueIndices().get(posSingleVectorMapJoinSmallTable);
            LOG.info("Vectorizer isBigTableOnlyResults smallTableIndices " + Arrays.toString(smallTableIndices));
            smallTableIndicesSize = smallTableIndices.length;
        } else {
            smallTableIndices = null;
            LOG.info("Vectorizer isBigTableOnlyResults smallTableIndices EMPTY");
            smallTableIndicesSize = 0;
        }
        List<Integer> smallTableRetainList = desc.getRetainList().get(posSingleVectorMapJoinSmallTable);
        LOG.info("Vectorizer isBigTableOnlyResults smallTableRetainList " + smallTableRetainList);
        int smallTableRetainSize = smallTableRetainList.size();
        if (smallTableIndicesSize > 0) {
            for (int i = 0; i < smallTableIndicesSize; ++i) {
                if (smallTableIndices[i] >= 0) continue;
                LOG.info("Vectorizer isBigTableOnlyResults smallTableIndices[i] < 0 returning false");
                return false;
            }
        } else if (smallTableRetainSize > 0) {
            LOG.info("Vectorizer isBigTableOnlyResults smallTableRetainSize > 0 returning false");
            return false;
        }
        LOG.info("Vectorizer isBigTableOnlyResults returning true");
        return true;
    }

    Operator<? extends OperatorDesc> specializeMapJoinOperator(Operator<? extends OperatorDesc> op, VectorizationContext vContext, MapJoinDesc desc) throws HiveException {
        Operator<OperatorDesc> vectorOp = null;
        Class opClass = null;
        boolean isOuterJoin = !desc.getNoOuterJoin();
        VectorMapJoinDesc.HashTableImplementationType hashTableImplementationType = VectorMapJoinDesc.HashTableImplementationType.NONE;
        VectorMapJoinDesc.HashTableKind hashTableKind = VectorMapJoinDesc.HashTableKind.NONE;
        VectorMapJoinDesc.HashTableKeyType hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.NONE;
        hashTableImplementationType = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_FAST_HASHTABLE_ENABLED) ? VectorMapJoinDesc.HashTableImplementationType.FAST : VectorMapJoinDesc.HashTableImplementationType.OPTIMIZED;
        int joinType = desc.getConds()[0].getType();
        boolean isInnerBigOnly = false;
        if (joinType == 0 && this.isBigTableOnlyResults(desc)) {
            isInnerBigOnly = true;
        }
        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.MULTI_KEY;
        if (!HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_MULTIKEY_ONLY_ENABLED)) {
            byte posBigTable = (byte)desc.getPosBigTable();
            Map<Byte, List<ExprNodeDesc>> keyExprs = desc.getKeys();
            List<ExprNodeDesc> bigTableKeyExprs = keyExprs.get(posBigTable);
            if (bigTableKeyExprs.size() == 1) {
                String typeName = bigTableKeyExprs.get(0).getTypeString();
                LOG.info("Vectorizer vectorizeOperator map join typeName " + typeName);
                if (typeName.equals("boolean")) {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.BOOLEAN;
                } else if (typeName.equals("tinyint")) {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.BYTE;
                } else if (typeName.equals("smallint")) {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.SHORT;
                } else if (typeName.equals("int")) {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.INT;
                } else if (typeName.equals("bigint") || typeName.equals("long")) {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.LONG;
                } else if (VectorizationContext.isStringFamily(typeName)) {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.STRING;
                }
            }
        }
        switch (joinType) {
            case 0: {
                if (!isInnerBigOnly) {
                    hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_MAP;
                    break;
                }
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_MULTISET;
                break;
            }
            case 1: 
            case 2: {
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_MAP;
                break;
            }
            case 5: {
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_SET;
                break;
            }
            default: {
                throw new HiveException("Unknown join type " + joinType);
            }
        }
        LOG.info("Vectorizer vectorizeOperator map join hashTableKind " + hashTableKind.name() + " hashTableKeyType " + hashTableKeyType.name());
        block5 : switch (hashTableKeyType) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                switch (joinType) {
                    case 0: {
                        if (!isInnerBigOnly) {
                            opClass = VectorMapJoinInnerLongOperator.class;
                            break block5;
                        }
                        opClass = VectorMapJoinInnerBigOnlyLongOperator.class;
                        break block5;
                    }
                    case 1: 
                    case 2: {
                        opClass = VectorMapJoinOuterLongOperator.class;
                        break block5;
                    }
                    case 5: {
                        opClass = VectorMapJoinLeftSemiLongOperator.class;
                        break block5;
                    }
                }
                throw new HiveException("Unknown join type " + joinType);
            }
            case STRING: {
                switch (joinType) {
                    case 0: {
                        if (!isInnerBigOnly) {
                            opClass = VectorMapJoinInnerStringOperator.class;
                            break block5;
                        }
                        opClass = VectorMapJoinInnerBigOnlyStringOperator.class;
                        break block5;
                    }
                    case 1: 
                    case 2: {
                        opClass = VectorMapJoinOuterStringOperator.class;
                        break block5;
                    }
                    case 5: {
                        opClass = VectorMapJoinLeftSemiStringOperator.class;
                        break block5;
                    }
                }
                throw new HiveException("Unknown join type " + joinType);
            }
            case MULTI_KEY: {
                switch (joinType) {
                    case 0: {
                        if (!isInnerBigOnly) {
                            opClass = VectorMapJoinInnerMultiKeyOperator.class;
                            break block5;
                        }
                        opClass = VectorMapJoinInnerBigOnlyMultiKeyOperator.class;
                        break block5;
                    }
                    case 1: 
                    case 2: {
                        opClass = VectorMapJoinOuterMultiKeyOperator.class;
                        break block5;
                    }
                    case 5: {
                        opClass = VectorMapJoinLeftSemiMultiKeyOperator.class;
                        break block5;
                    }
                }
                throw new HiveException("Unknown join type " + joinType);
            }
        }
        vectorOp = OperatorFactory.getVectorOperator(opClass, op.getConf(), vContext);
        LOG.info("Vectorizer vectorizeOperator map join class " + vectorOp.getClass().getSimpleName());
        boolean minMaxEnabled = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_MINMAX_ENABLED);
        VectorMapJoinDesc vectorDesc = desc.getVectorDesc();
        vectorDesc.setHashTableImplementationType(hashTableImplementationType);
        vectorDesc.setHashTableKind(hashTableKind);
        vectorDesc.setHashTableKeyType(hashTableKeyType);
        vectorDesc.setMinMaxEnabled(minMaxEnabled);
        return vectorOp;
    }

    private boolean onExpressionHasNullSafes(MapJoinDesc desc) {
        boolean[] nullSafes;
        for (boolean nullSafe : nullSafes = desc.getNullSafes()) {
            if (!nullSafe) continue;
            return true;
        }
        return false;
    }

    private boolean canSpecializeMapJoin(Operator<? extends OperatorDesc> op, MapJoinDesc desc, boolean isTez) {
        boolean specialize = false;
        if (op instanceof MapJoinOperator && HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_ENABLED) && isTez && desc.getConds().length == 1 && !this.onExpressionHasNullSafes(desc)) {
            specialize = true;
            if (!HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_FAST_HASHTABLE_ENABLED)) {
                if (!HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVEMAPJOINUSEOPTIMIZEDTABLE)) {
                    specialize = false;
                } else {
                    byte posBigTable = (byte)desc.getPosBigTable();
                    Map<Byte, List<ExprNodeDesc>> keyExprs = desc.getKeys();
                    List<ExprNodeDesc> bigTableKeyExprs = keyExprs.get(posBigTable);
                    for (ExprNodeDesc exprNodeDesc : bigTableKeyExprs) {
                        String typeName = exprNodeDesc.getTypeString();
                        if (MapJoinKey.isSupportedField(typeName)) continue;
                        specialize = false;
                        break;
                    }
                }
            } else if (HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVEUSEHYBRIDGRACEHASHJOIN)) {
                specialize = false;
            }
        }
        return specialize;
    }

    Operator<? extends OperatorDesc> vectorizeOperator(Operator<? extends OperatorDesc> op, VectorizationContext vContext, boolean isTez) throws HiveException {
        Operator<? extends OperatorDesc> vectorOp = null;
        switch (op.getType()) {
            case MAPJOIN: {
                MapJoinDesc desc = (MapJoinDesc)op.getConf();
                boolean specialize = this.canSpecializeMapJoin(op, desc, isTez);
                if (!specialize) {
                    Class opClass = null;
                    if (op instanceof MapJoinOperator) {
                        boolean isOuterAndFiltered;
                        List<ExprNodeDesc> bigTableFilters = desc.getFilters().get((byte)desc.getPosBigTable());
                        boolean bl = isOuterAndFiltered = !desc.isNoOuterJoin() && bigTableFilters.size() > 0;
                        opClass = !isOuterAndFiltered ? VectorMapJoinOperator.class : VectorMapJoinOuterFilteredOperator.class;
                    } else if (op instanceof SMBMapJoinOperator) {
                        opClass = VectorSMBMapJoinOperator.class;
                    }
                    vectorOp = OperatorFactory.getVectorOperator(opClass, op.getConf(), vContext);
                    break;
                }
                vectorOp = this.specializeMapJoinOperator(op, vContext, desc);
                break;
            }
            case GROUPBY: 
            case FILTER: 
            case SELECT: 
            case REDUCESINK: 
            case FILESINK: 
            case LIMIT: 
            case EVENT: 
            case EXTRACT: {
                vectorOp = OperatorFactory.getVectorOperator(op.getConf(), vContext);
                break;
            }
            default: {
                vectorOp = op;
            }
        }
        LOG.info("vectorizeOperator " + (vectorOp == null ? "NULL" : vectorOp.getClass().getName()));
        LOG.info("vectorizeOperator " + (vectorOp == null || vectorOp.getConf() == null ? "NULL" : vectorOp.getConf().getClass().getName()));
        if (vectorOp != op) {
            this.fixupParentChildOperators(op, vectorOp);
            ((AbstractOperatorDesc)vectorOp.getConf()).setVectorMode(true);
        }
        return vectorOp;
    }

    private boolean isVirtualColumn(ColumnInfo column) {
        return VirtualColumn.VIRTUAL_COLUMN_NAMES.contains(column.getInternalName());
    }

    public void debugDisplayAllMaps(BaseWork work) {
        Map<String, Integer> columnNameMap = work.getVectorColumnNameMap();
        Map<Integer, String> columnTypeMap = work.getVectorColumnTypeMap();
        Map<Integer, String> scratchColumnTypeMap = work.getVectorScratchColumnTypeMap();
        LOG.debug("debugDisplayAllMaps columnNameMap " + columnNameMap.toString());
        LOG.debug("debugDisplayAllMaps columnTypeMap " + columnTypeMap.toString());
        LOG.debug("debugDisplayAllMaps scratchColumnTypeMap " + scratchColumnTypeMap.toString());
    }

    private static class ValidatorVectorizationContext
    extends VectorizationContext {
        private ValidatorVectorizationContext() {
            super("No Name");
        }

        @Override
        protected int getInputColumnIndex(String name) {
            return 0;
        }

        @Override
        protected int getInputColumnIndex(ExprNodeColumnDesc colExpr) {
            return 0;
        }
    }

    class ReduceWorkVectorizationNodeProcessor
    extends VectorizationNodeProcessor {
        private final List<String> reduceColumnNames;
        private final List<TypeInfo> reduceTypeInfos;
        private boolean isTez;
        private Operator<? extends OperatorDesc> rootVectorOp;

        public Operator<? extends OperatorDesc> getRootVectorOp() {
            return this.rootVectorOp;
        }

        public ReduceWorkVectorizationNodeProcessor(List<String> reduceColumnNames, List<TypeInfo> reduceTypeInfos, boolean isTez) {
            this.reduceColumnNames = reduceColumnNames;
            this.reduceTypeInfos = reduceTypeInfos;
            this.rootVectorOp = null;
            this.isTez = isTez;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            VectorizationContext vContext = null;
            boolean saveRootVectorOp = false;
            if (op.getParentOperators().size() == 0) {
                LOG.info("ReduceWorkVectorizationNodeProcessor process reduceColumnNames " + this.reduceColumnNames.toString());
                this.taskVectorizationContext = vContext = new VectorizationContext("__Reduce_Shuffle__", this.reduceColumnNames);
                int i = 0;
                for (TypeInfo typeInfo : this.reduceTypeInfos) {
                    this.taskColumnTypeNameMap.put(i, typeInfo.getTypeName());
                    ++i;
                }
                saveRootVectorOp = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Vectorized ReduceWork reduce shuffle vectorization context " + vContext.toString());
                }
            } else {
                LOG.info("ReduceWorkVectorizationNodeProcessor process going to walk the operator stack to get vectorization context for " + op.getName());
                vContext = this.walkStackToFindVectorizationContext(stack, op);
                if (vContext == null) {
                    vContext = this.taskVectorizationContext;
                }
            }
            assert (vContext != null);
            LOG.info("ReduceWorkVectorizationNodeProcessor process operator " + op.getName() + " using vectorization context" + vContext.toString());
            if (Vectorizer.this.nonVectorizableChildOfGroupBy(op).booleanValue()) {
                if (!this.opsDone.contains(op)) {
                    this.opsDone.add(op);
                }
                return null;
            }
            Operator<? extends OperatorDesc> vectorOp = this.doVectorize(op, vContext, this.isTez);
            if (LOG.isDebugEnabled() && vectorOp instanceof VectorizationContextRegion) {
                VectorizationContextRegion vcRegion = (VectorizationContextRegion)((Object)vectorOp);
                VectorizationContext vNewContext = vcRegion.getOuputVectorizationContext();
                LOG.debug("Vectorized ReduceWork operator " + vectorOp.getName() + " added vectorization context " + vNewContext.toString());
            }
            if (vectorOp instanceof VectorGroupByOperator) {
                VectorGroupByOperator groupBy = (VectorGroupByOperator)vectorOp;
                VectorGroupByDesc vectorDesc = ((GroupByDesc)groupBy.getConf()).getVectorDesc();
                vectorDesc.setVectorGroupBatches(true);
            }
            if (saveRootVectorOp && op != vectorOp) {
                this.rootVectorOp = vectorOp;
            }
            return null;
        }
    }

    class MapWorkVectorizationNodeProcessor
    extends VectorizationNodeProcessor {
        private final MapWork mWork;
        private final boolean isTez;

        public MapWorkVectorizationNodeProcessor(MapWork mWork, boolean isTez) {
            this.mWork = mWork;
            this.isTez = isTez;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            VectorizationContext vContext = null;
            if (op instanceof TableScanOperator) {
                if (this.taskVectorizationContext == null) {
                    this.taskVectorizationContext = Vectorizer.this.getVectorizationContext(op.getSchema(), op.getName(), this.taskColumnTypeNameMap);
                }
                vContext = this.taskVectorizationContext;
            } else {
                LOG.info("MapWorkVectorizationNodeProcessor process going to walk the operator stack to get vectorization context for " + op.getName());
                vContext = this.walkStackToFindVectorizationContext(stack, op);
                if (vContext == null) {
                    vContext = this.taskVectorizationContext;
                }
            }
            assert (vContext != null);
            LOG.info("MapWorkVectorizationNodeProcessor process operator " + op.getName() + " using vectorization context" + vContext.toString());
            if (Vectorizer.this.nonVectorizableChildOfGroupBy(op).booleanValue()) {
                if (!this.opsDone.contains(op)) {
                    this.opsDone.add(op);
                }
                return null;
            }
            Operator<? extends OperatorDesc> vectorOp = this.doVectorize(op, vContext, this.isTez);
            if (LOG.isDebugEnabled() && vectorOp instanceof VectorizationContextRegion) {
                VectorizationContextRegion vcRegion = (VectorizationContextRegion)((Object)vectorOp);
                VectorizationContext vNewContext = vcRegion.getOuputVectorizationContext();
                LOG.debug("Vectorized MapWork operator " + vectorOp.getName() + " added vectorization context " + vNewContext.toString());
            }
            return null;
        }
    }

    class VectorizationNodeProcessor
    implements NodeProcessor {
        protected VectorizationContext taskVectorizationContext;
        protected Map<Integer, String> taskColumnTypeNameMap;
        protected final Set<Operator<? extends OperatorDesc>> opsDone = new HashSet<Operator<? extends OperatorDesc>>();
        protected final Map<Operator<? extends OperatorDesc>, Operator<? extends OperatorDesc>> opToVectorOpMap = new HashMap<Operator<? extends OperatorDesc>, Operator<? extends OperatorDesc>>();

        VectorizationNodeProcessor() {
            this.taskColumnTypeNameMap = new HashMap<Integer, String>();
        }

        public Map<String, Integer> getVectorColumnNameMap() {
            return this.taskVectorizationContext.getProjectionColumnMap();
        }

        public Map<Integer, String> getVectorColumnTypeMap() {
            return this.taskColumnTypeNameMap;
        }

        public Map<Integer, String> getVectorScratchColumnTypeMap() {
            return this.taskVectorizationContext.getScratchColumnTypeMap();
        }

        public VectorizationContext walkStackToFindVectorizationContext(Stack<Node> stack, Operator<? extends OperatorDesc> op) throws SemanticException {
            VectorizationContext vContext = null;
            if (stack.size() <= 1) {
                throw new SemanticException(String.format("Expected operator stack for operator %s to have at least 2 operators", op.getName()));
            }
            int i = stack.size() - 2;
            while (vContext == null) {
                if (i < 0) {
                    return null;
                }
                Operator opParent = (Operator)stack.get(i);
                Operator<? extends OperatorDesc> vectorOpParent = this.opToVectorOpMap.get(opParent);
                if (vectorOpParent != null) {
                    if (vectorOpParent instanceof VectorizationContextRegion) {
                        VectorizationContextRegion vcRegion = (VectorizationContextRegion)((Object)vectorOpParent);
                        vContext = vcRegion.getOuputVectorizationContext();
                        LOG.info("walkStackToFindVectorizationContext " + vectorOpParent.getName() + " has new vectorization context " + vContext.toString());
                    } else {
                        LOG.info("walkStackToFindVectorizationContext " + vectorOpParent.getName() + " does not have new vectorization context");
                    }
                } else {
                    LOG.info("walkStackToFindVectorizationContext " + opParent.getName() + " is not vectorized");
                }
                --i;
            }
            return vContext;
        }

        public Operator<? extends OperatorDesc> doVectorize(Operator<? extends OperatorDesc> op, VectorizationContext vContext, boolean isTez) throws SemanticException {
            Operator<? extends OperatorDesc> vectorOp = op;
            try {
                if (!this.opsDone.contains(op)) {
                    vectorOp = Vectorizer.this.vectorizeOperator(op, vContext, isTez);
                    this.opsDone.add(op);
                    if (vectorOp != op) {
                        this.opToVectorOpMap.put(op, vectorOp);
                        this.opsDone.add(vectorOp);
                    }
                }
            }
            catch (HiveException e) {
                throw new SemanticException(e);
            }
            return vectorOp;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            throw new SemanticException("Must be overridden");
        }
    }

    class ReduceWorkValidationNodeProcessor
    implements NodeProcessor {
        ReduceWorkValidationNodeProcessor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            for (Node n : stack) {
                Operator op = (Operator)n;
                if (Vectorizer.this.nonVectorizableChildOfGroupBy(op).booleanValue()) {
                    return new Boolean(true);
                }
                boolean ret = Vectorizer.this.validateReduceWorkOperator(op);
                if (ret) continue;
                LOG.info("ReduceWork Operator: " + op.getName() + " could not be vectorized.");
                return new Boolean(false);
            }
            return new Boolean(true);
        }
    }

    class MapWorkValidationNodeProcessor
    implements NodeProcessor {
        private final MapWork mapWork;
        private final boolean isTez;

        public MapWorkValidationNodeProcessor(MapWork mapWork, boolean isTez) {
            this.mapWork = mapWork;
            this.isTez = isTez;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            for (Node n : stack) {
                Operator op = (Operator)n;
                if (Vectorizer.this.nonVectorizableChildOfGroupBy(op).booleanValue()) {
                    return new Boolean(true);
                }
                boolean ret = Vectorizer.this.validateMapWorkOperator(op, this.mapWork, this.isTez);
                if (ret) continue;
                LOG.info("MapWork Operator: " + op.getName() + " could not be vectorized.");
                return new Boolean(false);
            }
            return new Boolean(true);
        }
    }

    class VectorizationDispatcher
    implements Dispatcher {
        private final PhysicalContext physicalContext;
        private List<String> reduceColumnNames;
        private List<TypeInfo> reduceTypeInfos;

        public VectorizationDispatcher(PhysicalContext physicalContext) {
            this.physicalContext = physicalContext;
            this.reduceColumnNames = null;
            this.reduceTypeInfos = null;
        }

        @Override
        public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
            block5: {
                Task currTask;
                block6: {
                    block4: {
                        currTask = (Task)nd;
                        if (!(currTask instanceof MapRedTask)) break block4;
                        this.convertMapWork(((MapredWork)((MapRedTask)currTask).getWork()).getMapWork(), false);
                        break block5;
                    }
                    if (!(currTask instanceof TezTask)) break block6;
                    TezWork work = (TezWork)((TezTask)currTask).getWork();
                    for (BaseWork w : work.getAllWork()) {
                        if (w instanceof MapWork) {
                            this.convertMapWork((MapWork)w, true);
                            continue;
                        }
                        if (!(w instanceof ReduceWork) || !HiveConf.getBoolVar(Vectorizer.this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCE_ENABLED)) continue;
                        this.convertReduceWork((ReduceWork)w, true);
                    }
                    break block5;
                }
                if (!(currTask instanceof SparkTask)) break block5;
                SparkWork sparkWork = (SparkWork)currTask.getWork();
                for (BaseWork baseWork : sparkWork.getAllWork()) {
                    if (baseWork instanceof MapWork) {
                        this.convertMapWork((MapWork)baseWork, false);
                        continue;
                    }
                    if (!(baseWork instanceof ReduceWork) || !HiveConf.getBoolVar(Vectorizer.this.hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCE_ENABLED)) continue;
                    this.convertReduceWork((ReduceWork)baseWork, false);
                }
            }
            return null;
        }

        private void convertMapWork(MapWork mapWork, boolean isTez) throws SemanticException {
            boolean ret = this.validateMapWork(mapWork, isTez);
            if (ret) {
                this.vectorizeMapWork(mapWork, isTez);
            }
        }

        private void addMapWorkRules(Map<Rule, NodeProcessor> opRules, NodeProcessor np) {
            opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + ".*" + FileSinkOperator.getOperatorName()), np);
            opRules.put(new RuleRegExp("R2", TableScanOperator.getOperatorName() + ".*" + ReduceSinkOperator.getOperatorName()), np);
        }

        private boolean validateMapWork(MapWork mapWork, boolean isTez) throws SemanticException {
            LOG.info("Validating MapWork...");
            LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = mapWork.getAliasToWork();
            if (aliasToWork == null || aliasToWork.size() == 0) {
                return false;
            }
            int tableScanCount = 0;
            for (Operator<? extends OperatorDesc> op : aliasToWork.values()) {
                if (op == null) {
                    LOG.warn("Map work has invalid aliases to work with. Fail validation!");
                    return false;
                }
                if (!(op instanceof TableScanOperator)) continue;
                ++tableScanCount;
            }
            if (tableScanCount > 1) {
                LOG.warn("Map work has more than 1 TableScanOperator aliases to work with. Fail validation!");
                return false;
            }
            for (String path : mapWork.getPathToPartitionInfo().keySet()) {
                PartitionDesc pd = mapWork.getPathToPartitionInfo().get(path);
                List<Class<?>> interfaceList = Arrays.asList(pd.getInputFileFormatClass().getInterfaces());
                if (interfaceList.contains(VectorizedInputFormatInterface.class)) continue;
                LOG.info("Input format: " + pd.getInputFileFormatClassName() + ", doesn't provide vectorized input");
                return false;
            }
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            MapWorkValidationNodeProcessor vnp = new MapWorkValidationNodeProcessor(mapWork, isTez);
            this.addMapWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(mapWork.getAliasToWork().values());
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            for (Node n : nodeOutput.keySet()) {
                if (nodeOutput.get(n) == null || ((Boolean)nodeOutput.get(n)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        private void vectorizeMapWork(MapWork mapWork, boolean isTez) throws SemanticException {
            LOG.info("Vectorizing MapWork...");
            mapWork.setVectorMode(true);
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            MapWorkVectorizationNodeProcessor vnp = new MapWorkVectorizationNodeProcessor(mapWork, isTez);
            this.addMapWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            PreOrderWalker ogw = new PreOrderWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(mapWork.getAliasToWork().values());
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            mapWork.setVectorColumnNameMap(vnp.getVectorColumnNameMap());
            mapWork.setVectorColumnTypeMap(vnp.getVectorColumnTypeMap());
            mapWork.setVectorScratchColumnTypeMap(vnp.getVectorScratchColumnTypeMap());
            if (LOG.isDebugEnabled()) {
                Vectorizer.this.debugDisplayAllMaps(mapWork);
            }
        }

        private void convertReduceWork(ReduceWork reduceWork, boolean isTez) throws SemanticException {
            boolean ret = this.validateReduceWork(reduceWork);
            if (ret) {
                this.vectorizeReduceWork(reduceWork, isTez);
            }
        }

        private boolean getOnlyStructObjectInspectors(ReduceWork reduceWork) throws SemanticException {
            try {
                ObjectInspector keyObjectInspector = reduceWork.getKeyObjectInspector();
                if (keyObjectInspector == null || !(keyObjectInspector instanceof StructObjectInspector)) {
                    return false;
                }
                StructObjectInspector keyStructObjectInspector = (StructObjectInspector)keyObjectInspector;
                List<? extends StructField> keyFields = keyStructObjectInspector.getAllStructFieldRefs();
                if (reduceWork.getNeedsTagging()) {
                    return false;
                }
                ObjectInspector valueObjectInspector = reduceWork.getValueObjectInspector();
                if (valueObjectInspector == null || !(valueObjectInspector instanceof StructObjectInspector)) {
                    return false;
                }
                StructObjectInspector valueStructObjectInspector = (StructObjectInspector)valueObjectInspector;
                List<? extends StructField> valueFields = valueStructObjectInspector.getAllStructFieldRefs();
                this.reduceColumnNames = new ArrayList<String>();
                this.reduceTypeInfos = new ArrayList<TypeInfo>();
                for (StructField structField : keyFields) {
                    this.reduceColumnNames.add(Utilities.ReduceField.KEY.toString() + "." + structField.getFieldName());
                    this.reduceTypeInfos.add(TypeInfoUtils.getTypeInfoFromTypeString(structField.getFieldObjectInspector().getTypeName()));
                }
                for (StructField structField : valueFields) {
                    this.reduceColumnNames.add(Utilities.ReduceField.VALUE.toString() + "." + structField.getFieldName());
                    this.reduceTypeInfos.add(TypeInfoUtils.getTypeInfoFromTypeString(structField.getFieldObjectInspector().getTypeName()));
                }
            }
            catch (Exception e) {
                throw new SemanticException(e);
            }
            return true;
        }

        private void addReduceWorkRules(Map<Rule, NodeProcessor> opRules, NodeProcessor np) {
            opRules.put(new RuleRegExp("R1", GroupByOperator.getOperatorName() + ".*"), np);
            opRules.put(new RuleRegExp("R2", SelectOperator.getOperatorName() + ".*"), np);
        }

        private boolean validateReduceWork(ReduceWork reduceWork) throws SemanticException {
            LOG.info("Validating ReduceWork...");
            if (!this.getOnlyStructObjectInspectors(reduceWork)) {
                return false;
            }
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            ReduceWorkValidationNodeProcessor vnp = new ReduceWorkValidationNodeProcessor();
            this.addReduceWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.add(reduceWork.getReducer());
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            for (Node n : nodeOutput.keySet()) {
                if (nodeOutput.get(n) == null || ((Boolean)nodeOutput.get(n)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        private void vectorizeReduceWork(ReduceWork reduceWork, boolean isTez) throws SemanticException {
            LOG.info("Vectorizing ReduceWork...");
            reduceWork.setVectorMode(true);
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            ReduceWorkVectorizationNodeProcessor vnp = new ReduceWorkVectorizationNodeProcessor(this.reduceColumnNames, this.reduceTypeInfos, isTez);
            this.addReduceWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            PreOrderWalker ogw = new PreOrderWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.add(reduceWork.getReducer());
            LOG.info("vectorizeReduceWork reducer Operator: " + reduceWork.getReducer().getName() + "...");
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            reduceWork.setReducer(vnp.getRootVectorOp());
            reduceWork.setVectorColumnNameMap(vnp.getVectorColumnNameMap());
            reduceWork.setVectorColumnTypeMap(vnp.getVectorColumnTypeMap());
            reduceWork.setVectorScratchColumnTypeMap(vnp.getVectorScratchColumnTypeMap());
            if (LOG.isDebugEnabled()) {
                Vectorizer.this.debugDisplayAllMaps(reduceWork);
            }
        }
    }
}

