/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.spark;

import com.facebook.presto.hive.$internal.com.google.common.base.Preconditions;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SparkHashTableSinkOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.GenSparkProcContext;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.HashTableDummyDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SparkEdgeProperty;
import org.apache.hadoop.hive.ql.plan.SparkHashTableSinkDesc;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public class SparkReduceSinkMapJoinProc
implements NodeProcessor {
    public static final Log LOG = LogFactory.getLog(SparkReduceSinkMapJoinProc.class.getName());

    private boolean hasGroupBy(Operator<? extends OperatorDesc> mapjoinOp, GenSparkProcContext context) throws SemanticException {
        List<Operator<OperatorDesc>> childOps = mapjoinOp.getChildOperators();
        LinkedHashMap<Rule, NodeProcessor> rules = new LinkedHashMap<Rule, NodeProcessor>();
        SparkMapJoinFollowedByGroupByProcessor processor = new SparkMapJoinFollowedByGroupByProcessor();
        rules.put(new RuleRegExp("GBY", GroupByOperator.getOperatorName() + "%"), processor);
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, rules, context);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(childOps);
        ogw.startWalking(topNodes, null);
        return processor.getHasGroupBy();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procContext, Object ... nodeOutputs) throws SemanticException {
        GenSparkProcContext context = (GenSparkProcContext)procContext;
        if (!nd.getClass().equals(MapJoinOperator.class)) {
            return null;
        }
        MapJoinOperator mapJoinOp = (MapJoinOperator)nd;
        if (stack.size() < 2 || !(stack.get(stack.size() - 2) instanceof ReduceSinkOperator)) {
            context.currentMapJoinOperators.add(mapJoinOp);
            return null;
        }
        context.preceedingWork = null;
        context.currentRootOperator = null;
        ReduceSinkOperator parentRS = (ReduceSinkOperator)stack.get(stack.size() - 2);
        ((ReduceSinkDesc)parentRS.getConf()).setSkipTag(true);
        parentRS.setSkipTag(true);
        if (!context.mapJoinParentMap.containsKey(mapJoinOp)) {
            ArrayList<Operator<OperatorDesc>> parents = new ArrayList<Operator<OperatorDesc>>(mapJoinOp.getParentOperators());
            context.mapJoinParentMap.put(mapJoinOp, parents);
        }
        List<BaseWork> mapJoinWork = context.mapJoinWorkMap.get(mapJoinOp);
        int workMapSize = context.childToWorkMap.get(parentRS).size();
        Preconditions.checkArgument(workMapSize == 1, "AssertionError: expected context.childToWorkMap.get(parentRS).size() to be 1, but was " + workMapSize);
        BaseWork parentWork = context.childToWorkMap.get(parentRS).get(0);
        int pos = context.mapJoinParentMap.get(mapJoinOp).indexOf(parentRS);
        if (pos == -1) {
            throw new SemanticException("Cannot find position of parent in mapjoin");
        }
        LOG.debug("Mapjoin " + mapJoinOp + ", pos: " + pos + " --> " + parentWork.getName());
        ((MapJoinDesc)mapJoinOp.getConf()).getParentToInput().put(pos, parentWork.getName());
        SparkEdgeProperty edgeProp = new SparkEdgeProperty(0L);
        if (mapJoinWork != null) {
            for (BaseWork myWork : mapJoinWork) {
                SparkWork sparkWork = (SparkWork)context.currentTask.getWork();
                LOG.debug("connecting " + parentWork.getName() + " with " + myWork.getName());
                sparkWork.connect(parentWork, myWork, edgeProp);
            }
        }
        Map<BaseWork, SparkEdgeProperty> linkWorkMap = null;
        linkWorkMap = context.linkOpWithWorkMap.containsKey(mapJoinOp) ? context.linkOpWithWorkMap.get(mapJoinOp) : new HashMap<BaseWork, SparkEdgeProperty>();
        linkWorkMap.put(parentWork, edgeProp);
        context.linkOpWithWorkMap.put(mapJoinOp, linkWorkMap);
        List<ReduceSinkOperator> reduceSinks = context.linkWorkWithReduceSinkMap.get(parentWork);
        if (reduceSinks == null) {
            reduceSinks = new ArrayList<ReduceSinkOperator>();
        }
        reduceSinks.add(parentRS);
        context.linkWorkWithReduceSinkMap.put(parentWork, reduceSinks);
        ArrayList<Operator> dummyOperators = new ArrayList<Operator>();
        HashTableDummyDesc desc = new HashTableDummyDesc();
        HashTableDummyOperator dummyOp = (HashTableDummyOperator)OperatorFactory.get(desc, new Operator[0]);
        RowSchema rowSchema = parentRS.getParentOperators().get(0).getSchema();
        TableDesc tbl = PlanUtils.getReduceValueTableDesc(PlanUtils.getFieldSchemasFromRowSchema(rowSchema, ""));
        ((HashTableDummyDesc)dummyOp.getConf()).setTbl(tbl);
        Map<Byte, List<ExprNodeDesc>> keyExprMap = ((MapJoinDesc)mapJoinOp.getConf()).getKeys();
        List<ExprNodeDesc> keyCols = keyExprMap.get((byte)0);
        StringBuffer keyOrder = new StringBuffer();
        for (int i = 0; i < keyCols.size(); ++i) {
            keyOrder.append("+");
        }
        TableDesc keyTableDesc = PlanUtils.getReduceKeyTableDesc(PlanUtils.getFieldSchemasFromColumnList(keyCols, "mapjoinkey"), keyOrder.toString());
        ((MapJoinDesc)mapJoinOp.getConf()).setKeyTableDesc(keyTableDesc);
        mapJoinOp.replaceParent(parentRS, dummyOp);
        ArrayList<Operator<? extends OperatorDesc>> dummyChildren = new ArrayList<Operator<? extends OperatorDesc>>();
        dummyChildren.add(mapJoinOp);
        dummyOp.setChildOperators(dummyChildren);
        dummyOperators.add(dummyOp);
        List<Operator<OperatorDesc>> childOperators = parentRS.getChildOperators();
        int childIndex = childOperators.indexOf(mapJoinOp);
        childOperators.remove(childIndex);
        if (mapJoinWork != null) {
            for (BaseWork baseWork : mapJoinWork) {
                baseWork.addDummyOp(dummyOp);
            }
        }
        if (context.linkChildOpWithDummyOp.containsKey(mapJoinOp)) {
            for (Operator operator : context.linkChildOpWithDummyOp.get(mapJoinOp)) {
                dummyOperators.add(operator);
            }
        }
        context.linkChildOpWithDummyOp.put(mapJoinOp, dummyOperators);
        MapJoinDesc mjDesc = (MapJoinDesc)mapJoinOp.getConf();
        HiveConf hiveConf = context.conf;
        mjDesc.resetOrder();
        float hashtableMemoryUsage = this.hasGroupBy(mapJoinOp, context) ? hiveConf.getFloatVar(HiveConf.ConfVars.HIVEHASHTABLEFOLLOWBYGBYMAXMEMORYUSAGE) : hiveConf.getFloatVar(HiveConf.ConfVars.HIVEHASHTABLEMAXMEMORYUSAGE);
        mjDesc.setHashTableMemoryUsage(hashtableMemoryUsage);
        SparkHashTableSinkDesc hashTableSinkDesc = new SparkHashTableSinkDesc(mjDesc);
        SparkHashTableSinkOperator hashTableSinkOp = (SparkHashTableSinkOperator)OperatorFactory.get(hashTableSinkDesc, new Operator[0]);
        byte tag = (byte)pos;
        int[] valueIndex = mjDesc.getValueIndex(tag);
        if (valueIndex != null) {
            void var36_41;
            ArrayList<ExprNodeDesc> newValues = new ArrayList<ExprNodeDesc>();
            List<ExprNodeDesc> values = hashTableSinkDesc.getExprs().get(tag);
            boolean bl = false;
            while (var36_41 < values.size()) {
                if (valueIndex[var36_41] < 0) {
                    newValues.add(values.get((int)var36_41));
                }
                ++var36_41;
            }
            hashTableSinkDesc.getExprs().put(tag, newValues);
        }
        List<Operator<? extends OperatorDesc>> rsParentOps = parentRS.getParentOperators();
        for (Operator<OperatorDesc> operator : rsParentOps) {
            operator.replaceChild(parentRS, hashTableSinkOp);
        }
        hashTableSinkOp.setParentOperators(rsParentOps);
        hashTableSinkOp.setTag(tag);
        return true;
    }

    public static class SparkMapJoinFollowedByGroupByProcessor
    implements NodeProcessor {
        private boolean hasGroupBy = false;

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            GenSparkProcContext context = (GenSparkProcContext)procCtx;
            this.hasGroupBy = true;
            GroupByOperator op = (GroupByOperator)nd;
            float groupByMemoryUsage = context.conf.getFloatVar(HiveConf.ConfVars.HIVEMAPJOINFOLLOWEDBYMAPAGGRHASHMEMORY);
            ((GroupByDesc)op.getConf()).setGroupByMemoryUsage(groupByMemoryUsage);
            return null;
        }

        public boolean getHasGroupBy() {
            return this.hasGroupBy;
        }
    }
}

