/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageIndexer;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.base.Verify;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;

public class GroupByHashPageIndexer
implements PageIndexer {
    private final GroupByHash hash;

    public GroupByHashPageIndexer(List<? extends Type> hashTypes, JoinCompiler joinCompiler) {
        this(GroupByHash.createGroupByHash(hashTypes, IntStream.range(0, hashTypes.size()).toArray(), Optional.empty(), 20, false, joinCompiler, UpdateMemory.NOOP));
    }

    public GroupByHashPageIndexer(GroupByHash hash) {
        this.hash = Objects.requireNonNull(hash, "hash is null");
    }

    public int[] indexPage(Page page) {
        Work<GroupByIdBlock> work = this.hash.getGroupIds(page);
        boolean done = work.process();
        Verify.verify((boolean)done);
        GroupByIdBlock groupIds = work.getResult();
        int[] indexes = new int[page.getPositionCount()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = Math.toIntExact(groupIds.getGroupId(i));
        }
        return indexes;
    }

    public int getMaxIndex() {
        return this.hash.getGroupCount() - 1;
    }
}

