/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.Session;
import com.facebook.presto.connector.system.SystemConnectorSessionUtil;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataListing;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class CatalogSystemTable
implements SystemTable {
    public static final SchemaTableName CATALOG_TABLE_NAME = new SchemaTableName("metadata", "catalogs");
    public static final ConnectorTableMetadata CATALOG_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(CATALOG_TABLE_NAME).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("connector_id", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public CatalogSystemTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return CATALOG_TABLE;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        Session session = SystemConnectorSessionUtil.toSession(transactionHandle, connectorSession);
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)CATALOG_TABLE);
        for (Map.Entry<String, ConnectorId> entry : MetadataListing.listCatalogs(session, this.metadata, this.accessControl).entrySet()) {
            table.addRow(new Object[]{entry.getKey(), entry.getValue().toString()});
        }
        return table.build().cursor();
    }
}

