/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemSplit;
import com.facebook.presto.connector.system.SystemTableHandle;
import com.facebook.presto.connector.system.SystemTableLayoutHandle;
import com.facebook.presto.connector.system.SystemTablesProvider;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeState;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;

public class SystemSplitManager
implements ConnectorSplitManager {
    private final InternalNodeManager nodeManager;
    private final SystemTablesProvider tables;

    public SystemSplitManager(InternalNodeManager nodeManager, SystemTablesProvider tables) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.tables = Objects.requireNonNull(tables, "tables is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        SystemTableLayoutHandle layoutHandle = (SystemTableLayoutHandle)layout;
        SystemTableHandle tableHandle = layoutHandle.getTable();
        TupleDomain<ColumnHandle> constraint = layoutHandle.getConstraint();
        SystemTable systemTable = this.tables.getSystemTable(session, tableHandle.getSchemaTableName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Table %s not found", tableHandle.getSchemaTableName())));
        SystemTable.Distribution tableDistributionMode = systemTable.getDistribution();
        if (tableDistributionMode == SystemTable.Distribution.SINGLE_COORDINATOR) {
            HostAddress address = this.nodeManager.getCurrentNode().getHostAndPort();
            SystemSplit split = new SystemSplit(tableHandle.getConnectorId(), tableHandle, address, constraint);
            return new FixedSplitSource((Iterable)ImmutableList.of((Object)split));
        }
        ImmutableList.Builder splits = ImmutableList.builder();
        ImmutableSet.Builder nodes = ImmutableSet.builder();
        if (tableDistributionMode == SystemTable.Distribution.ALL_COORDINATORS) {
            nodes.addAll(this.nodeManager.getCoordinators());
        } else if (tableDistributionMode == SystemTable.Distribution.ALL_NODES) {
            nodes.addAll(this.nodeManager.getNodes(NodeState.ACTIVE));
        }
        ImmutableSet nodeSet = nodes.build();
        for (InternalNode node : nodeSet) {
            splits.add((Object)new SystemSplit(tableHandle.getConnectorId(), tableHandle, node.getHostAndPort(), constraint));
        }
        return new FixedSplitSource((Iterable)splits.build());
    }
}

