/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.dispatcher;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.dispatcher.DispatchInfo;
import com.facebook.presto.dispatcher.DispatchQuery;
import com.facebook.presto.dispatcher.LocalCoordinatorLocation;
import com.facebook.presto.execution.ClusterSizeMonitor;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.util.Failures;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.joda.time.DateTime;

public class LocalDispatchQuery
implements DispatchQuery {
    private static final Logger log = Logger.get(LocalDispatchQuery.class);
    private final QueryStateMachine stateMachine;
    private final ListenableFuture<QueryExecution> queryExecutionFuture;
    private final ClusterSizeMonitor clusterSizeMonitor;
    private final Executor queryExecutor;
    private final Consumer<QueryExecution> querySubmitter;
    private final SettableFuture<?> submitted = SettableFuture.create();

    public LocalDispatchQuery(QueryStateMachine stateMachine, ListenableFuture<QueryExecution> queryExecutionFuture, ClusterSizeMonitor clusterSizeMonitor, Executor queryExecutor, Consumer<QueryExecution> querySubmitter) {
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
        this.queryExecutionFuture = Objects.requireNonNull(queryExecutionFuture, "queryExecutionFuture is null");
        this.clusterSizeMonitor = Objects.requireNonNull(clusterSizeMonitor, "clusterSizeMonitor is null");
        this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
        this.querySubmitter = Objects.requireNonNull(querySubmitter, "querySubmitter is null");
        MoreFutures.addExceptionCallback(queryExecutionFuture, stateMachine::transitionToFailed);
        stateMachine.addStateChangeListener(state -> {
            if (state.isDone()) {
                this.submitted.set(null);
            }
        });
    }

    @Override
    public void startWaitingForResources() {
        if (this.stateMachine.transitionToWaitingForResources()) {
            this.waitForMinimumWorkers();
        }
    }

    private void waitForMinimumWorkers() {
        ListenableFuture<?> minimumWorkerFuture = this.clusterSizeMonitor.waitForMinimumWorkers();
        MoreFutures.addSuccessCallback(minimumWorkerFuture, () -> MoreFutures.addSuccessCallback(this.queryExecutionFuture, this::startExecution));
        MoreFutures.addExceptionCallback(minimumWorkerFuture, throwable -> this.queryExecutor.execute(() -> this.stateMachine.transitionToFailed((Throwable)throwable)));
    }

    private void startExecution(QueryExecution queryExecution) {
        this.queryExecutor.execute(() -> {
            if (this.stateMachine.transitionToDispatching()) {
                try {
                    this.querySubmitter.accept(queryExecution);
                }
                catch (Throwable t) {
                    this.stateMachine.transitionToFailed(t);
                    log.error(t, "query submitter threw exception");
                    throw t;
                }
                finally {
                    this.submitted.set(null);
                }
            }
        });
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.stateMachine.getLastHeartbeat();
    }

    @Override
    public ListenableFuture<?> getDispatchedFuture() {
        return Futures.nonCancellationPropagating(this.submitted);
    }

    @Override
    public DispatchInfo getDispatchInfo() {
        boolean dispatched = this.submitted.isDone();
        BasicQueryInfo queryInfo = this.stateMachine.getBasicQueryInfo(Optional.empty());
        if (queryInfo.getState() == QueryState.FAILED) {
            ExecutionFailureInfo failureInfo = this.stateMachine.getFailureInfo().orElseGet(() -> Failures.toFailure(new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Query failed for an unknown reason")));
            return DispatchInfo.failed(failureInfo, queryInfo.getQueryStats().getElapsedTime(), queryInfo.getQueryStats().getQueuedTime());
        }
        if (dispatched) {
            return DispatchInfo.dispatched(new LocalCoordinatorLocation(), queryInfo.getQueryStats().getElapsedTime(), queryInfo.getQueryStats().getQueuedTime());
        }
        return DispatchInfo.queued(queryInfo.getQueryStats().getElapsedTime(), queryInfo.getQueryStats().getQueuedTime());
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public boolean isDone() {
        return this.stateMachine.getQueryState().isDone();
    }

    @Override
    public DateTime getCreateTime() {
        return this.stateMachine.getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return this.stateMachine.getExecutionStartTime();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return this.stateMachine.getEndTime();
    }

    @Override
    public int getRunningTaskCount() {
        return this.stateMachine.getCurrentRunningTaskCount();
    }

    @Override
    public Duration getTotalCpuTime() {
        return this.tryGetQueryExecution().map(QueryExecution::getTotalCpuTime).orElse(new Duration(0.0, TimeUnit.MILLISECONDS));
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        return this.tryGetQueryExecution().map(QueryExecution::getTotalMemoryReservation).orElse(new DataSize(0.0, DataSize.Unit.BYTE));
    }

    @Override
    public DataSize getUserMemoryReservation() {
        return this.tryGetQueryExecution().map(QueryExecution::getUserMemoryReservation).orElse(new DataSize(0.0, DataSize.Unit.BYTE));
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return this.tryGetQueryExecution().map(QueryExecution::getBasicQueryInfo).orElse(this.stateMachine.getBasicQueryInfo(Optional.empty()));
    }

    @Override
    public Session getSession() {
        return this.stateMachine.getSession();
    }

    @Override
    public void fail(Throwable throwable) {
        this.stateMachine.transitionToFailed(throwable);
    }

    @Override
    public void cancel() {
        this.stateMachine.transitionToCanceled();
    }

    @Override
    public void pruneInfo() {
        this.stateMachine.pruneQueryInfo();
    }

    @Override
    public Optional<ErrorCode> getErrorCode() {
        return this.stateMachine.getFailureInfo().map(ExecutionFailureInfo::getErrorCode);
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    private Optional<QueryExecution> tryGetQueryExecution() {
        try {
            return MoreFutures.tryGetFutureValue(this.queryExecutionFuture);
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }
}

