/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.function.QualifiedFunctionName;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.function.SqlParameter;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.CreateFunction;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class CreateFunctionTask
implements DataDefinitionTask<CreateFunction> {
    private final SqlParser sqlParser;

    @Inject
    public CreateFunctionTask(SqlParser sqlParser) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public String getName() {
        return "CREATE FUNCTION";
    }

    @Override
    public String explain(CreateFunction statement, List<Expression> parameters) {
        return "CREATE FUNCTION " + statement.getFunctionName();
    }

    @Override
    public ListenableFuture<?> execute(CreateFunction statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Analyzer analyzer = new Analyzer(stateMachine.getSession(), metadata, this.sqlParser, accessControl, Optional.empty(), parameters, stateMachine.getWarningCollector());
        analyzer.analyze((Statement)statement);
        metadata.getFunctionManager().createFunction(this.createSqlInvokedFunction(statement), statement.isReplace());
        return Futures.immediateFuture(null);
    }

    private SqlInvokedFunction createSqlInvokedFunction(CreateFunction statement) {
        QualifiedFunctionName functionName = QualifiedFunctionName.of((String)statement.getFunctionName().toString());
        List parameters = (List)statement.getParameters().stream().map(parameter -> new SqlParameter(parameter.getName().toString().toLowerCase(Locale.ENGLISH), TypeSignature.parseTypeSignature((String)parameter.getType()))).collect(ImmutableList.toImmutableList());
        TypeSignature returnType = TypeSignature.parseTypeSignature((String)statement.getReturnType());
        String description = statement.getComment().orElse("");
        RoutineCharacteristics routineCharacteristics = RoutineCharacteristics.builder().setLanguage(RoutineCharacteristics.Language.valueOf((String)statement.getCharacteristics().getLanguage().name())).setDeterminism(RoutineCharacteristics.Determinism.valueOf((String)statement.getCharacteristics().getDeterminism().name())).setNullCallClause(RoutineCharacteristics.NullCallClause.valueOf((String)statement.getCharacteristics().getNullCallClause().name())).build();
        String body = SqlFormatter.formatSql((Node)statement.getBody(), Optional.empty());
        return new SqlInvokedFunction(functionName, parameters, returnType, description, routineCharacteristics, body, Optional.empty());
    }
}

