/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.execution.buffer.PagesSerdeUtil;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.page.PageCodecMarker;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spiller.SpillCipher;
import com.google.common.base.Preconditions;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import sun.misc.Unsafe;

@NotThreadSafe
public class PagesSerde {
    private static final double MINIMUM_COMPRESSION_RATIO = 0.8;
    private final BlockEncodingSerde blockEncodingSerde;
    private final Optional<Compressor> compressor;
    private final Optional<Decompressor> decompressor;
    private final Optional<SpillCipher> spillCipher;
    private byte[] compressionBuffer;

    public PagesSerde(BlockEncodingSerde blockEncodingSerde, Optional<Compressor> compressor, Optional<Decompressor> decompressor, Optional<SpillCipher> spillCipher) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        Preconditions.checkArgument((compressor.isPresent() == decompressor.isPresent() ? 1 : 0) != 0, (Object)"compressor and decompressor must both be present or both be absent");
        this.compressor = Objects.requireNonNull(compressor, "compressor is null");
        this.decompressor = Objects.requireNonNull(decompressor, "decompressor is null");
        this.spillCipher = Objects.requireNonNull(spillCipher, "spillCipher is null");
        Preconditions.checkState((!spillCipher.isPresent() || !spillCipher.get().isDestroyed() ? 1 : 0) != 0, (Object)"spillCipher is already destroyed");
    }

    public SerializedPage serialize(Page page) {
        DynamicSliceOutput serializationBuffer = new DynamicSliceOutput(Math.toIntExact(page.getSizeInBytes() + 4L));
        PagesSerdeUtil.writeRawPage(page, (SliceOutput)serializationBuffer, this.blockEncodingSerde);
        return this.wrapSlice(serializationBuffer.slice(), page.getPositionCount());
    }

    public SerializedPage serialize(Slice slice, int positionCount) {
        Preconditions.checkArgument((boolean)slice.isCompact(), (Object)"slice is not compact");
        return this.wrapSlice(slice, positionCount);
    }

    public Page deserialize(SerializedPage serializedPage) {
        Preconditions.checkArgument((serializedPage != null ? 1 : 0) != 0, (Object)"serializedPage is null");
        Slice slice = serializedPage.getSlice();
        if (PageCodecMarker.ENCRYPTED.isSet(serializedPage.getPageCodecMarkers())) {
            Preconditions.checkState((boolean)this.spillCipher.isPresent(), (Object)"Page is encrypted, but spill cipher is missing");
            slice = Slices.wrappedBuffer((ByteBuffer)this.spillCipher.get().decrypt(slice.toByteBuffer()));
        }
        if (PageCodecMarker.COMPRESSED.isSet(serializedPage.getPageCodecMarkers())) {
            Preconditions.checkState((boolean)this.decompressor.isPresent(), (Object)"Page is compressed, but decompressor is missing");
            int uncompressedSize = serializedPage.getUncompressedSizeInBytes();
            ByteBuffer decompressionBuffer = ByteBuffer.allocate(uncompressedSize);
            this.decompressor.get().decompress(slice.toByteBuffer(), decompressionBuffer);
            decompressionBuffer.flip();
            Preconditions.checkState((decompressionBuffer.remaining() == uncompressedSize ? 1 : 0) != 0);
            slice = Slices.wrappedBuffer((ByteBuffer)decompressionBuffer);
        }
        return PagesSerdeUtil.readRawPage(serializedPage.getPositionCount(), (SliceInput)slice.getInput(), this.blockEncodingSerde);
    }

    public long getSizeInBytes() {
        return this.compressionBuffer == null ? 0L : (long)this.compressionBuffer.length;
    }

    public long getRetainedSizeInBytes() {
        return SizeOf.sizeOf((byte[])this.compressionBuffer);
    }

    private SerializedPage wrapSlice(Slice slice, int positionCount) {
        int uncompressedSize = slice.length();
        byte markers = PageCodecMarker.none();
        if (this.compressor.isPresent()) {
            int maxCompressedSize = this.compressor.get().maxCompressedLength(uncompressedSize);
            this.compressionBuffer = Arrays.ensureCapacity((byte[])this.compressionBuffer, (int)maxCompressedSize);
            int compressedSize = this.compressor.get().compress((byte[])slice.getBase(), (int)(slice.getAddress() - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET), uncompressedSize, this.compressionBuffer, 0, maxCompressedSize);
            if ((double)compressedSize / (double)uncompressedSize <= 0.8) {
                slice = Slices.copyOf((Slice)Slices.wrappedBuffer((byte[])this.compressionBuffer, (int)0, (int)compressedSize));
                markers = PageCodecMarker.COMPRESSED.set(markers);
            }
        }
        if (this.spillCipher.isPresent()) {
            slice = Slices.wrappedBuffer((ByteBuffer)this.spillCipher.get().encrypt(slice.toByteBuffer()));
            markers = PageCodecMarker.ENCRYPTED.set(markers);
        } else if (!slice.isCompact()) {
            slice = Slices.copyOf((Slice)slice);
        }
        return new SerializedPage(slice, markers, positionCount, uncompressedSize);
    }
}

