/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;

public class ResettableRandomizedIterator<T>
implements Iterator<T> {
    private final List<T> list;
    private int position;

    public ResettableRandomizedIterator(Collection<T> elements) {
        this.list = new ArrayList<T>(elements);
    }

    public void reset() {
        this.position = 0;
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public boolean hasNext() {
        return this.position < this.list.size();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int position = ThreadLocalRandom.current().nextInt(this.position, this.list.size());
        T result = this.list.set(position, this.list.get(this.position));
        this.list.set(this.position, result);
        ++this.position;
        return result;
    }
}

