/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.ForQueryExecution;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.StageExecutionId;
import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.scheduler.DynamicSplitPlacementPolicy;
import com.facebook.presto.execution.scheduler.ExchangeLocationsConsumer;
import com.facebook.presto.execution.scheduler.FixedCountScheduler;
import com.facebook.presto.execution.scheduler.FixedSourcePartitionedScheduler;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.ScaledWriterScheduler;
import com.facebook.presto.execution.scheduler.SectionExecution;
import com.facebook.presto.execution.scheduler.SourcePartitionedScheduler;
import com.facebook.presto.execution.scheduler.SplitSchedulerStats;
import com.facebook.presto.execution.scheduler.StageExecutionAndScheduler;
import com.facebook.presto.execution.scheduler.StageLinkage;
import com.facebook.presto.execution.scheduler.StageScheduler;
import com.facebook.presto.execution.scheduler.StreamingPlanSection;
import com.facebook.presto.execution.scheduler.StreamingSubPlan;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelector;
import com.facebook.presto.failureDetector.FailureDetector;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.ForScheduler;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.planner.NodePartitionMap;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.SplitSourceFactory;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class SectionExecutionFactory {
    private final Metadata metadata;
    private final NodePartitioningManager nodePartitioningManager;
    private final NodeTaskMap nodeTaskMap;
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduledExecutor;
    private final FailureDetector failureDetector;
    private final SplitSchedulerStats schedulerStats;
    private final NodeScheduler nodeScheduler;
    private final int splitBatchSize;

    @Inject
    public SectionExecutionFactory(Metadata metadata, NodePartitioningManager nodePartitioningManager, NodeTaskMap nodeTaskMap, @ForQueryExecution ExecutorService executor, @ForScheduler ScheduledExecutorService scheduledExecutor, FailureDetector failureDetector, SplitSchedulerStats schedulerStats, NodeScheduler nodeScheduler, QueryManagerConfig queryManagerConfig) {
        this(metadata, nodePartitioningManager, nodeTaskMap, executor, scheduledExecutor, failureDetector, schedulerStats, nodeScheduler, Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null").getScheduleSplitBatchSize());
    }

    public SectionExecutionFactory(Metadata metadata, NodePartitioningManager nodePartitioningManager, NodeTaskMap nodeTaskMap, ExecutorService executor, ScheduledExecutorService scheduledExecutor, FailureDetector failureDetector, SplitSchedulerStats schedulerStats, NodeScheduler nodeScheduler, int splitBatchSize) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.scheduledExecutor = Objects.requireNonNull(scheduledExecutor, "scheduledExecutor is null");
        this.failureDetector = Objects.requireNonNull(failureDetector, "failureDetector is null");
        this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
        this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
        this.splitBatchSize = splitBatchSize;
    }

    public SectionExecution createSectionExecutions(Session session, StreamingPlanSection section, ExchangeLocationsConsumer locationsConsumer, Optional<int[]> bucketToPartition, OutputBuffers outputBuffers, boolean summarizeTaskInfo, RemoteTaskFactory remoteTaskFactory, SplitSourceFactory splitSourceFactory, int attemptId) {
        HashMap partitioningCache = new HashMap();
        TableWriteInfo tableWriteInfo = TableWriteInfo.createTableWriteInfo(section.getPlan(), this.metadata, session);
        List<StageExecutionAndScheduler> sectionStages = this.createStreamingLinkedStageExecutions(session, locationsConsumer, section.getPlan().withBucketToPartition(bucketToPartition), partitioningHandle -> partitioningCache.computeIfAbsent(partitioningHandle, handle -> this.nodePartitioningManager.getNodePartitioningMap(session, (PartitioningHandle)handle)), tableWriteInfo, Optional.empty(), summarizeTaskInfo, remoteTaskFactory, splitSourceFactory, attemptId);
        StageExecutionAndScheduler rootStage = (StageExecutionAndScheduler)Iterables.getLast(sectionStages);
        rootStage.getStageExecution().setOutputBuffers(outputBuffers);
        return new SectionExecution(rootStage, sectionStages);
    }

    private List<StageExecutionAndScheduler> createStreamingLinkedStageExecutions(Session session, ExchangeLocationsConsumer parent, StreamingSubPlan plan, Function<PartitioningHandle, NodePartitionMap> partitioningCache, TableWriteInfo tableWriteInfo, Optional<SqlStageExecution> parentStageExecution, boolean summarizeTaskInfo, RemoteTaskFactory remoteTaskFactory, SplitSourceFactory splitSourceFactory, int attemptId) {
        ImmutableList.Builder stageExecutionAndSchedulers = ImmutableList.builder();
        PlanFragmentId fragmentId = plan.getFragment().getId();
        StageId stageId = new StageId(session.getQueryId(), fragmentId.getId());
        SqlStageExecution stageExecution = SqlStageExecution.createSqlStageExecution(new StageExecutionId(stageId, attemptId), plan.getFragment(), remoteTaskFactory, session, summarizeTaskInfo, this.nodeTaskMap, this.executor, this.failureDetector, this.schedulerStats, tableWriteInfo);
        PartitioningHandle partitioningHandle = plan.getFragment().getPartitioning();
        List<RemoteSourceNode> remoteSourceNodes = plan.getFragment().getRemoteSourceNodes();
        Optional<int[]> bucketToPartition = SectionExecutionFactory.getBucketToPartition(partitioningHandle, partitioningCache, plan.getFragment().getRoot(), remoteSourceNodes);
        ImmutableSet.Builder childStagesBuilder = ImmutableSet.builder();
        for (StreamingSubPlan stagePlan : plan.getChildren()) {
            List<StageExecutionAndScheduler> subTree = this.createStreamingLinkedStageExecutions(session, stageExecution::addExchangeLocations, stagePlan.withBucketToPartition(bucketToPartition), partitioningCache, tableWriteInfo, Optional.of(stageExecution), summarizeTaskInfo, remoteTaskFactory, splitSourceFactory, attemptId);
            stageExecutionAndSchedulers.addAll(subTree);
            childStagesBuilder.add((Object)((StageExecutionAndScheduler)Iterables.getLast(subTree)).getStageExecution());
        }
        ImmutableSet childStageExecutions = childStagesBuilder.build();
        stageExecution.addStateChangeListener(arg_0 -> SectionExecutionFactory.lambda$createStreamingLinkedStageExecutions$2((Set)childStageExecutions, arg_0));
        StageLinkage stageLinkage = new StageLinkage(fragmentId, parent, (Set<SqlStageExecution>)childStageExecutions);
        StageScheduler stageScheduler = this.createStageScheduler(splitSourceFactory, session, plan, partitioningCache, parentStageExecution, stageId, stageExecution, partitioningHandle, tableWriteInfo, (Set<SqlStageExecution>)childStageExecutions);
        stageExecutionAndSchedulers.add((Object)new StageExecutionAndScheduler(stageExecution, stageLinkage, stageScheduler));
        return stageExecutionAndSchedulers.build();
    }

    private StageScheduler createStageScheduler(SplitSourceFactory splitSourceFactory, Session session, StreamingSubPlan plan, Function<PartitioningHandle, NodePartitionMap> partitioningCache, Optional<SqlStageExecution> parentStageExecution, StageId stageId, SqlStageExecution stageExecution, PartitioningHandle partitioningHandle, TableWriteInfo tableWriteInfo, Set<SqlStageExecution> childStageExecutions) {
        Map<PlanNodeId, SplitSource> splitSources = splitSourceFactory.createSplitSources(plan.getFragment(), session, tableWriteInfo);
        int maxTasksPerStage = SystemSessionProperties.getMaxTasksPerStage(session);
        if (partitioningHandle.equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION)) {
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(splitSources.entrySet());
            PlanNodeId planNodeId = (PlanNodeId)entry.getKey();
            SplitSource splitSource = (SplitSource)entry.getValue();
            ConnectorId connectorId = splitSource.getConnectorId();
            if (ConnectorId.isInternalSystemConnector((ConnectorId)connectorId)) {
                connectorId = null;
            }
            NodeSelector nodeSelector = this.nodeScheduler.createNodeSelector(connectorId, maxTasksPerStage);
            DynamicSplitPlacementPolicy placementPolicy = new DynamicSplitPlacementPolicy(nodeSelector, stageExecution::getAllTasks);
            Preconditions.checkArgument((!plan.getFragment().getStageExecutionDescriptor().isStageGroupedExecution() ? 1 : 0) != 0);
            return SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler(stageExecution, planNodeId, splitSource, placementPolicy, this.splitBatchSize);
        }
        if (partitioningHandle.equals(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION)) {
            Supplier<Collection<TaskStatus>> sourceTasksProvider = () -> childStageExecutions.stream().map(SqlStageExecution::getAllTasks).flatMap(Collection::stream).map(RemoteTask::getTaskStatus).collect(Collectors.toList());
            Supplier<Collection<TaskStatus>> writerTasksProvider = () -> stageExecution.getAllTasks().stream().map(RemoteTask::getTaskStatus).collect(Collectors.toList());
            ScaledWriterScheduler scheduler = new ScaledWriterScheduler(stageExecution, sourceTasksProvider, writerTasksProvider, this.nodeScheduler.createNodeSelector(null), this.scheduledExecutor, SystemSessionProperties.getWriterMinSize(session), SystemSessionProperties.isOptimizedScaleWriterProducerBuffer(session));
            SectionExecutionFactory.whenAllStages(childStageExecutions, StageExecutionState::isDone).addListener(scheduler::finish, MoreExecutors.directExecutor());
            return scheduler;
        }
        if (!splitSources.isEmpty()) {
            ArrayList<InternalNode> stageNodeList;
            BucketNodeMap bucketNodeMap;
            Object connectorPartitionHandles;
            List<PlanNodeId> schedulingOrder = plan.getFragment().getTableScanSchedulingOrder();
            ConnectorId connectorId = partitioningHandle.getConnectorId().orElseThrow(IllegalStateException::new);
            boolean groupedExecutionForStage = plan.getFragment().getStageExecutionDescriptor().isStageGroupedExecution();
            if (groupedExecutionForStage) {
                connectorPartitionHandles = this.nodePartitioningManager.listPartitionHandles(session, partitioningHandle);
                Preconditions.checkState((!ImmutableList.of((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED).equals(connectorPartitionHandles) ? 1 : 0) != 0);
            } else {
                connectorPartitionHandles = ImmutableList.of((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED);
            }
            if (plan.getFragment().getRemoteSourceNodes().stream().allMatch(node -> node.getExchangeType() == ExchangeNode.Type.REPLICATE)) {
                boolean dynamicLifespanSchedule = plan.getFragment().getStageExecutionDescriptor().isDynamicLifespanSchedule();
                bucketNodeMap = this.nodePartitioningManager.getBucketNodeMap(session, partitioningHandle, dynamicLifespanSchedule);
                Verify.verify((bucketNodeMap.isDynamic() == dynamicLifespanSchedule ? 1 : 0) != 0);
                stageNodeList = bucketNodeMap.hasInitialMap() ? (ArrayList<InternalNode>)bucketNodeMap.getBucketToNode().get().stream().distinct().collect(ImmutableList.toImmutableList()) : new ArrayList<InternalNode>(this.nodeScheduler.createNodeSelector(connectorId).selectRandomNodes(maxTasksPerStage));
            } else {
                Verify.verify((!plan.getFragment().getStageExecutionDescriptor().isDynamicLifespanSchedule() ? 1 : 0) != 0);
                NodePartitionMap nodePartitionMap = partitioningCache.apply(plan.getFragment().getPartitioning());
                if (groupedExecutionForStage) {
                    Preconditions.checkState((connectorPartitionHandles.size() == nodePartitionMap.getBucketToPartition().length ? 1 : 0) != 0);
                }
                stageNodeList = nodePartitionMap.getPartitionToNode();
                bucketNodeMap = nodePartitionMap.asBucketNodeMap();
            }
            FixedSourcePartitionedScheduler fixedSourcePartitionedScheduler = new FixedSourcePartitionedScheduler(stageExecution, splitSources, plan.getFragment().getStageExecutionDescriptor(), schedulingOrder, stageNodeList, bucketNodeMap, this.splitBatchSize, SystemSessionProperties.getConcurrentLifespansPerNode(session), this.nodeScheduler.createNodeSelector(connectorId), (List<ConnectorPartitionHandle>)connectorPartitionHandles);
            if (plan.getFragment().getStageExecutionDescriptor().isRecoverableGroupedExecution()) {
                stageExecution.registerStageTaskRecoveryCallback(taskId -> {
                    Preconditions.checkArgument((boolean)taskId.getStageExecutionId().getStageId().equals(stageId), (Object)"The task did not execute this stage");
                    Preconditions.checkArgument((boolean)parentStageExecution.isPresent(), (Object)"Parent stage execution must exist");
                    Preconditions.checkArgument((((SqlStageExecution)parentStageExecution.get()).getAllTasks().size() == 1 ? 1 : 0) != 0, (Object)"Parent stage should only have one task for recoverable grouped execution");
                    ((SqlStageExecution)parentStageExecution.get()).removeRemoteSourceIfSingleTaskStage(taskId);
                    fixedSourcePartitionedScheduler.recover(taskId);
                });
            }
            return fixedSourcePartitionedScheduler;
        }
        NodePartitionMap nodePartitionMap = partitioningCache.apply(plan.getFragment().getPartitioning());
        List<InternalNode> partitionToNode = nodePartitionMap.getPartitionToNode();
        Failures.checkCondition(!partitionToNode.isEmpty(), (ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No worker nodes available", new Object[0]);
        return new FixedCountScheduler(stageExecution, partitionToNode);
    }

    private static Optional<int[]> getBucketToPartition(PartitioningHandle partitioningHandle, Function<PartitioningHandle, NodePartitionMap> partitioningCache, PlanNode fragmentRoot, List<RemoteSourceNode> remoteSourceNodes) {
        if (partitioningHandle.equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION) || partitioningHandle.equals(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION)) {
            return Optional.of(new int[1]);
        }
        if (PlanNodeSearcher.searchFrom(fragmentRoot).where(node -> node instanceof TableScanNode).findFirst().isPresent()) {
            if (remoteSourceNodes.stream().allMatch(node -> node.getExchangeType() == ExchangeNode.Type.REPLICATE)) {
                return Optional.empty();
            }
            NodePartitionMap nodePartitionMap = partitioningCache.apply(partitioningHandle);
            return Optional.of(nodePartitionMap.getBucketToPartition());
        }
        NodePartitionMap nodePartitionMap = partitioningCache.apply(partitioningHandle);
        List<InternalNode> partitionToNode = nodePartitionMap.getPartitionToNode();
        Failures.checkCondition(!partitionToNode.isEmpty(), (ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No worker nodes available", new Object[0]);
        return Optional.of(nodePartitionMap.getBucketToPartition());
    }

    private static ListenableFuture<?> whenAllStages(Collection<SqlStageExecution> stageExecutions, Predicate<StageExecutionState> predicate) {
        Preconditions.checkArgument((!stageExecutions.isEmpty() ? 1 : 0) != 0, (Object)"stageExecutions is empty");
        Set stageIds = Sets.newConcurrentHashSet((Iterable)stageExecutions.stream().map(SqlStageExecution::getStageExecutionId).collect(Collectors.toSet()));
        SettableFuture future = SettableFuture.create();
        for (SqlStageExecution stage : stageExecutions) {
            stage.addStateChangeListener(state -> {
                if (predicate.test((StageExecutionState)((Object)state)) && stageIds.remove(stage.getStageExecutionId()) && stageIds.isEmpty()) {
                    future.set(null);
                }
            });
        }
        return future;
    }

    private static /* synthetic */ void lambda$createStreamingLinkedStageExecutions$2(Set childStageExecutions, StageExecutionState newState) {
        if (newState.isDone()) {
            childStageExecutions.forEach(SqlStageExecution::cancel);
        }
    }
}

