/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.BuiltInFunction;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.scalar.annotations.ScalarFromAnnotationsParser;
import com.facebook.presto.operator.window.WindowAnnotationsParser;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.WindowFunction;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public final class FunctionExtractor {
    private FunctionExtractor() {
    }

    public static List<BuiltInFunction> extractFunctions(Collection<Class<?>> classes) {
        return (List)classes.stream().map(FunctionExtractor::extractFunctions).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    public static List<? extends BuiltInFunction> extractFunctions(Class<?> clazz) {
        if (WindowFunction.class.isAssignableFrom(clazz)) {
            Class<?> windowClazz = clazz;
            return WindowAnnotationsParser.parseFunctionDefinition(windowClazz);
        }
        if (clazz.isAnnotationPresent(AggregationFunction.class)) {
            return SqlAggregationFunction.createFunctionsByAnnotations(clazz);
        }
        if (clazz.isAnnotationPresent(ScalarFunction.class) || clazz.isAnnotationPresent(ScalarOperator.class)) {
            return ScalarFromAnnotationsParser.parseFunctionDefinition(clazz);
        }
        return ScalarFromAnnotationsParser.parseFunctionDefinitions(clazz);
    }
}

