/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.Aggregator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class AggregationOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalMemoryContext systemMemoryContext;
    private final LocalMemoryContext userMemoryContext;
    private final List<Aggregator> aggregates;
    private final boolean useSystemMemory;
    private State state = State.NEEDS_INPUT;

    public AggregationOperator(OperatorContext operatorContext, AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories, boolean useSystemMemory) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.systemMemoryContext = operatorContext.newLocalSystemMemoryContext(AggregationOperator.class.getSimpleName());
        this.userMemoryContext = operatorContext.localUserMemoryContext();
        this.useSystemMemory = useSystemMemory;
        Objects.requireNonNull(step, "step is null");
        Objects.requireNonNull(accumulatorFactories, "accumulatorFactories is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AccumulatorFactory accumulatorFactory : accumulatorFactories) {
            builder.add((Object)new Aggregator(accumulatorFactory, step));
        }
        this.aggregates = builder.build();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        if (this.state == State.NEEDS_INPUT) {
            this.state = State.HAS_OUTPUT;
        }
    }

    @Override
    public void close() {
        this.userMemoryContext.setBytes(0L);
        this.systemMemoryContext.close();
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.NEEDS_INPUT;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((boolean)this.needsInput(), (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        long memorySize = 0L;
        for (Aggregator aggregate : this.aggregates) {
            aggregate.processPage(page);
            memorySize += aggregate.getEstimatedSize();
        }
        if (this.useSystemMemory) {
            this.systemMemoryContext.setBytes(memorySize);
        } else {
            this.userMemoryContext.setBytes(memorySize);
        }
    }

    @Override
    public Page getOutput() {
        if (this.state != State.HAS_OUTPUT) {
            return null;
        }
        List types = (List)this.aggregates.stream().map(Aggregator::getType).collect(ImmutableList.toImmutableList());
        PageBuilder pageBuilder = new PageBuilder(1, types);
        pageBuilder.declarePosition();
        for (int i = 0; i < this.aggregates.size(); ++i) {
            Aggregator aggregator = this.aggregates.get(i);
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
            aggregator.evaluate(blockBuilder);
        }
        this.state = State.FINISHED;
        return pageBuilder.build();
    }

    private static enum State {
        NEEDS_INPUT,
        HAS_OUTPUT,
        FINISHED;

    }

    public static class AggregationOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final AggregationNode.Step step;
        private final List<AccumulatorFactory> accumulatorFactories;
        private final boolean useSystemMemory;
        private boolean closed;

        public AggregationOperatorFactory(int operatorId, PlanNodeId planNodeId, AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories, boolean useSystemMemory) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.step = step;
            this.accumulatorFactories = ImmutableList.copyOf(accumulatorFactories);
            this.useSystemMemory = useSystemMemory;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, AggregationOperator.class.getSimpleName());
            return new AggregationOperator(operatorContext, this.step, this.accumulatorFactories, this.useSystemMemory);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new AggregationOperatorFactory(this.operatorId, this.planNodeId, this.step, this.accumulatorFactories, this.useSystemMemory);
        }
    }
}

