/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.EmptyLookupSource;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.JoinStatisticsCounter;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupJoinPageBuilder;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.LookupSourceProvider;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PartitionedConsumption;
import com.facebook.presto.operator.StaticLookupSourceProvider;
import com.facebook.presto.operator.exchange.LocalPartitionGenerator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spiller.PartitioningSpiller;
import com.facebook.presto.spiller.PartitioningSpillerFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Future;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class LookupJoinOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> probeTypes;
    private final JoinProbe.JoinProbeFactory joinProbeFactory;
    private final Runnable afterClose;
    private final OptionalInt lookupJoinsCount;
    private final HashGenerator hashGenerator;
    private final LookupSourceFactory lookupSourceFactory;
    private final PartitioningSpillerFactory partitioningSpillerFactory;
    private final JoinStatisticsCounter statisticsCounter;
    private final LookupJoinPageBuilder pageBuilder;
    private final boolean probeOnOuterSide;
    private final ListenableFuture<LookupSourceProvider> lookupSourceProviderFuture;
    private LookupSourceProvider lookupSourceProvider;
    private JoinProbe probe;
    private Page outputPage;
    private Optional<PartitioningSpiller> spiller = Optional.empty();
    private Optional<LocalPartitionGenerator> partitionGenerator = Optional.empty();
    private ListenableFuture<?> spillInProgress = NOT_BLOCKED;
    private long inputPageSpillEpoch;
    private boolean closed;
    private boolean finishing;
    private boolean unspilling;
    private boolean finished;
    private long joinPosition = -1L;
    private int joinSourcePositions;
    private boolean currentProbePositionProducedRow;
    private final Map<Integer, SavedRow> savedRows = new HashMap<Integer, SavedRow>();
    @Nullable
    private ListenableFuture<PartitionedConsumption<Supplier<LookupSource>>> partitionedConsumption;
    @Nullable
    private Iterator<PartitionedConsumption.Partition<Supplier<LookupSource>>> lookupPartitions;
    private Optional<PartitionedConsumption.Partition<Supplier<LookupSource>>> currentPartition = Optional.empty();
    private Optional<ListenableFuture<Supplier<LookupSource>>> unspilledLookupSource = Optional.empty();
    private Iterator<Page> unspilledInputPages = Collections.emptyIterator();

    public LookupJoinOperator(OperatorContext operatorContext, List<Type> probeTypes, List<Type> buildOutputTypes, LookupJoinOperators.JoinType joinType, LookupSourceFactory lookupSourceFactory, JoinProbe.JoinProbeFactory joinProbeFactory, Runnable afterClose, OptionalInt lookupJoinsCount, HashGenerator hashGenerator, PartitioningSpillerFactory partitioningSpillerFactory) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.probeTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeTypes, "probeTypes is null"));
        Objects.requireNonNull(joinType, "joinType is null");
        this.probeOnOuterSide = joinType == LookupJoinOperators.JoinType.PROBE_OUTER || joinType == LookupJoinOperators.JoinType.FULL_OUTER;
        this.joinProbeFactory = Objects.requireNonNull(joinProbeFactory, "joinProbeFactory is null");
        this.afterClose = Objects.requireNonNull(afterClose, "afterClose is null");
        this.lookupJoinsCount = Objects.requireNonNull(lookupJoinsCount, "lookupJoinsCount is null");
        this.hashGenerator = Objects.requireNonNull(hashGenerator, "hashGenerator is null");
        this.lookupSourceFactory = Objects.requireNonNull(lookupSourceFactory, "lookupSourceFactory is null");
        this.partitioningSpillerFactory = Objects.requireNonNull(partitioningSpillerFactory, "partitioningSpillerFactory is null");
        this.lookupSourceProviderFuture = lookupSourceFactory.createLookupSourceProvider();
        this.statisticsCounter = new JoinStatisticsCounter(joinType);
        operatorContext.setInfoSupplier(this.statisticsCounter);
        this.pageBuilder = new LookupJoinPageBuilder(buildOutputTypes);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        if (this.finishing) {
            return;
        }
        if (!this.spillInProgress.isDone()) {
            return;
        }
        MoreFutures.checkSuccess(this.spillInProgress, (String)"spilling failed");
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        boolean finished;
        boolean bl = finished = this.finished && this.probe == null && this.pageBuilder.isEmpty() && this.outputPage == null;
        if (finished) {
            this.close();
        }
        return finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (!this.spillInProgress.isDone()) {
            return this.spillInProgress;
        }
        if (this.unspilledLookupSource.isPresent()) {
            return this.unspilledLookupSource.get();
        }
        if (this.finishing) {
            return NOT_BLOCKED;
        }
        return this.lookupSourceProviderFuture;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.lookupSourceProviderFuture.isDone() && this.spillInProgress.isDone() && this.probe == null && this.outputPage == null;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.probe == null ? 1 : 0) != 0, (Object)"Current page has not been completely processed yet");
        Preconditions.checkState((boolean)this.tryFetchLookupSourceProvider(), (Object)"Not ready to handle input yet");
        SpillInfoSnapshot spillInfoSnapshot = this.lookupSourceProvider.withLease(SpillInfoSnapshot::from);
        this.addInput(page, spillInfoSnapshot);
    }

    private void addInput(Page page, SpillInfoSnapshot spillInfoSnapshot) {
        Objects.requireNonNull(spillInfoSnapshot, "spillInfoSnapshot is null");
        if (spillInfoSnapshot.hasSpilled() && (page = this.spillAndMaskSpilledPositions(page, spillInfoSnapshot.getSpillMask())).getPositionCount() == 0) {
            return;
        }
        this.inputPageSpillEpoch = spillInfoSnapshot.getSpillEpoch();
        this.probe = this.joinProbeFactory.createJoinProbe(page);
        this.joinPosition = -1L;
    }

    private boolean tryFetchLookupSourceProvider() {
        if (this.lookupSourceProvider == null) {
            if (!this.lookupSourceProviderFuture.isDone()) {
                return false;
            }
            this.lookupSourceProvider = (LookupSourceProvider)Objects.requireNonNull(MoreFutures.getDone(this.lookupSourceProviderFuture));
            this.statisticsCounter.updateLookupSourcePositions(this.lookupSourceProvider.withLease(lookupSourceLease -> lookupSourceLease.getLookupSource().getJoinPositionCount()));
        }
        return true;
    }

    private Page spillAndMaskSpilledPositions(Page page, IntPredicate spillMask) {
        Preconditions.checkState((boolean)this.spillInProgress.isDone(), (Object)"Previous spill still in progress");
        MoreFutures.checkSuccess(this.spillInProgress, (String)"spilling failed");
        if (!this.spiller.isPresent()) {
            this.spiller = Optional.of(this.partitioningSpillerFactory.create(this.probeTypes, this.getPartitionGenerator(), this.operatorContext.getSpillContext().newLocalSpillContext(), this.operatorContext.newAggregateSystemMemoryContext()));
        }
        PartitioningSpiller.PartitioningSpillResult result = this.spiller.get().partitionAndSpill(page, spillMask);
        this.spillInProgress = result.getSpillingFuture();
        return result.getRetained();
    }

    public LocalPartitionGenerator getPartitionGenerator() {
        if (!this.partitionGenerator.isPresent()) {
            this.partitionGenerator = Optional.of(new LocalPartitionGenerator(this.hashGenerator, this.lookupSourceFactory.partitions()));
        }
        return this.partitionGenerator.get();
    }

    @Override
    public Page getOutput() {
        if (!this.spillInProgress.isDone()) {
            return null;
        }
        MoreFutures.checkSuccess(this.spillInProgress, (String)"spilling failed");
        if (this.probe == null && this.pageBuilder.isEmpty() && !this.finishing) {
            return null;
        }
        if (!this.tryFetchLookupSourceProvider()) {
            if (!this.finishing) {
                return null;
            }
            Verify.verify((boolean)this.finishing);
            MoreFutures.addSuccessCallback(this.lookupSourceProviderFuture, LookupSourceProvider::close);
            this.lookupSourceProvider = new StaticLookupSourceProvider(new EmptyLookupSource());
        }
        if (this.probe == null && this.finishing && !this.unspilling) {
            Verify.verify((this.partitionedConsumption == null ? 1 : 0) != 0, (String)"partitioned consumption already started", (Object[])new Object[0]);
            this.partitionedConsumption = this.lookupSourceFactory.finishProbeOperator(this.lookupJoinsCount);
            this.unspilling = true;
        }
        if (this.probe == null && this.unspilling && !this.finished) {
            this.tryUnspillNext();
        }
        if (this.probe != null) {
            this.processProbe();
        }
        if (this.outputPage != null) {
            Verify.verify((boolean)this.pageBuilder.isEmpty());
            Page output = this.outputPage;
            this.outputPage = null;
            return output;
        }
        Verify.verify((this.probe != null || this.pageBuilder.isEmpty() ? 1 : 0) != 0);
        return null;
    }

    private void tryUnspillNext() {
        Verify.verify((this.probe == null ? 1 : 0) != 0);
        if (!this.partitionedConsumption.isDone()) {
            return;
        }
        if (this.lookupPartitions == null) {
            this.lookupPartitions = ((PartitionedConsumption)MoreFutures.getDone(this.partitionedConsumption)).beginConsumption();
        }
        if (this.unspilledInputPages.hasNext()) {
            this.addInput(this.unspilledInputPages.next());
            return;
        }
        if (this.unspilledLookupSource.isPresent()) {
            if (!this.unspilledLookupSource.get().isDone()) {
                return;
            }
            LookupSource lookupSource = (LookupSource)((Supplier)MoreFutures.getDone((Future)((Future)this.unspilledLookupSource.get()))).get();
            this.unspilledLookupSource = Optional.empty();
            this.lookupSourceProvider.close();
            this.lookupSourceProvider = new StaticLookupSourceProvider(lookupSource);
            this.statisticsCounter.updateLookupSourcePositions(lookupSource.getJoinPositionCount());
            int partition = this.currentPartition.get().number();
            this.unspilledInputPages = this.spiller.map(spiller -> spiller.getSpilledPages(partition)).orElse(Collections.emptyIterator());
            Optional.ofNullable(this.savedRows.remove(partition)).ifPresent(savedRow -> this.restoreProbe(savedRow.row, savedRow.joinPositionWithinPartition, savedRow.currentProbePositionProducedRow, savedRow.joinSourcePositions, SpillInfoSnapshot.noSpill()));
            return;
        }
        if (this.lookupPartitions.hasNext()) {
            this.currentPartition.ifPresent(PartitionedConsumption.Partition::release);
            this.currentPartition = Optional.of(this.lookupPartitions.next());
            this.unspilledLookupSource = Optional.of(this.currentPartition.get().load());
            return;
        }
        this.currentPartition.ifPresent(PartitionedConsumption.Partition::release);
        if (this.lookupSourceProvider != null) {
            this.lookupSourceProvider.close();
            this.lookupSourceProvider = null;
        }
        this.spiller.ifPresent(PartitioningSpiller::verifyAllPartitionsRead);
        this.finished = true;
    }

    private void processProbe() {
        Verify.verify((this.probe != null ? 1 : 0) != 0);
        Optional spillInfoSnapshotIfSpillChanged = this.lookupSourceProvider.withLease(lookupSourceLease -> {
            if (lookupSourceLease.spillEpoch() == this.inputPageSpillEpoch) {
                this.processProbe(lookupSourceLease.getLookupSource());
                return Optional.empty();
            }
            return Optional.of(SpillInfoSnapshot.from(lookupSourceLease));
        });
        if (!spillInfoSnapshotIfSpillChanged.isPresent()) {
            return;
        }
        SpillInfoSnapshot spillInfoSnapshot = (SpillInfoSnapshot)spillInfoSnapshotIfSpillChanged.get();
        long joinPositionWithinPartition = this.joinPosition >= 0L ? this.lookupSourceProvider.withLease(lookupSourceLease -> lookupSourceLease.getLookupSource().joinPositionWithinPartition(this.joinPosition)) : -1L;
        Verify.verify((boolean)spillInfoSnapshot.hasSpilled());
        Verify.verify((spillInfoSnapshot.getSpillEpoch() > this.inputPageSpillEpoch ? 1 : 0) != 0);
        Page currentPage = this.probe.getPage();
        int currentPosition = this.probe.getPosition();
        long currentJoinPosition = this.joinPosition;
        boolean currentProbePositionProducedRow = this.currentProbePositionProducedRow;
        this.clearProbe();
        if (currentPosition < 0) {
            this.addInput(currentPage, spillInfoSnapshot);
        } else {
            int currentRowPartition = this.getPartitionGenerator().getPartition(currentPage, currentPosition);
            boolean currentRowSpilled = spillInfoSnapshot.getSpillMask().test(currentRowPartition);
            if (currentRowSpilled) {
                this.savedRows.merge(currentRowPartition, new SavedRow(currentPage, currentPosition, joinPositionWithinPartition, currentProbePositionProducedRow, this.joinSourcePositions), (oldValue, newValue) -> {
                    throw new IllegalStateException(String.format("Partition %s is already spilled", currentRowPartition));
                });
                this.joinSourcePositions = 0;
                Page unprocessed = this.pageTail(currentPage, currentPosition + 1);
                this.addInput(unprocessed, spillInfoSnapshot);
            } else {
                Page remaining = this.pageTail(currentPage, currentPosition);
                this.restoreProbe(remaining, currentJoinPosition, currentProbePositionProducedRow, this.joinSourcePositions, spillInfoSnapshot);
            }
        }
    }

    private void processProbe(LookupSource lookupSource) {
        Verify.verify((this.probe != null ? 1 : 0) != 0);
        DriverYieldSignal yieldSignal = this.operatorContext.getDriverContext().getYieldSignal();
        while (!yieldSignal.isSet()) {
            if (this.probe.getPosition() >= 0) {
                if (!this.joinCurrentPosition(lookupSource, yieldSignal)) break;
                if (!this.currentProbePositionProducedRow) {
                    this.currentProbePositionProducedRow = true;
                    if (!this.outerJoinCurrentPosition()) break;
                }
            }
            this.currentProbePositionProducedRow = false;
            if (!this.advanceProbePosition(lookupSource)) break;
            this.statisticsCounter.recordProbe(this.joinSourcePositions);
            this.joinSourcePositions = 0;
        }
    }

    private void restoreProbe(Page probePage, long joinPosition, boolean currentProbePositionProducedRow, int joinSourcePositions, SpillInfoSnapshot spillInfoSnapshot) {
        Verify.verify((this.probe == null ? 1 : 0) != 0);
        this.addInput(probePage, spillInfoSnapshot);
        Verify.verify((boolean)this.probe.advanceNextPosition());
        this.joinPosition = joinPosition;
        this.currentProbePositionProducedRow = currentProbePositionProducedRow;
        this.joinSourcePositions = joinSourcePositions;
    }

    private Page pageTail(Page currentPage, int startAtPosition) {
        Verify.verify((currentPage.getPositionCount() - startAtPosition >= 0 ? 1 : 0) != 0);
        return currentPage.getRegion(startAtPosition, currentPage.getPositionCount() - startAtPosition);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.probe = null;
        try (Closer closer = Closer.create();){
            closer.register(this.afterClose::run);
            closer.register(this.pageBuilder::reset);
            closer.register(() -> Optional.ofNullable(this.lookupSourceProvider).ifPresent(LookupSourceProvider::close));
            this.spiller.ifPresent(arg_0 -> ((Closer)closer).register(arg_0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean joinCurrentPosition(LookupSource lookupSource, DriverYieldSignal yieldSignal) {
        while (this.joinPosition >= 0L) {
            if (lookupSource.isJoinPositionEligible(this.joinPosition, this.probe.getPosition(), this.probe.getPage())) {
                this.currentProbePositionProducedRow = true;
                this.pageBuilder.appendRow(this.probe, lookupSource, this.joinPosition);
                ++this.joinSourcePositions;
            }
            this.joinPosition = lookupSource.getNextJoinPosition(this.joinPosition, this.probe.getPosition(), this.probe.getPage());
            if (!yieldSignal.isSet() && !this.tryBuildPage()) continue;
            return false;
        }
        return true;
    }

    private boolean advanceProbePosition(LookupSource lookupSource) {
        if (!this.probe.advanceNextPosition()) {
            this.clearProbe();
            return false;
        }
        this.joinPosition = this.probe.getCurrentJoinPosition(lookupSource);
        return true;
    }

    private boolean outerJoinCurrentPosition() {
        if (this.probeOnOuterSide && this.joinPosition < 0L) {
            this.pageBuilder.appendNullForBuild(this.probe);
            if (this.tryBuildPage()) {
                return false;
            }
        }
        return true;
    }

    private boolean tryBuildPage() {
        if (this.pageBuilder.isFull()) {
            this.buildPage();
            return true;
        }
        return false;
    }

    private void buildPage() {
        Verify.verify((this.outputPage == null ? 1 : 0) != 0);
        Verify.verify((this.probe != null ? 1 : 0) != 0);
        if (this.pageBuilder.isEmpty()) {
            return;
        }
        this.outputPage = this.pageBuilder.build(this.probe);
        this.pageBuilder.reset();
    }

    private void clearProbe() {
        this.buildPage();
        this.probe = null;
    }

    public static class SavedRow {
        public final Page row;
        public final long joinPositionWithinPartition;
        public final boolean currentProbePositionProducedRow;
        public final int joinSourcePositions;

        public SavedRow(Page page, int position, long joinPositionWithinPartition, boolean currentProbePositionProducedRow, int joinSourcePositions) {
            this.row = page.getSingleValuePage(position);
            this.joinPositionWithinPartition = joinPositionWithinPartition;
            this.currentProbePositionProducedRow = currentProbePositionProducedRow;
            this.joinSourcePositions = joinSourcePositions;
        }
    }

    public static class SpillInfoSnapshot {
        private final boolean hasSpilled;
        private final long spillEpoch;
        private final IntPredicate spillMask;

        public SpillInfoSnapshot(boolean hasSpilled, long spillEpoch, IntPredicate spillMask) {
            this.hasSpilled = hasSpilled;
            this.spillEpoch = spillEpoch;
            this.spillMask = Objects.requireNonNull(spillMask, "spillMask is null");
        }

        public static SpillInfoSnapshot from(LookupSourceProvider.LookupSourceLease lookupSourceLease) {
            return new SpillInfoSnapshot(lookupSourceLease.hasSpilled(), lookupSourceLease.spillEpoch(), lookupSourceLease.getSpillMask());
        }

        public static SpillInfoSnapshot noSpill() {
            return new SpillInfoSnapshot(false, 0L, i -> false);
        }

        public boolean hasSpilled() {
            return this.hasSpilled;
        }

        public long getSpillEpoch() {
            return this.spillEpoch;
        }

        public IntPredicate getSpillMask() {
            return this.spillMask;
        }
    }
}

