/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.buffer.PagesSerde;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PageWithPositionComparator;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.operator.TaskExchangeClientManager;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.UpdatablePageSource;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.RemoteSplit;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.util.MergeSortedPages;
import com.facebook.presto.util.MoreLists;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class MergeOperator
implements SourceOperator,
Closeable {
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private final TaskExchangeClientManager taskExchangeClientManager;
    private final PagesSerde pagesSerde;
    private final PageWithPositionComparator comparator;
    private final List<Integer> outputChannels;
    private final List<Type> outputTypes;
    private final SettableFuture<Void> blockedOnSplits = SettableFuture.create();
    private final List<WorkProcessor<Page>> pageProducers = new ArrayList<WorkProcessor<Page>>();
    private final Closer closer = Closer.create();
    private WorkProcessor<Page> mergedPages;
    private boolean closed;

    public MergeOperator(OperatorContext operatorContext, PlanNodeId sourceId, TaskExchangeClientManager taskExchangeClientManager, PagesSerde pagesSerde, PageWithPositionComparator comparator, List<Integer> outputChannels, List<Type> outputTypes) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
        this.taskExchangeClientManager = Objects.requireNonNull(taskExchangeClientManager, "taskExchangeClientManager is null");
        this.pagesSerde = Objects.requireNonNull(pagesSerde, "pagesSerde is null");
        this.comparator = Objects.requireNonNull(comparator, "comparator is null");
        this.outputChannels = Objects.requireNonNull(outputChannels, "outputChannels is null");
        this.outputTypes = Objects.requireNonNull(outputTypes, "outputTypes is null");
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public Supplier<Optional<UpdatablePageSource>> addSplit(Split split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkArgument((boolean)(split.getConnectorSplit() instanceof RemoteSplit), (Object)"split is not a remote split");
        Preconditions.checkState((!this.blockedOnSplits.isDone() ? 1 : 0) != 0, (Object)"noMoreSplits has been called already");
        RemoteSplit remoteSplit = (RemoteSplit)split.getConnectorSplit();
        ExchangeClient exchangeClient = (ExchangeClient)this.closer.register((Closeable)this.taskExchangeClientManager.createExchangeClient(this.operatorContext.localSystemMemoryContext()));
        exchangeClient.addLocation(remoteSplit.getLocation().toURI(), remoteSplit.getRemoteSourceTaskId());
        exchangeClient.noMoreLocations();
        this.pageProducers.add(exchangeClient.pages().map(serializedPage -> {
            this.operatorContext.recordRawInput(serializedPage.getSizeInBytes(), serializedPage.getPositionCount());
            return this.pagesSerde.deserialize((SerializedPage)serializedPage);
        }));
        return Optional::empty;
    }

    @Override
    public void noMoreSplits() {
        this.mergedPages = MergeSortedPages.mergeSortedPages(this.pageProducers, this.comparator, this.outputChannels, this.outputTypes, (pageBuilder, pageWithPosition) -> pageBuilder.isFull(), false, this.operatorContext.aggregateUserMemoryContext(), this.operatorContext.getDriverContext().getYieldSignal());
        this.blockedOnSplits.set(null);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.close();
    }

    @Override
    public boolean isFinished() {
        return this.closed || this.mergedPages != null && this.mergedPages.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (!this.blockedOnSplits.isDone()) {
            return this.blockedOnSplits;
        }
        if (this.mergedPages.isBlocked()) {
            return this.mergedPages.getBlockedFuture();
        }
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " can not take input");
    }

    @Override
    public Page getOutput() {
        if (this.closed || this.mergedPages == null || !this.mergedPages.process() || this.mergedPages.isFinished()) {
            return null;
        }
        Page page = this.mergedPages.getResult();
        this.operatorContext.recordProcessedInput(page.getSizeInBytes(), page.getPositionCount());
        return page;
    }

    @Override
    public void close() {
        try {
            this.closer.close();
            this.closed = true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class MergeOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final TaskExchangeClientManager taskExchangeClientManager;
        private final PagesSerdeFactory serdeFactory;
        private final List<Type> types;
        private final List<Integer> outputChannels;
        private final List<Type> outputTypes;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrder;
        private final OrderingCompiler orderingCompiler;
        private boolean closed;

        public MergeOperatorFactory(int operatorId, PlanNodeId sourceId, TaskExchangeClientManager taskExchangeClientManager, PagesSerdeFactory serdeFactory, OrderingCompiler orderingCompiler, List<Type> types, List<Integer> outputChannels, List<Integer> sortChannels, List<SortOrder> sortOrder) {
            this.operatorId = operatorId;
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.taskExchangeClientManager = Objects.requireNonNull(taskExchangeClientManager, "taskExchangeClientManager is null");
            this.serdeFactory = Objects.requireNonNull(serdeFactory, "serdeFactory is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.outputChannels = Objects.requireNonNull(outputChannels, "outputChannels is null");
            this.outputTypes = MoreLists.mappedCopy(outputChannels, types::get);
            this.sortChannels = Objects.requireNonNull(sortChannels, "sortChannels is null");
            this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder is null");
            this.orderingCompiler = Objects.requireNonNull(orderingCompiler, "mergeSortComparatorFactory is null");
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, MergeOperator.class.getSimpleName());
            return new MergeOperator(operatorContext, this.sourceId, this.taskExchangeClientManager, this.serdeFactory.createPagesSerde(), this.orderingCompiler.compilePageWithPositionComparator(this.types, this.sortChannels, this.sortOrder), this.outputChannels, this.outputTypes);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }
}

