/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.ArrayPositionLinks;
import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.PositionLinks;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.Page;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public final class SortedPositionLinks
implements PositionLinks {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SortedPositionLinks.class).instanceSize();
    private final PositionLinks positionLinks;
    private final int[][] sortedPositionLinks;
    private final long sizeInBytes;
    private final JoinFilterFunction[] searchFunctions;

    private SortedPositionLinks(PositionLinks positionLinks, int[][] sortedPositionLinks, List<JoinFilterFunction> searchFunctions) {
        this.positionLinks = Objects.requireNonNull(positionLinks, "positionLinks is null");
        this.sortedPositionLinks = Objects.requireNonNull(sortedPositionLinks, "sortedPositionLinks is null");
        this.sizeInBytes = (long)INSTANCE_SIZE + positionLinks.getSizeInBytes() + this.sizeOfPositionLinks(sortedPositionLinks);
        Objects.requireNonNull(searchFunctions, "searchFunctions is null");
        Preconditions.checkState((!searchFunctions.isEmpty() ? 1 : 0) != 0, (Object)"Using sortedPositionLinks with no search functions");
        this.searchFunctions = (JoinFilterFunction[])searchFunctions.stream().toArray(JoinFilterFunction[]::new);
    }

    private long sizeOfPositionLinks(int[][] sortedPositionLinks) {
        long retainedSize = SizeOf.sizeOf((Object[])sortedPositionLinks);
        for (int[] element : sortedPositionLinks) {
            retainedSize += SizeOf.sizeOf((int[])element);
        }
        return retainedSize;
    }

    public static FactoryBuilder builder(int size, PagesHashStrategy pagesHashStrategy, LongArrayList addresses) {
        return new FactoryBuilder(size, pagesHashStrategy, addresses);
    }

    @Override
    public int next(int position, int probePosition, Page allProbeChannelsPage) {
        int nextPosition = this.positionLinks.next(position, probePosition, allProbeChannelsPage);
        if (nextPosition < 0) {
            return -1;
        }
        if (!this.applyAllSearchFunctions(nextPosition, probePosition, allProbeChannelsPage)) {
            return -1;
        }
        return nextPosition;
    }

    @Override
    public int start(int startingPosition, int probePosition, Page allProbeChannelsPage) {
        if (this.applyAllSearchFunctions(startingPosition, probePosition, allProbeChannelsPage)) {
            return startingPosition;
        }
        int[] links = this.sortedPositionLinks[startingPosition];
        if (links == null) {
            return -1;
        }
        int currentStartOffset = 0;
        for (JoinFilterFunction searchFunction : this.searchFunctions) {
            if ((currentStartOffset = this.findStartPositionForFunction(searchFunction, links, currentStartOffset, probePosition, allProbeChannelsPage)) != -1) continue;
            return -1;
        }
        return links[currentStartOffset];
    }

    private boolean applyAllSearchFunctions(int buildPosition, int probePosition, Page allProbeChannelsPage) {
        for (JoinFilterFunction searchFunction : this.searchFunctions) {
            if (this.applySearchFunction(searchFunction, buildPosition, probePosition, allProbeChannelsPage)) continue;
            return false;
        }
        return true;
    }

    private int findStartPositionForFunction(JoinFilterFunction searchFunction, int[] links, int startOffset, int probePosition, Page allProbeChannelsPage) {
        if (this.applySearchFunction(searchFunction, links, startOffset, probePosition, allProbeChannelsPage)) {
            return startOffset;
        }
        int offset = this.lowerBound(searchFunction, links, startOffset, links.length - 1, probePosition, allProbeChannelsPage);
        if (!this.applySearchFunction(searchFunction, links, offset, probePosition, allProbeChannelsPage)) {
            return -1;
        }
        return offset;
    }

    private int lowerBound(JoinFilterFunction searchFunction, int[] links, int first, int last, int probePosition, Page allProbeChannelsPage) {
        int count = last - first;
        while (count > 0) {
            int step = count / 2;
            int middle = first + step;
            if (!this.applySearchFunction(searchFunction, links, middle, probePosition, allProbeChannelsPage)) {
                first = ++middle;
                count -= step + 1;
                continue;
            }
            count = step;
        }
        return first;
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    private boolean applySearchFunction(JoinFilterFunction searchFunction, int[] links, int linkOffset, int probePosition, Page allProbeChannelsPage) {
        return this.applySearchFunction(searchFunction, links[linkOffset], probePosition, allProbeChannelsPage);
    }

    private boolean applySearchFunction(JoinFilterFunction searchFunction, long buildPosition, int probePosition, Page allProbeChannelsPage) {
        return searchFunction.filter((int)buildPosition, probePosition, allProbeChannelsPage);
    }

    private static class PositionComparator
    implements IntComparator {
        private final PagesHashStrategy pagesHashStrategy;
        private final LongArrayList addresses;

        PositionComparator(PagesHashStrategy pagesHashStrategy, LongArrayList addresses) {
            this.pagesHashStrategy = pagesHashStrategy;
            this.addresses = addresses;
        }

        public int compare(int leftPosition, int rightPosition) {
            long leftPageAddress = this.addresses.getLong(leftPosition);
            int leftBlockIndex = SyntheticAddress.decodeSliceIndex(leftPageAddress);
            int leftBlockPosition = SyntheticAddress.decodePosition(leftPageAddress);
            long rightPageAddress = this.addresses.getLong(rightPosition);
            int rightBlockIndex = SyntheticAddress.decodeSliceIndex(rightPageAddress);
            int rightBlockPosition = SyntheticAddress.decodePosition(rightPageAddress);
            return this.pagesHashStrategy.compareSortChannelPositions(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition);
        }

        public int compare(Integer leftPosition, Integer rightPosition) {
            return this.compare((int)leftPosition, (int)rightPosition);
        }
    }

    public static class FactoryBuilder
    implements PositionLinks.FactoryBuilder {
        private final Int2ObjectMap<IntArrayList> positionLinks;
        private final int size;
        private final IntComparator comparator;
        private final PagesHashStrategy pagesHashStrategy;
        private final LongArrayList addresses;

        public FactoryBuilder(int size, PagesHashStrategy pagesHashStrategy, LongArrayList addresses) {
            this.size = size;
            this.comparator = new PositionComparator(pagesHashStrategy, addresses);
            this.pagesHashStrategy = pagesHashStrategy;
            this.addresses = addresses;
            this.positionLinks = new Int2ObjectOpenHashMap();
        }

        @Override
        public int link(int from, int to) {
            if (this.isNull(from)) {
                return to;
            }
            if (this.isNull(to)) {
                return from;
            }
            if (this.comparator.compare(from, to) > 0) {
                List links = (List)this.positionLinks.computeIfAbsent((Object)to, key -> new IntArrayList());
                links.add(from);
                return to;
            }
            IntArrayList links = (IntArrayList)this.positionLinks.remove(to);
            if (links == null) {
                links = new IntArrayList();
            }
            links.add(to);
            Preconditions.checkState((this.positionLinks.putIfAbsent((Object)from, (Object)links) == null ? 1 : 0) != 0, (Object)"sorted links is corrupted");
            return from;
        }

        private boolean isNull(int position) {
            long pageAddress = this.addresses.getLong(position);
            int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
            int blockPosition = SyntheticAddress.decodePosition(pageAddress);
            return this.pagesHashStrategy.isSortChannelPositionNull(blockIndex, blockPosition);
        }

        @Override
        public PositionLinks.Factory build() {
            ArrayPositionLinks.FactoryBuilder arrayPositionLinksFactoryBuilder = ArrayPositionLinks.builder(this.size);
            final int[][] sortedPositionLinks = new int[this.size][];
            for (Int2ObjectMap.Entry entry : this.positionLinks.int2ObjectEntrySet()) {
                int i;
                int key = entry.getIntKey();
                IntArrayList positions = (IntArrayList)entry.getValue();
                positions.sort((Comparator)this.comparator);
                sortedPositionLinks[key] = new int[positions.size()];
                for (i = 0; i < positions.size(); ++i) {
                    sortedPositionLinks[key][i] = positions.get(i);
                }
                for (i = positions.size() - 2; i >= 0; --i) {
                    arrayPositionLinksFactoryBuilder.link(positions.get(i), positions.get(i + 1));
                }
                if (positions.isEmpty()) continue;
                arrayPositionLinksFactoryBuilder.link(key, positions.get(0));
            }
            final PositionLinks.Factory arrayPositionLinksFactory = arrayPositionLinksFactoryBuilder.build();
            return new PositionLinks.Factory(){

                @Override
                public PositionLinks create(List<JoinFilterFunction> searchFunctions) {
                    return new SortedPositionLinks(arrayPositionLinksFactory.create((List<JoinFilterFunction>)ImmutableList.of()), sortedPositionLinks, searchFunctions);
                }

                @Override
                public long checksum() {
                    return arrayPositionLinksFactory.checksum();
                }
            };
        }

        @Override
        public int size() {
            return this.positionLinks.size();
        }
    }
}

