/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.facebook.presto.geospatial.KdbTreeUtils;
import com.facebook.presto.geospatial.Rectangle;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PagesSpatialIndexFactory;
import com.facebook.presto.operator.PagesSpatialIndexSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;

public class SpatialIndexBuilderOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalMemoryContext localUserMemoryContext;
    private final PagesSpatialIndexFactory pagesSpatialIndexFactory;
    private final List<Integer> outputChannels;
    private final int indexChannel;
    private final Optional<Integer> radiusChannel;
    private final Optional<Integer> partitionChannel;
    private final SpatialPredicate spatialRelationshipTest;
    private final Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory;
    private final Map<Integer, Rectangle> partitions;
    private final PagesIndex index;
    private ListenableFuture<?> indexNotNeeded;
    private boolean finishing;
    private boolean finished;

    private SpatialIndexBuilderOperator(OperatorContext operatorContext, PagesSpatialIndexFactory pagesSpatialIndexFactory, List<Integer> outputChannels, int indexChannel, Optional<Integer> radiusChannel, Optional<Integer> partitionChannel, SpatialPredicate spatialRelationshipTest, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, int expectedPositions, PagesIndex.Factory pagesIndexFactory, Map<Integer, Rectangle> partitions) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
        this.spatialRelationshipTest = Objects.requireNonNull(spatialRelationshipTest, "spatialRelationshipTest is null");
        this.filterFunctionFactory = filterFunctionFactory;
        this.pagesSpatialIndexFactory = Objects.requireNonNull(pagesSpatialIndexFactory, "pagesSpatialIndexFactory is null");
        this.index = pagesIndexFactory.newPagesIndex(pagesSpatialIndexFactory.getTypes(), expectedPositions);
        this.outputChannels = Objects.requireNonNull(outputChannels, "outputChannels is null");
        this.indexChannel = indexChannel;
        this.radiusChannel = radiusChannel;
        this.partitionChannel = Objects.requireNonNull(partitionChannel, "partitionChannel is null");
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        this.index.addPage(page);
        if (!this.localUserMemoryContext.trySetBytes(this.index.getEstimatedSize().toBytes())) {
            this.index.compact();
            this.localUserMemoryContext.setBytes(this.index.getEstimatedSize().toBytes());
        }
        this.operatorContext.recordOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.indexNotNeeded != null && !this.indexNotNeeded.isDone()) {
            return this.indexNotNeeded;
        }
        return NOT_BLOCKED;
    }

    @Override
    public void finish() {
        if (this.finishing) {
            return;
        }
        this.finishing = true;
        this.localUserMemoryContext.setBytes(this.index.getEstimatedSize().toBytes());
        PagesSpatialIndexSupplier spatialIndex = this.index.createPagesSpatialIndex(this.operatorContext.getSession(), this.indexChannel, this.radiusChannel, this.partitionChannel, this.spatialRelationshipTest, this.filterFunctionFactory, this.outputChannels, this.partitions, this.localUserMemoryContext);
        this.localUserMemoryContext.setBytes(this.index.getEstimatedSize().toBytes() + spatialIndex.getEstimatedSize().toBytes());
        this.indexNotNeeded = this.pagesSpatialIndexFactory.lendPagesSpatialIndex(spatialIndex);
    }

    @Override
    public boolean isFinished() {
        if (this.finished) {
            return true;
        }
        if (this.finishing && this.indexNotNeeded.isDone()) {
            this.index.clear();
            this.localUserMemoryContext.setBytes(this.index.getEstimatedSize().toBytes());
            this.finished = true;
        }
        return this.finished;
    }

    @Override
    public void close() {
        this.index.clear();
        this.localUserMemoryContext.setBytes(this.index.getEstimatedSize().toBytes());
    }

    public static final class SpatialIndexBuilderOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final PagesSpatialIndexFactory pagesSpatialIndexFactory;
        private final List<Integer> outputChannels;
        private final int indexChannel;
        private final Optional<Integer> radiusChannel;
        private final Optional<Integer> partitionChannel;
        private final SpatialPredicate spatialRelationshipTest;
        private final Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory;
        private final PagesIndex.Factory pagesIndexFactory;
        private final Map<Integer, Rectangle> spatialPartitions = new HashMap<Integer, Rectangle>();
        private final int expectedPositions;
        private boolean closed;

        public SpatialIndexBuilderOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Type> types, List<Integer> outputChannels, int indexChannel, Optional<Integer> radiusChannel, Optional<Integer> partitionChannel, SpatialPredicate spatialRelationshipTest, Optional<String> kdbTreeJson, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, int expectedPositions, PagesIndex.Factory pagesIndexFactory) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.outputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
            List outputTypes = (List)outputChannels.stream().map(types::get).collect(ImmutableList.toImmutableList());
            this.pagesSpatialIndexFactory = new PagesSpatialIndexFactory(types, outputTypes);
            this.indexChannel = indexChannel;
            this.radiusChannel = radiusChannel;
            this.partitionChannel = Objects.requireNonNull(partitionChannel, "partitionChannel is null");
            this.spatialRelationshipTest = spatialRelationshipTest;
            this.filterFunctionFactory = Objects.requireNonNull(filterFunctionFactory, "filterFunctionFactory is null");
            this.pagesIndexFactory = pagesIndexFactory;
            this.expectedPositions = expectedPositions;
            kdbTreeJson.ifPresent(json -> this.spatialPartitions.putAll(KdbTreeUtils.fromJson((String)json).getLeaves()));
        }

        public PagesSpatialIndexFactory getPagesSpatialIndexFactory() {
            return this.pagesSpatialIndexFactory;
        }

        @Override
        public SpatialIndexBuilderOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, SpatialIndexBuilderOperator.class.getSimpleName());
            return new SpatialIndexBuilderOperator(operatorContext, this.pagesSpatialIndexFactory, this.outputChannels, this.indexChannel, this.radiusChannel, this.partitionChannel, this.spatialRelationshipTest, this.filterFunctionFactory, this.expectedPositions, this.pagesIndexFactory, this.spatialPartitions);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException("Spatial index build can not be duplicated");
        }
    }

    @FunctionalInterface
    public static interface SpatialPredicate {
        public boolean apply(OGCGeometry var1, OGCGeometry var2, OptionalDouble var3);
    }
}

