/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.WindowFunctionDefinition;
import com.facebook.presto.operator.WindowInfo;
import com.facebook.presto.operator.window.FramedWindowFunction;
import com.facebook.presto.operator.window.WindowPartition;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.type.Type;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.stream.Stream;

public class WindowOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final int[] outputChannels;
    private final List<FramedWindowFunction> windowFunctions;
    private final List<Integer> orderChannels;
    private final List<SortOrder> ordering;
    private final LocalMemoryContext localUserMemoryContext;
    private final int[] preGroupedChannels;
    private final PagesHashStrategy preGroupedPartitionHashStrategy;
    private final PagesHashStrategy unGroupedPartitionHashStrategy;
    private final PagesHashStrategy preSortedPartitionHashStrategy;
    private final PagesHashStrategy peerGroupHashStrategy;
    private final PagesIndex pagesIndex;
    private final PageBuilder pageBuilder;
    private final WindowInfo.DriverWindowInfoBuilder windowInfo;
    private final AtomicReference<Optional<WindowInfo.DriverWindowInfo>> driverWindowInfo = new AtomicReference(Optional.empty());
    private State state = State.NEEDS_INPUT;
    private WindowPartition partition;
    private Page pendingInput;

    public WindowOperator(OperatorContext operatorContext, List<Type> sourceTypes, List<Integer> outputChannels, List<WindowFunctionDefinition> windowFunctionDefinitions, List<Integer> partitionChannels, List<Integer> preGroupedChannels, List<Integer> sortChannels, List<SortOrder> sortOrder, int preSortedChannelPrefix, int expectedPositions, PagesIndex.Factory pagesIndexFactory) {
        Objects.requireNonNull(operatorContext, "operatorContext is null");
        Objects.requireNonNull(outputChannels, "outputChannels is null");
        Objects.requireNonNull(windowFunctionDefinitions, "windowFunctionDefinitions is null");
        Objects.requireNonNull(partitionChannels, "partitionChannels is null");
        Objects.requireNonNull(preGroupedChannels, "preGroupedChannels is null");
        Preconditions.checkArgument((boolean)partitionChannels.containsAll(preGroupedChannels), (Object)"preGroupedChannels must be a subset of partitionChannels");
        Objects.requireNonNull(sortChannels, "sortChannels is null");
        Objects.requireNonNull(sortOrder, "sortOrder is null");
        Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
        Preconditions.checkArgument((sortChannels.size() == sortOrder.size() ? 1 : 0) != 0, (Object)"Must have same number of sort channels as sort orders");
        Preconditions.checkArgument((preSortedChannelPrefix <= sortChannels.size() ? 1 : 0) != 0, (Object)"Cannot have more pre-sorted channels than specified sorted channels");
        Preconditions.checkArgument((preSortedChannelPrefix == 0 || ImmutableSet.copyOf(preGroupedChannels).equals((Object)ImmutableSet.copyOf(partitionChannels)) ? 1 : 0) != 0, (Object)"preSortedChannelPrefix can only be greater than zero if all partition channels are pre-grouped");
        this.operatorContext = operatorContext;
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
        this.outputChannels = Ints.toArray(outputChannels);
        this.windowFunctions = (List)windowFunctionDefinitions.stream().map(functionDefinition -> new FramedWindowFunction(functionDefinition.createWindowFunction(), functionDefinition.getFrameInfo())).collect(ImmutableList.toImmutableList());
        List types = (List)Stream.concat(outputChannels.stream().map(sourceTypes::get), windowFunctionDefinitions.stream().map(WindowFunctionDefinition::getType)).collect(ImmutableList.toImmutableList());
        this.pagesIndex = pagesIndexFactory.newPagesIndex(sourceTypes, expectedPositions);
        this.preGroupedChannels = Ints.toArray(preGroupedChannels);
        this.preGroupedPartitionHashStrategy = this.pagesIndex.createPagesHashStrategy(preGroupedChannels, OptionalInt.empty());
        List unGroupedPartitionChannels = (List)partitionChannels.stream().filter(channel -> !preGroupedChannels.contains(channel)).collect(ImmutableList.toImmutableList());
        this.unGroupedPartitionHashStrategy = this.pagesIndex.createPagesHashStrategy(unGroupedPartitionChannels, OptionalInt.empty());
        List preSortedChannels = (List)sortChannels.stream().limit(preSortedChannelPrefix).collect(ImmutableList.toImmutableList());
        this.preSortedPartitionHashStrategy = this.pagesIndex.createPagesHashStrategy(preSortedChannels, OptionalInt.empty());
        this.peerGroupHashStrategy = this.pagesIndex.createPagesHashStrategy(sortChannels, OptionalInt.empty());
        this.pageBuilder = new PageBuilder(types);
        if (preSortedChannelPrefix > 0) {
            this.orderChannels = ImmutableList.copyOf((Iterable)Iterables.skip(sortChannels, (int)preSortedChannelPrefix));
            this.ordering = ImmutableList.copyOf((Iterable)Iterables.skip(sortOrder, (int)preSortedChannelPrefix));
        } else {
            this.orderChannels = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)unGroupedPartitionChannels, sortChannels));
            this.ordering = ImmutableList.copyOf((Iterable)Iterables.concat(Collections.nCopies(unGroupedPartitionChannels.size(), SortOrder.ASC_NULLS_LAST), sortOrder));
        }
        this.windowInfo = new WindowInfo.DriverWindowInfoBuilder();
        operatorContext.setInfoSupplier(this::getWindowInfo);
    }

    private OperatorInfo getWindowInfo() {
        return new WindowInfo((List)this.driverWindowInfo.get().map(ImmutableList::of).orElse(ImmutableList.of()));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        if (this.state == State.FINISHING || this.state == State.FINISHED) {
            return;
        }
        if (this.state == State.NEEDS_INPUT) {
            this.finishPagesIndex();
        }
        this.state = State.FINISHING;
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.NEEDS_INPUT;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((this.state == State.NEEDS_INPUT ? 1 : 0) != 0, (Object)"Operator can not take input at this time");
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.pendingInput == null ? 1 : 0) != 0, (Object)"Operator already has pending input");
        if (page.getPositionCount() == 0) {
            return;
        }
        this.pendingInput = page;
        if (this.processPendingInput()) {
            this.state = State.HAS_OUTPUT;
        }
        this.localUserMemoryContext.setBytes(this.pagesIndex.getEstimatedSize().toBytes());
    }

    private boolean processPendingInput() {
        Preconditions.checkState((this.pendingInput != null ? 1 : 0) != 0);
        this.pendingInput = this.updatePagesIndex(this.pendingInput);
        if (this.pendingInput != null || this.state == State.FINISHING) {
            this.finishPagesIndex();
            return true;
        }
        return false;
    }

    private Page updatePagesIndex(Page page) {
        Preconditions.checkArgument((page.getPositionCount() > 0 ? 1 : 0) != 0);
        Page preGroupedPage = WindowOperator.rearrangePage(page, this.preGroupedChannels);
        if (this.pagesIndex.getPositionCount() == 0 || this.pagesIndex.positionEqualsRow(this.preGroupedPartitionHashStrategy, 0, 0, preGroupedPage)) {
            int groupEnd = WindowOperator.findGroupEnd(preGroupedPage, this.preGroupedPartitionHashStrategy, 0);
            this.pagesIndex.addPage(page.getRegion(0, groupEnd));
            if (page.getPositionCount() - groupEnd > 0) {
                return page.getRegion(groupEnd, page.getPositionCount() - groupEnd);
            }
            return null;
        }
        return page;
    }

    private static Page rearrangePage(Page page, int[] channels) {
        Block[] newBlocks = new Block[channels.length];
        for (int i = 0; i < channels.length; ++i) {
            newBlocks[i] = page.getBlock(channels[i]);
        }
        return new Page(page.getPositionCount(), newBlocks);
    }

    @Override
    public Page getOutput() {
        if (this.state == State.NEEDS_INPUT || this.state == State.FINISHED) {
            return null;
        }
        Page page = this.extractOutput();
        this.localUserMemoryContext.setBytes(this.pagesIndex.getEstimatedSize().toBytes());
        return page;
    }

    private Page extractOutput() {
        while (!this.pageBuilder.isFull()) {
            if (this.partition == null || !this.partition.hasNext()) {
                int partitionStart;
                int n = partitionStart = this.partition == null ? 0 : this.partition.getPartitionEnd();
                if (partitionStart >= this.pagesIndex.getPositionCount()) {
                    this.partition = null;
                    this.pagesIndex.clear();
                    if (this.pendingInput != null && this.processPendingInput()) {
                        partitionStart = 0;
                    } else {
                        if (this.state == State.FINISHING) {
                            this.state = State.FINISHED;
                            if (!this.pageBuilder.isEmpty()) {
                                Page page = this.pageBuilder.build();
                                this.pageBuilder.reset();
                                return page;
                            }
                            return null;
                        }
                        this.state = State.NEEDS_INPUT;
                        return null;
                    }
                }
                int partitionEnd = WindowOperator.findGroupEnd(this.pagesIndex, this.unGroupedPartitionHashStrategy, partitionStart);
                this.partition = new WindowPartition(this.pagesIndex, partitionStart, partitionEnd, this.outputChannels, this.windowFunctions, this.peerGroupHashStrategy);
                this.windowInfo.addPartition(this.partition);
            }
            this.partition.processNextRow(this.pageBuilder);
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    private void sortPagesIndexIfNecessary() {
        if (this.pagesIndex.getPositionCount() > 1 && !this.orderChannels.isEmpty()) {
            int startPosition = 0;
            while (startPosition < this.pagesIndex.getPositionCount()) {
                int endPosition = WindowOperator.findGroupEnd(this.pagesIndex, this.preSortedPartitionHashStrategy, startPosition);
                this.pagesIndex.sort(this.orderChannels, this.ordering, startPosition, endPosition);
                startPosition = endPosition;
            }
        }
    }

    private void finishPagesIndex() {
        this.sortPagesIndexIfNecessary();
        this.windowInfo.addIndex(this.pagesIndex);
    }

    private static int findGroupEnd(Page page, PagesHashStrategy pagesHashStrategy, int startPosition) {
        Preconditions.checkArgument((page.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Must have at least one position");
        Preconditions.checkPositionIndex((int)startPosition, (int)page.getPositionCount(), (String)"startPosition out of bounds");
        return WindowOperator.findEndPosition(startPosition, page.getPositionCount(), (firstPosition, secondPosition) -> pagesHashStrategy.rowEqualsRow((int)firstPosition, page, (int)secondPosition, page));
    }

    private static int findGroupEnd(PagesIndex pagesIndex, PagesHashStrategy pagesHashStrategy, int startPosition) {
        Preconditions.checkArgument((pagesIndex.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Must have at least one position");
        Preconditions.checkPositionIndex((int)startPosition, (int)pagesIndex.getPositionCount(), (String)"startPosition out of bounds");
        return WindowOperator.findEndPosition(startPosition, pagesIndex.getPositionCount(), (firstPosition, secondPosition) -> pagesIndex.positionEqualsPosition(pagesHashStrategy, (int)firstPosition, (int)secondPosition));
    }

    @VisibleForTesting
    static int findEndPosition(int startPosition, int endPosition, BiPredicate<Integer, Integer> comparator) {
        Preconditions.checkArgument((startPosition >= 0 ? 1 : 0) != 0, (String)"startPosition must be greater or equal than zero: %s", (int)startPosition);
        Preconditions.checkArgument((startPosition < endPosition ? 1 : 0) != 0, (String)"startPosition (%s) must be less than endPosition (%s)", (int)startPosition, (int)endPosition);
        int left = startPosition;
        int right = endPosition;
        while (left + 1 < right) {
            int middle = left + right >>> 1;
            if (comparator.test(startPosition, middle)) {
                left = middle;
                continue;
            }
            right = middle;
        }
        return right;
    }

    @Override
    public void close() {
        this.driverWindowInfo.set(Optional.of(this.windowInfo.build()));
    }

    private static enum State {
        NEEDS_INPUT,
        HAS_OUTPUT,
        FINISHING,
        FINISHED;

    }

    public static class WindowOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final List<Integer> outputChannels;
        private final List<WindowFunctionDefinition> windowFunctionDefinitions;
        private final List<Integer> partitionChannels;
        private final List<Integer> preGroupedChannels;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrder;
        private final int preSortedChannelPrefix;
        private final int expectedPositions;
        private boolean closed;
        private final PagesIndex.Factory pagesIndexFactory;

        public WindowOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> sourceTypes, List<Integer> outputChannels, List<WindowFunctionDefinition> windowFunctionDefinitions, List<Integer> partitionChannels, List<Integer> preGroupedChannels, List<Integer> sortChannels, List<SortOrder> sortOrder, int preSortedChannelPrefix, int expectedPositions, PagesIndex.Factory pagesIndexFactory) {
            Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            Objects.requireNonNull(planNodeId, "planNodeId is null");
            Objects.requireNonNull(outputChannels, "outputChannels is null");
            Objects.requireNonNull(windowFunctionDefinitions, "windowFunctionDefinitions is null");
            Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            Objects.requireNonNull(preGroupedChannels, "preGroupedChannels is null");
            Preconditions.checkArgument((boolean)partitionChannels.containsAll(preGroupedChannels), (Object)"preGroupedChannels must be a subset of partitionChannels");
            Objects.requireNonNull(sortChannels, "sortChannels is null");
            Objects.requireNonNull(sortOrder, "sortOrder is null");
            Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
            Preconditions.checkArgument((sortChannels.size() == sortOrder.size() ? 1 : 0) != 0, (Object)"Must have same number of sort channels as sort orders");
            Preconditions.checkArgument((preSortedChannelPrefix <= sortChannels.size() ? 1 : 0) != 0, (Object)"Cannot have more pre-sorted channels than specified sorted channels");
            Preconditions.checkArgument((preSortedChannelPrefix == 0 || ImmutableSet.copyOf(preGroupedChannels).equals((Object)ImmutableSet.copyOf(partitionChannels)) ? 1 : 0) != 0, (Object)"preSortedChannelPrefix can only be greater than zero if all partition channels are pre-grouped");
            this.pagesIndexFactory = pagesIndexFactory;
            this.operatorId = operatorId;
            this.planNodeId = planNodeId;
            this.sourceTypes = ImmutableList.copyOf(sourceTypes);
            this.outputChannels = ImmutableList.copyOf(outputChannels);
            this.windowFunctionDefinitions = ImmutableList.copyOf(windowFunctionDefinitions);
            this.partitionChannels = ImmutableList.copyOf(partitionChannels);
            this.preGroupedChannels = ImmutableList.copyOf(preGroupedChannels);
            this.sortChannels = ImmutableList.copyOf(sortChannels);
            this.sortOrder = ImmutableList.copyOf(sortOrder);
            this.preSortedChannelPrefix = preSortedChannelPrefix;
            this.expectedPositions = expectedPositions;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, WindowOperator.class.getSimpleName());
            return new WindowOperator(operatorContext, this.sourceTypes, this.outputChannels, this.windowFunctionDefinitions, this.partitionChannels, this.preGroupedChannels, this.sortChannels, this.sortOrder, this.preSortedChannelPrefix, this.expectedPositions, this.pagesIndexFactory);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new WindowOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.outputChannels, this.windowFunctionDefinitions, this.partitionChannels, this.preGroupedChannels, this.sortChannels, this.sortOrder, this.preSortedChannelPrefix, this.expectedPositions, this.pagesIndexFactory);
        }
    }
}

