/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.presto.operator.aggregation.ApproximateLongPercentileArrayAggregations;
import com.facebook.presto.operator.aggregation.FloatingPointBitsConverterUtil;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileArrayState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.DoubleType;
import java.util.List;

@AggregationFunction(value="approx_percentile")
public final class ApproximateDoublePercentileArrayAggregations {
    private ApproximateDoublePercentileArrayAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState DigestAndPercentileArrayState state, @SqlType(value="double") double value, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateLongPercentileArrayAggregations.input(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), percentilesArrayBlock);
    }

    @InputFunction
    public static void input(@AggregationState DigestAndPercentileArrayState state, @SqlType(value="double") double value, @SqlType(value="array(double)") Block percentilesArrayBlock, @SqlType(value="double") double accuracy) {
        ApproximateLongPercentileArrayAggregations.input(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), percentilesArrayBlock, accuracy);
    }

    @InputFunction
    public static void weightedInput(@AggregationState DigestAndPercentileArrayState state, @SqlType(value="double") double value, @SqlType(value="bigint") long weight, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateLongPercentileArrayAggregations.weightedInput(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), weight, percentilesArrayBlock);
    }

    @InputFunction
    public static void weightedInput(@AggregationState DigestAndPercentileArrayState state, @SqlType(value="double") double value, @SqlType(value="bigint") long weight, @SqlType(value="array(double)") Block percentilesArrayBlock, @SqlType(value="double") double accuracy) {
        ApproximateLongPercentileArrayAggregations.weightedInput(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), weight, percentilesArrayBlock, accuracy);
    }

    @CombineFunction
    public static void combine(@AggregationState DigestAndPercentileArrayState state, DigestAndPercentileArrayState otherState) {
        ApproximateLongPercentileArrayAggregations.combine(state, otherState);
    }

    @OutputFunction(value="array(double)")
    public static void output(@AggregationState DigestAndPercentileArrayState state, BlockBuilder out) {
        QuantileDigest digest = state.getDigest();
        List<Double> percentiles = state.getPercentiles();
        if (percentiles == null || digest == null) {
            out.appendNull();
            return;
        }
        BlockBuilder blockBuilder = out.beginBlockEntry();
        for (int i = 0; i < percentiles.size(); ++i) {
            Double percentile = percentiles.get(i);
            DoubleType.DOUBLE.writeDouble(blockBuilder, FloatingPointBitsConverterUtil.sortableLongToDouble(digest.getQuantile(percentile.doubleValue())));
        }
        out.closeEntry();
    }
}

