/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.presto.operator.aggregation.ApproximateLongPercentileAggregations;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileArrayState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.util.Failures;
import com.google.common.collect.ImmutableList;
import java.util.List;

@AggregationFunction(value="approx_percentile")
public final class ApproximateLongPercentileArrayAggregations {
    private ApproximateLongPercentileArrayAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState DigestAndPercentileArrayState state, @SqlType(value="bigint") long value, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateLongPercentileArrayAggregations.addInput(state, value, 1L, percentilesArrayBlock, 0.01);
    }

    @InputFunction
    public static void input(@AggregationState DigestAndPercentileArrayState state, @SqlType(value="bigint") long value, @SqlType(value="array(double)") Block percentilesArrayBlock, @SqlType(value="double") double accuracy) {
        ApproximateLongPercentileArrayAggregations.addInput(state, value, 1L, percentilesArrayBlock, accuracy);
    }

    @InputFunction
    public static void weightedInput(@AggregationState DigestAndPercentileArrayState state, @SqlType(value="bigint") long value, @SqlType(value="bigint") long weight, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateLongPercentileAggregations.checkWeight(weight);
        ApproximateLongPercentileArrayAggregations.addInput(state, value, weight, percentilesArrayBlock, 0.01);
    }

    @InputFunction
    public static void weightedInput(@AggregationState DigestAndPercentileArrayState state, @SqlType(value="bigint") long value, @SqlType(value="bigint") long weight, @SqlType(value="array(double)") Block percentilesArrayBlock, @SqlType(value="double") double accuracy) {
        ApproximateLongPercentileAggregations.checkWeight(weight);
        ApproximateLongPercentileArrayAggregations.addInput(state, value, weight, percentilesArrayBlock, accuracy);
    }

    private static void addInput(@AggregationState DigestAndPercentileArrayState state, @SqlType(value="bigint") long value, @SqlType(value="bigint") long weight, @SqlType(value="array(double)") Block percentilesArrayBlock, @SqlType(value="double") double accuracy) {
        ApproximateLongPercentileArrayAggregations.initializePercentilesArray(state, percentilesArrayBlock);
        QuantileDigest digest = state.getDigest();
        if (state.getDigest() == null) {
            ApproximateLongPercentileAggregations.checkAccuracy(accuracy);
            digest = new QuantileDigest(accuracy);
            state.setDigest(digest);
        } else {
            state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
        }
        digest.add(value, weight);
        state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
    }

    @CombineFunction
    public static void combine(@AggregationState DigestAndPercentileArrayState state, DigestAndPercentileArrayState otherState) {
        QuantileDigest otherDigest = otherState.getDigest();
        QuantileDigest digest = state.getDigest();
        if (digest == null) {
            state.setDigest(otherDigest);
            state.addMemoryUsage(otherDigest.estimatedInMemorySizeInBytes());
        } else {
            state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
            digest.merge(otherDigest);
            state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        }
        state.setPercentiles(otherState.getPercentiles());
    }

    @OutputFunction(value="array(bigint)")
    public static void output(@AggregationState DigestAndPercentileArrayState state, BlockBuilder out) {
        QuantileDigest digest = state.getDigest();
        List<Double> percentiles = state.getPercentiles();
        if (percentiles == null || digest == null) {
            out.appendNull();
            return;
        }
        BlockBuilder blockBuilder = out.beginBlockEntry();
        for (int i = 0; i < percentiles.size(); ++i) {
            Double percentile = percentiles.get(i);
            BigintType.BIGINT.writeLong(blockBuilder, digest.getQuantile(percentile.doubleValue()));
        }
        out.closeEntry();
    }

    private static void initializePercentilesArray(@AggregationState DigestAndPercentileArrayState state, Block percentilesArrayBlock) {
        if (state.getPercentiles() == null) {
            ImmutableList.Builder percentilesListBuilder = ImmutableList.builder();
            for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
                Failures.checkCondition(!percentilesArrayBlock.isNull(i), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile cannot be null", new Object[0]);
                double percentile = DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i);
                Failures.checkCondition(0.0 <= percentile && percentile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1", new Object[0]);
                percentilesListBuilder.add((Object)percentile);
            }
            state.setPercentiles((List<Double>)percentilesListBuilder.build());
        }
    }
}

