/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.state.CentralMomentsState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.DoubleType;

@AggregationFunction
@Description(value="Returns the central moments of the argument as an array")
public final class CentralMomentsAggregation {
    private CentralMomentsAggregation() {
    }

    @InputFunction
    public static void doubleInput(@AggregationState CentralMomentsState state, @SqlType(value="double") double value) {
        AggregationUtils.updateCentralMomentsState(state, value);
    }

    @InputFunction
    public static void bigintInput(@AggregationState CentralMomentsState state, @SqlType(value="bigint") long value) {
        AggregationUtils.updateCentralMomentsState(state, value);
    }

    @CombineFunction
    public static void combine(@AggregationState CentralMomentsState state, @AggregationState CentralMomentsState otherState) {
        AggregationUtils.mergeCentralMomentsState(state, otherState);
    }

    @AggregationFunction(value="skewness")
    @Description(value="Returns the skewness of the argument")
    @OutputFunction(value="double")
    public static void skewness(@AggregationState CentralMomentsState state, BlockBuilder out) {
        long n = state.getCount();
        if (n < 3L) {
            out.appendNull();
        } else {
            double result = Math.sqrt(n) * state.getM3() / Math.pow(state.getM2(), 1.5);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }

    @AggregationFunction(value="kurtosis")
    @Description(value="Returns the (excess) kurtosis of the argument")
    @OutputFunction(value="double")
    public static void kurtosis(@AggregationState CentralMomentsState state, BlockBuilder out) {
        double n = state.getCount();
        if (n < 4.0) {
            out.appendNull();
        } else {
            double m2 = state.getM2();
            double m4 = state.getM4();
            double result = (n - 1.0) * n * (n + 1.0) / ((n - 2.0) * (n - 3.0)) * m4 / (m2 * m2) - 3.0 * ((n - 1.0) * (n - 1.0)) / ((n - 2.0) * (n - 3.0));
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }
}

