/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowState;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowStateFactory;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowStateSerializer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.UnscaledDecimal128Arithmetic;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Set;

public class DecimalSumAggregation
extends SqlAggregationFunction {
    public static final DecimalSumAggregation DECIMAL_SUM_AGGREGATION = new DecimalSumAggregation();
    private static final String NAME = "sum";
    private static final MethodHandle SHORT_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "inputShortDecimal", Type.class, LongDecimalWithOverflowState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "inputLongDecimal", Type.class, LongDecimalWithOverflowState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_OUTPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "outputLongDecimal", DecimalType.class, LongDecimalWithOverflowState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "combine", LongDecimalWithOverflowState.class, LongDecimalWithOverflowState.class);

    public DecimalSumAggregation() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"decimal(38,s)", (Set)ImmutableSet.of((Object)"s")), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"decimal(p,s)", (Set)ImmutableSet.of((Object)"p", (Object)"s"))), FunctionKind.AGGREGATE);
    }

    public String getDescription() {
        return "Calculates the sum over the input values";
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionManager functionManager) {
        Type inputType = (Type)Iterables.getOnlyElement(SignatureBinder.applyBoundVariables(typeManager, this.getSignature().getArgumentTypes(), boundVariables));
        Type outputType = SignatureBinder.applyBoundVariables(typeManager, this.getSignature().getReturnType(), boundVariables);
        return DecimalSumAggregation.generateAggregation(inputType, outputType);
    }

    private static InternalAggregationFunction generateAggregation(Type inputType, Type outputType) {
        Preconditions.checkArgument((boolean)(inputType instanceof DecimalType), (Object)"type must be Decimal");
        DynamicClassLoader classLoader = new DynamicClassLoader(DecimalSumAggregation.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)inputType);
        Class<LongDecimalWithOverflowState> stateInterface = LongDecimalWithOverflowState.class;
        LongDecimalWithOverflowStateSerializer stateSerializer = new LongDecimalWithOverflowStateSerializer();
        MethodHandle inputFunction = ((DecimalType)inputType).isShort() ? SHORT_DECIMAL_INPUT_FUNCTION : LONG_DECIMAL_INPUT_FUNCTION;
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, outputType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), DecimalSumAggregation.createInputParameterMetadata(inputType), inputFunction.bindTo(inputType), COMBINE_FUNCTION, LONG_DECIMAL_OUTPUT_FUNCTION.bindTo(outputType), (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateInterface, stateSerializer, new LongDecimalWithOverflowStateFactory())), outputType);
        Type intermediateType = stateSerializer.getSerializedType();
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), outputType, true, false, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type type) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void inputShortDecimal(Type type, LongDecimalWithOverflowState state, Block block, int position) {
        DecimalSumAggregation.accumulateValueInState(UnscaledDecimal128Arithmetic.unscaledDecimal((long)type.getLong(block, position)), state);
    }

    public static void inputLongDecimal(Type type, LongDecimalWithOverflowState state, Block block, int position) {
        DecimalSumAggregation.accumulateValueInState(type.getSlice(block, position), state);
    }

    private static void accumulateValueInState(Slice unscaledDecimal, LongDecimalWithOverflowState state) {
        DecimalSumAggregation.initializeIfNeeded(state);
        Slice sum = state.getLongDecimal();
        long overflow = UnscaledDecimal128Arithmetic.addWithOverflow((Slice)sum, (Slice)unscaledDecimal, (Slice)sum);
        state.setOverflow(state.getOverflow() + overflow);
    }

    private static void initializeIfNeeded(LongDecimalWithOverflowState state) {
        if (state.getLongDecimal() == null) {
            state.setLongDecimal(UnscaledDecimal128Arithmetic.unscaledDecimal());
        }
    }

    public static void combine(LongDecimalWithOverflowState state, LongDecimalWithOverflowState otherState) {
        state.setOverflow(state.getOverflow() + otherState.getOverflow());
        if (state.getLongDecimal() == null) {
            state.setLongDecimal(otherState.getLongDecimal());
        } else {
            DecimalSumAggregation.accumulateValueInState(otherState.getLongDecimal(), state);
        }
    }

    public static void outputLongDecimal(DecimalType type, LongDecimalWithOverflowState state, BlockBuilder out) {
        if (state.getLongDecimal() == null) {
            out.appendNull();
        } else {
            if (state.getOverflow() != 0L) {
                UnscaledDecimal128Arithmetic.throwOverflowException();
            }
            UnscaledDecimal128Arithmetic.throwIfOverflows((Slice)state.getLongDecimal());
            type.writeSlice(out, state.getLongDecimal());
        }
    }
}

