/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.BigintOperators;
import com.facebook.presto.type.IntervalYearMonthType;

@AggregationFunction(value="sum")
public final class IntervalYearToMonthSumAggregation {
    private IntervalYearToMonthSumAggregation() {
    }

    @InputFunction
    public static void sum(NullableLongState state, @SqlType(value="interval year to month") long value) {
        state.setNull(false);
        state.setLong(BigintOperators.add(state.getLong(), value));
    }

    @CombineFunction
    public static void combine(NullableLongState state, NullableLongState otherState) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(otherState.getLong());
            return;
        }
        state.setLong(BigintOperators.add(state.getLong(), otherState.getLong()));
    }

    @OutputFunction(value="interval year to month")
    public static void output(NullableLongState state, BlockBuilder out) {
        NullableLongState.write((Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH, state, out);
    }
}

