/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.ParametricFunctionHelpers;
import com.facebook.presto.operator.ParametricImplementationsGroup;
import com.facebook.presto.operator.aggregation.AggregationHeader;
import com.facebook.presto.operator.aggregation.AggregationImplementation;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.LazyAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ParametricAggregation
extends SqlAggregationFunction {
    final AggregationHeader details;
    final ParametricImplementationsGroup<AggregationImplementation> implementations;

    public ParametricAggregation(Signature signature, AggregationHeader details, ParametricImplementationsGroup<AggregationImplementation> implementations) {
        super(signature, details.getVisibility());
        this.details = Objects.requireNonNull(details, "details is null");
        this.implementations = Objects.requireNonNull(implementations, "implementations is null");
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables variables, int arity, TypeManager typeManager, FunctionManager functionManager) {
        Signature boundSignature = SignatureBinder.applyBoundVariables(this.getSignature(), variables, arity);
        AggregationImplementation concreteImplementation = this.findMatchingImplementation(boundSignature, variables, typeManager, functionManager);
        List inputTypes = (List)boundSignature.getArgumentTypes().stream().map(arg_0 -> ((TypeManager)typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList());
        Type outputType = typeManager.getType(boundSignature.getReturnType());
        Class<?> definitionClass = concreteImplementation.getDefinitionClass();
        DynamicClassLoader classLoader = new DynamicClassLoader(definitionClass.getClassLoader(), this.getClass().getClassLoader());
        Class<?> stateClass = concreteImplementation.getStateClass();
        AccumulatorStateSerializer<?> stateSerializer = ParametricAggregation.getAccumulatorStateSerializer(concreteImplementation, variables, typeManager, functionManager, stateClass, classLoader);
        AccumulatorStateFactory<?> stateFactory = StateCompiler.generateStateFactory(stateClass, classLoader);
        MethodHandle inputHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getInputFunction(), concreteImplementation.getInputDependencies(), variables, typeManager, functionManager);
        MethodHandle combineHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getCombineFunction(), concreteImplementation.getCombineDependencies(), variables, typeManager, functionManager);
        MethodHandle outputHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getOutputFunction(), concreteImplementation.getOutputDependencies(), variables, typeManager, functionManager);
        List<AggregationMetadata.ParameterMetadata> parametersMetadata = ParametricAggregation.buildParameterMetadata(concreteImplementation.getInputParameterMetadataTypes(), inputTypes);
        String aggregationName = AggregationUtils.generateAggregationName(this.getSignature().getNameSuffix(), outputType.getTypeSignature(), ParametricAggregation.signaturesFromTypes(inputTypes));
        AggregationMetadata metadata = new AggregationMetadata(aggregationName, parametersMetadata, inputHandle, combineHandle, outputHandle, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateClass, stateSerializer, stateFactory)), outputType);
        return new InternalAggregationFunction(this.getSignature().getNameSuffix(), inputTypes, (List<Type>)ImmutableList.of((Object)stateSerializer.getSerializedType()), outputType, this.details.isDecomposable(), this.details.isOrderSensitive(), new LazyAccumulatorFactoryBinder(metadata, classLoader));
    }

    @VisibleForTesting
    public ParametricImplementationsGroup<AggregationImplementation> getImplementations() {
        return this.implementations;
    }

    public String getDescription() {
        return this.details.getDescription().orElse("");
    }

    private AggregationImplementation findMatchingImplementation(Signature boundSignature, BoundVariables variables, TypeManager typeManager, FunctionManager functionManager) {
        Optional<Object> foundImplementation = Optional.empty();
        if (this.implementations.getExactImplementations().containsKey(boundSignature)) {
            foundImplementation = Optional.of(this.implementations.getExactImplementations().get(boundSignature));
        } else {
            for (AggregationImplementation candidate : this.implementations.getGenericImplementations()) {
                if (!candidate.areTypesAssignable(boundSignature, variables, typeManager)) continue;
                if (foundImplementation.isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, String.format("Ambiguous function call (%s) for %s", variables, this.getSignature()));
                }
                foundImplementation = Optional.of(candidate);
            }
        }
        if (!foundImplementation.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("Unsupported type parameters (%s) for %s", variables, this.getSignature()));
        }
        return (AggregationImplementation)foundImplementation.get();
    }

    private static AccumulatorStateSerializer<?> getAccumulatorStateSerializer(AggregationImplementation implementation, BoundVariables variables, TypeManager typeManager, FunctionManager functionManager, Class<?> stateClass, DynamicClassLoader classLoader) {
        AccumulatorStateSerializer stateSerializer;
        Optional<MethodHandle> stateSerializerFactory = implementation.getStateSerializerFactory();
        if (stateSerializerFactory.isPresent()) {
            try {
                MethodHandle factoryHandle = ParametricFunctionHelpers.bindDependencies(stateSerializerFactory.get(), implementation.getStateSerializerFactoryDependencies(), variables, typeManager, functionManager);
                stateSerializer = factoryHandle.invoke();
            }
            catch (Throwable t) {
                Throwables.throwIfUnchecked((Throwable)t);
                throw new RuntimeException(t);
            }
        } else {
            stateSerializer = StateCompiler.generateStateSerializer(stateClass, classLoader);
        }
        return stateSerializer;
    }

    public InternalAggregationFunction specialize(BoundVariables variables, int arity, TypeManager typeManager) {
        return this.specialize(variables, arity, typeManager, null);
    }

    private static List<TypeSignature> signaturesFromTypes(List<Type> types) {
        return (List)types.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList());
    }

    private static List<AggregationMetadata.ParameterMetadata> buildParameterMetadata(List<AggregationMetadata.ParameterMetadata.ParameterType> parameterMetadataTypes, List<Type> inputTypes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int inputId = 0;
        for (AggregationMetadata.ParameterMetadata.ParameterType parameterMetadataType : parameterMetadataTypes) {
            switch (parameterMetadataType) {
                case STATE: 
                case BLOCK_INDEX: {
                    builder.add((Object)new AggregationMetadata.ParameterMetadata(parameterMetadataType));
                    break;
                }
                case INPUT_CHANNEL: 
                case BLOCK_INPUT_CHANNEL: 
                case NULLABLE_BLOCK_INPUT_CHANNEL: {
                    builder.add((Object)new AggregationMetadata.ParameterMetadata(parameterMetadataType, inputTypes.get(inputId++)));
                }
            }
        }
        return builder.build();
    }
}

