/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.operator.aggregation.differentialentropy.DifferentialEntropyState;
import com.facebook.presto.operator.aggregation.differentialentropy.DifferentialEntropyStateStrategy;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.DoubleType;
import io.airlift.slice.Slice;
import java.util.Locale;

@AggregationFunction(value="differential_entropy")
@Description(value="Computes differential entropy based on random-variable samples")
public final class DifferentialEntropyAggregation {
    private DifferentialEntropyAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState DifferentialEntropyState state, @SqlType(value="bigint") long size, @SqlType(value="double") double sample, @SqlType(value="double") double weight, @SqlType(value="varchar") Slice method, @SqlType(value="double") double min, @SqlType(value="double") double max) {
        DifferentialEntropyStateStrategy strategy = DifferentialEntropyStateStrategy.getStrategy(state.getStrategy(), size, sample, weight, method.toStringUtf8().toLowerCase(Locale.ENGLISH), min, max);
        state.setStrategy(strategy);
        strategy.add(sample, weight);
    }

    @InputFunction
    public static void input(@AggregationState DifferentialEntropyState state, @SqlType(value="bigint") long size, @SqlType(value="double") double sample, @SqlType(value="double") double weight) {
        DifferentialEntropyStateStrategy strategy = DifferentialEntropyStateStrategy.getStrategy(state.getStrategy(), size, sample, weight);
        state.setStrategy(strategy);
        strategy.add(sample, weight);
    }

    @InputFunction
    public static void input(@AggregationState DifferentialEntropyState state, @SqlType(value="bigint") long size, @SqlType(value="double") double sample) {
        DifferentialEntropyStateStrategy strategy = DifferentialEntropyStateStrategy.getStrategy(state.getStrategy(), size, sample);
        state.setStrategy(strategy);
        strategy.add(sample);
    }

    @CombineFunction
    public static void combine(@AggregationState DifferentialEntropyState state, @AggregationState DifferentialEntropyState otherState) {
        DifferentialEntropyStateStrategy strategy = state.getStrategy();
        DifferentialEntropyStateStrategy otherStrategy = otherState.getStrategy();
        if (strategy == null && otherStrategy != null) {
            state.setStrategy(otherStrategy);
            return;
        }
        if (otherStrategy == null) {
            return;
        }
        DifferentialEntropyStateStrategy.combine(strategy, otherStrategy);
    }

    @OutputFunction(value="double")
    public static void output(@AggregationState DifferentialEntropyState state, BlockBuilder out) {
        DifferentialEntropyStateStrategy strategy = state.getStrategy();
        DoubleType.DOUBLE.writeDouble(out, strategy == null ? Double.NaN : strategy.calculateEntropy());
    }
}

