/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.multimapagg;

import com.facebook.presto.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggregationState;
import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggregationStateConsumer;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import org.openjdk.jol.info.ClassLayout;

@Deprecated
public class LegacyGroupedMultimapAggregationState
extends AbstractGroupedAccumulatorState
implements MultimapAggregationState {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LegacyGroupedMultimapAggregationState.class).instanceSize();
    private static final int EXPECTED_ENTRIES = 10;
    private static final int EXPECTED_ENTRY_SIZE = 16;
    private final Type keyType;
    private final Type valueType;
    private final ObjectBigArray<BlockBuilder> keyBlockBuilders = new ObjectBigArray();
    private final ObjectBigArray<BlockBuilder> valueBlockBuilders = new ObjectBigArray();
    private long size;

    public LegacyGroupedMultimapAggregationState(Type keyType, Type valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public void ensureCapacity(long size) {
        this.keyBlockBuilders.ensureCapacity(size);
        this.valueBlockBuilders.ensureCapacity(size);
    }

    @Override
    public void add(Block key, Block value, int position) {
        BlockBuilder keyBlockBuilder = (BlockBuilder)this.keyBlockBuilders.get(this.getGroupId());
        BlockBuilder valueBlockBuilder = (BlockBuilder)this.valueBlockBuilders.get(this.getGroupId());
        if (keyBlockBuilder != null) {
            this.size -= keyBlockBuilder.getRetainedSizeInBytes();
            this.size -= valueBlockBuilder.getRetainedSizeInBytes();
        } else {
            keyBlockBuilder = this.keyType.createBlockBuilder(null, 10, TypeUtils.expectedValueSize(this.keyType, 16));
            valueBlockBuilder = this.valueType.createBlockBuilder(null, 10, TypeUtils.expectedValueSize(this.valueType, 16));
            this.keyBlockBuilders.set(this.getGroupId(), (Object)keyBlockBuilder);
            this.valueBlockBuilders.set(this.getGroupId(), (Object)valueBlockBuilder);
        }
        this.keyType.appendTo(key, position, keyBlockBuilder);
        this.valueType.appendTo(value, position, valueBlockBuilder);
        this.size += keyBlockBuilder.getRetainedSizeInBytes();
        this.size += valueBlockBuilder.getRetainedSizeInBytes();
    }

    @Override
    public void forEach(MultimapAggregationStateConsumer consumer) {
        BlockBuilder keyBlockBuilder = (BlockBuilder)this.keyBlockBuilders.get(this.getGroupId());
        BlockBuilder valueBlockBuilder = (BlockBuilder)this.valueBlockBuilders.get(this.getGroupId());
        if (keyBlockBuilder == null) {
            return;
        }
        for (int i = 0; i < keyBlockBuilder.getPositionCount(); ++i) {
            consumer.accept((Block)keyBlockBuilder, (Block)valueBlockBuilder, i);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.keyBlockBuilders.get(this.getGroupId()) == null;
    }

    @Override
    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.keyBlockBuilders.sizeOf() + this.valueBlockBuilders.sizeOf() + this.size;
    }

    @Override
    public int getEntryCount() {
        return ((BlockBuilder)this.keyBlockBuilders.get(this.getGroupId())).getPositionCount();
    }
}

