/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.multimapagg;

import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggregationState;
import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggregationStateConsumer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class SingleMultimapAggregationState
implements MultimapAggregationState {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleMultimapAggregationState.class).instanceSize();
    private static final int EXPECTED_ENTRIES = 10;
    private static final int EXPECTED_ENTRY_SIZE = 16;
    private final Type keyType;
    private final Type valueType;
    private BlockBuilder keyBlockBuilder;
    private BlockBuilder valueBlockBuilder;

    public SingleMultimapAggregationState(Type keyType, Type valueType) {
        this.keyType = Objects.requireNonNull(keyType);
        this.valueType = Objects.requireNonNull(valueType);
        this.keyBlockBuilder = keyType.createBlockBuilder(null, 10, TypeUtils.expectedValueSize(keyType, 16));
        this.valueBlockBuilder = valueType.createBlockBuilder(null, 10, TypeUtils.expectedValueSize(valueType, 16));
    }

    @Override
    public void add(Block key, Block value, int position) {
        this.keyType.appendTo(key, position, this.keyBlockBuilder);
        this.valueType.appendTo(value, position, this.valueBlockBuilder);
    }

    @Override
    public void forEach(MultimapAggregationStateConsumer consumer) {
        for (int i = 0; i < this.keyBlockBuilder.getPositionCount(); ++i) {
            consumer.accept((Block)this.keyBlockBuilder, (Block)this.valueBlockBuilder, i);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.keyBlockBuilder.getPositionCount() == 0;
    }

    @Override
    public int getEntryCount() {
        return this.keyBlockBuilder.getPositionCount();
    }

    @Override
    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.keyBlockBuilder.getRetainedSizeInBytes() + this.valueBlockBuilder.getRetainedSizeInBytes();
    }

    @Override
    public void reset() {
        this.keyBlockBuilder = this.keyBlockBuilder.newBlockBuilderLike(null);
        this.valueBlockBuilder = this.valueBlockBuilder.newBlockBuilderLike(null);
    }
}

