/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.index.IndexedData;
import com.facebook.presto.operator.index.PageBuffer;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class StreamingIndexedData
implements IndexedData {
    private final List<Type> outputTypes;
    private final List<Type> indexKeyTypes;
    private final Page indexKeyTuple;
    private final PageBuffer pageBuffer;
    private final Driver driver;
    private boolean started;
    private Page currentPage;

    public StreamingIndexedData(List<Type> outputTypes, List<Type> indexKeyTypes, Page indexKeyTuple, PageBuffer pageBuffer, Driver driver) {
        this.outputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputTypes, "outputTypes is null"));
        this.indexKeyTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(indexKeyTypes, "indexKeyTypes is null"));
        this.indexKeyTuple = Objects.requireNonNull(indexKeyTuple, "indexKeyTuple is null");
        Preconditions.checkArgument((indexKeyTuple.getPositionCount() == 1 ? 1 : 0) != 0, (Object)"indexKeyTuple Page should only have one position");
        Preconditions.checkArgument((indexKeyTypes.size() == indexKeyTuple.getChannelCount() ? 1 : 0) != 0, (Object)"indexKeyTypes doesn't match indexKeyTuple columns");
        this.pageBuffer = Objects.requireNonNull(pageBuffer, "pageBuffer is null");
        this.driver = Objects.requireNonNull(driver, "driver is null");
    }

    @Override
    public long getJoinPosition(int position, Page page) {
        Preconditions.checkArgument((page.getChannelCount() == this.indexKeyTypes.size() ? 1 : 0) != 0, (Object)"Number of blocks does not match the number of key columns");
        if (this.started || !this.matchesExpectedKey(position, page)) {
            return -2L;
        }
        this.started = true;
        if (!this.loadNextPage()) {
            return -1L;
        }
        return 0L;
    }

    private boolean matchesExpectedKey(int position, Page page) {
        for (int i = 0; i < this.indexKeyTypes.size(); ++i) {
            if (this.indexKeyTypes.get(i).equalTo(page.getBlock(i), position, this.indexKeyTuple.getBlock(i), 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getNextJoinPosition(long currentPosition) {
        Preconditions.checkState((this.currentPage != null ? 1 : 0) != 0, (Object)"getJoinPosition not called first");
        long nextPosition = currentPosition + 1L;
        if (nextPosition >= (long)this.currentPage.getPositionCount()) {
            if (!this.loadNextPage()) {
                return -1L;
            }
            nextPosition = 0L;
        }
        return nextPosition;
    }

    private boolean loadNextPage() {
        Page nextPage = StreamingIndexedData.extractNonEmptyPage(this.pageBuffer);
        while (nextPage == null) {
            if (this.driver.isFinished()) {
                return false;
            }
            this.driver.process();
            nextPage = StreamingIndexedData.extractNonEmptyPage(this.pageBuffer);
        }
        this.currentPage = nextPage;
        return true;
    }

    private static Page extractNonEmptyPage(PageBuffer pageBuffer) {
        Page page = pageBuffer.poll();
        while (page != null && page.getPositionCount() == 0) {
            page = pageBuffer.poll();
        }
        return page;
    }

    @Override
    public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
        Preconditions.checkState((this.currentPage != null ? 1 : 0) != 0, (Object)"getJoinPosition not called first");
        int intPosition = Math.toIntExact(position);
        for (int i = 0; i < this.outputTypes.size(); ++i) {
            Type type = this.outputTypes.get(i);
            Block block = this.currentPage.getBlock(i);
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i + outputChannelOffset);
            type.appendTo(block, intPosition, blockBuilder);
        }
    }

    @Override
    public void close() {
        this.driver.close();
        this.currentPage = null;
    }
}

