/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.operator.CompletedWork;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.DictionaryId;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class DictionaryAwarePageProjection
implements PageProjection {
    private final PageProjection projection;
    private final Function<DictionaryBlock, DictionaryId> sourceIdFunction;
    private Block lastInputDictionary;
    private Optional<Block> lastOutputDictionary;
    private long lastDictionaryUsageCount;

    public DictionaryAwarePageProjection(PageProjection projection, Function<DictionaryBlock, DictionaryId> sourceIdFunction) {
        this.projection = Objects.requireNonNull(projection, "projection is null");
        this.sourceIdFunction = sourceIdFunction;
        Verify.verify((boolean)projection.isDeterministic(), (String)"projection must be deterministic", (Object[])new Object[0]);
        Verify.verify((projection.getInputChannels().size() == 1 ? 1 : 0) != 0, (String)"projection must have only one input", (Object[])new Object[0]);
    }

    @Override
    public Type getType() {
        return this.projection.getType();
    }

    @Override
    public boolean isDeterministic() {
        return this.projection.isDeterministic();
    }

    @Override
    public InputChannels getInputChannels() {
        return this.projection.getInputChannels();
    }

    @Override
    public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
        return new DictionaryAwarePageProjectionWork(session, yieldSignal, page, selectedPositions);
    }

    private static int[] filterDictionaryIds(DictionaryBlock dictionaryBlock, SelectedPositions selectedPositions) {
        int[] outputIds = new int[selectedPositions.size()];
        if (selectedPositions.isList()) {
            int[] positions = selectedPositions.getPositions();
            int endPosition = selectedPositions.getOffset() + selectedPositions.size();
            int outputIndex = 0;
            for (int position = selectedPositions.getOffset(); position < endPosition; ++position) {
                outputIds[outputIndex++] = dictionaryBlock.getId(positions[position]);
            }
        } else {
            int endPosition = selectedPositions.getOffset() + selectedPositions.size();
            int outputIndex = 0;
            for (int position = selectedPositions.getOffset(); position < endPosition; ++position) {
                outputIds[outputIndex++] = dictionaryBlock.getId(position);
            }
        }
        return outputIds;
    }

    private class DictionaryAwarePageProjectionWork
    implements Work<Block> {
        private final ConnectorSession session;
        private final DriverYieldSignal yieldSignal;
        private final Block block;
        private final SelectedPositions selectedPositions;
        private Block result;
        private Work<Block> dictionaryProcessingProjectionWork;
        private Work<Block> fallbackProcessingProjectionWork;

        public DictionaryAwarePageProjectionWork(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            Block block;
            this.session = session;
            this.yieldSignal = Objects.requireNonNull(yieldSignal, "yieldSignal is null");
            this.block = block = Objects.requireNonNull(page, "page is null").getBlock(0).getLoadedBlock();
            this.selectedPositions = Objects.requireNonNull(selectedPositions, "selectedPositions is null");
            Optional<Block> dictionary = Optional.empty();
            if (block instanceof RunLengthEncodedBlock) {
                dictionary = Optional.of(((RunLengthEncodedBlock)block).getValue());
            } else if (block instanceof DictionaryBlock) {
                dictionary = Optional.of(((DictionaryBlock)block).getDictionary());
            }
            this.dictionaryProcessingProjectionWork = this.createDictionaryBlockProjection(dictionary);
            this.fallbackProcessingProjectionWork = null;
        }

        @Override
        public boolean process() {
            Preconditions.checkState((this.result == null ? 1 : 0) != 0, (Object)"result has been generated");
            if (this.fallbackProcessingProjectionWork != null) {
                if (this.fallbackProcessingProjectionWork.process()) {
                    this.result = this.fallbackProcessingProjectionWork.getResult();
                    return true;
                }
                return false;
            }
            Optional<Object> dictionaryOutput = Optional.empty();
            if (this.dictionaryProcessingProjectionWork != null) {
                try {
                    if (!this.dictionaryProcessingProjectionWork.process()) {
                        return false;
                    }
                    dictionaryOutput = Optional.of(this.dictionaryProcessingProjectionWork.getResult());
                    DictionaryAwarePageProjection.this.lastOutputDictionary = dictionaryOutput;
                }
                catch (Exception ignored) {
                    DictionaryAwarePageProjection.this.lastOutputDictionary = Optional.empty();
                    this.dictionaryProcessingProjectionWork = null;
                }
            }
            if (this.block instanceof DictionaryBlock) {
                DictionaryAwarePageProjection.this.lastDictionaryUsageCount = DictionaryAwarePageProjection.this.lastDictionaryUsageCount + (long)this.selectedPositions.size();
            }
            if (dictionaryOutput.isPresent()) {
                if (this.block instanceof RunLengthEncodedBlock) {
                    this.result = new RunLengthEncodedBlock((Block)dictionaryOutput.get(), this.selectedPositions.size());
                    return true;
                }
                if (this.block instanceof DictionaryBlock) {
                    DictionaryBlock dictionaryBlock = (DictionaryBlock)this.block;
                    int[] outputIds = DictionaryAwarePageProjection.filterDictionaryIds(dictionaryBlock, this.selectedPositions);
                    this.result = new DictionaryBlock(this.selectedPositions.size(), (Block)dictionaryOutput.get(), outputIds, false, (DictionaryId)DictionaryAwarePageProjection.this.sourceIdFunction.apply(dictionaryBlock));
                    return true;
                }
                throw new UnsupportedOperationException("unexpected block type " + this.block.getClass());
            }
            Verify.verify((this.dictionaryProcessingProjectionWork == null ? 1 : 0) != 0);
            Verify.verify((this.fallbackProcessingProjectionWork == null ? 1 : 0) != 0);
            this.fallbackProcessingProjectionWork = DictionaryAwarePageProjection.this.projection.project(this.session, this.yieldSignal, new Page(new Block[]{this.block}), this.selectedPositions);
            if (this.fallbackProcessingProjectionWork.process()) {
                this.result = this.fallbackProcessingProjectionWork.getResult();
                return true;
            }
            return false;
        }

        @Override
        public Block getResult() {
            Preconditions.checkState((this.result != null ? 1 : 0) != 0, (Object)"result has not been generated");
            return this.result;
        }

        private Work<Block> createDictionaryBlockProjection(Optional<Block> dictionary) {
            if (!dictionary.isPresent()) {
                DictionaryAwarePageProjection.this.lastOutputDictionary = Optional.empty();
                return null;
            }
            if (DictionaryAwarePageProjection.this.lastInputDictionary == dictionary.get()) {
                return DictionaryAwarePageProjection.this.lastOutputDictionary.map(CompletedWork::new).orElse(null);
            }
            boolean shouldProcessDictionary = dictionary.get().getPositionCount() == 1 || DictionaryAwarePageProjection.this.lastInputDictionary == null || DictionaryAwarePageProjection.this.lastDictionaryUsageCount >= (long)DictionaryAwarePageProjection.this.lastInputDictionary.getPositionCount();
            DictionaryAwarePageProjection.this.lastDictionaryUsageCount = 0L;
            DictionaryAwarePageProjection.this.lastInputDictionary = dictionary.get();
            DictionaryAwarePageProjection.this.lastOutputDictionary = Optional.empty();
            if (shouldProcessDictionary) {
                return DictionaryAwarePageProjection.this.projection.project(this.session, this.yieldSignal, new Page(new Block[]{DictionaryAwarePageProjection.this.lastInputDictionary}), SelectedPositions.positionsRange(0, DictionaryAwarePageProjection.this.lastInputDictionary.getPositionCount()));
            }
            return null;
        }
    }
}

