/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.operator.UncheckedByteArrays;
import com.facebook.presto.operator.repartition.AbstractBlockEncodingBuffer;
import com.facebook.presto.spi.block.ArrayAllocator;
import com.google.common.annotations.VisibleForTesting;
import io.airlift.slice.SliceOutput;
import org.openjdk.jol.info.ClassLayout;
import sun.misc.Unsafe;

public class IntArrayBlockEncodingBuffer
extends AbstractBlockEncodingBuffer {
    @VisibleForTesting
    static final int POSITION_SIZE = 5;
    private static final String NAME = "INT_ARRAY";
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(IntArrayBlockEncodingBuffer.class).instanceSize();
    private byte[] valuesBuffer;
    private int valuesBufferIndex;

    public IntArrayBlockEncodingBuffer(ArrayAllocator bufferAllocator, boolean isNested) {
        super(bufferAllocator, isNested);
    }

    @Override
    public void accumulateSerializedRowSizes(int[] serializedRowSizes) {
        throw new UnsupportedOperationException("accumulateSerializedRowSizes is not supported for fixed width types");
    }

    @Override
    public void appendDataInBatch() {
        if (this.batchSize == 0) {
            return;
        }
        this.appendValuesToBuffer();
        this.appendNulls();
        this.bufferedPositionCount += this.batchSize;
    }

    @Override
    public void serializeTo(SliceOutput output) {
        IntArrayBlockEncodingBuffer.writeLengthPrefixedString(output, NAME);
        output.writeInt(this.bufferedPositionCount);
        this.serializeNullsTo(output);
        if (this.valuesBufferIndex > 0) {
            output.appendBytes(this.valuesBuffer, 0, this.valuesBufferIndex);
        }
    }

    @Override
    public void resetBuffers() {
        this.bufferedPositionCount = 0;
        this.valuesBufferIndex = 0;
        this.flushed = true;
        this.resetNullsBuffer();
    }

    @Override
    public void noMoreBatches() {
        super.noMoreBatches();
        if (this.flushed && this.valuesBuffer != null) {
            this.bufferAllocator.returnArray(this.valuesBuffer);
            this.valuesBuffer = null;
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    @Override
    public long getSerializedSizeInBytes() {
        return (long)(NAME.length() + 4 + 4) + this.getNullsBufferSerializedSizeInBytes() + (long)this.valuesBufferIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        sb.append("valuesBufferCapacity=").append(this.valuesBuffer == null ? 0 : this.valuesBuffer.length).append(",");
        sb.append("valuesBufferIndex=").append(this.valuesBufferIndex).append("}");
        return sb.toString();
    }

    @Override
    protected void accumulateSerializedRowSizes(int[] positionOffsets, int positionCount, int[] serializedRowSizes) {
        for (int i = 0; i < positionCount; ++i) {
            int n = i;
            serializedRowSizes[n] = serializedRowSizes[n] + (positionOffsets[i + 1] - positionOffsets[i]) * 5;
        }
    }

    private void appendValuesToBuffer() {
        this.valuesBuffer = Arrays.ensureCapacity((byte[])this.valuesBuffer, (int)(this.valuesBufferIndex + this.batchSize * Unsafe.ARRAY_INT_INDEX_SCALE), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.LARGE, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE, (ArrayAllocator)this.bufferAllocator);
        int[] positions = this.getPositions();
        if (this.decodedBlock.mayHaveNull()) {
            for (int i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
                int position = positions[i];
                int value = this.decodedBlock.getInt(position);
                int newIndex = UncheckedByteArrays.setIntUnchecked(this.valuesBuffer, this.valuesBufferIndex, value);
                if (this.decodedBlock.isNull(position)) continue;
                this.valuesBufferIndex = newIndex;
            }
        } else {
            for (int i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
                int value = this.decodedBlock.getInt(positions[i]);
                this.valuesBufferIndex = UncheckedByteArrays.setIntUnchecked(this.valuesBuffer, this.valuesBufferIndex, value);
            }
        }
    }
}

