/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.operator.UncheckedByteArrays;
import com.facebook.presto.operator.repartition.AbstractBlockEncodingBuffer;
import com.facebook.presto.operator.repartition.BlockEncodingBuffer;
import com.facebook.presto.operator.repartition.DecodedBlockNode;
import com.facebook.presto.spi.block.ArrayAllocator;
import com.facebook.presto.spi.block.ColumnarRow;
import com.google.common.annotations.VisibleForTesting;
import io.airlift.slice.SliceOutput;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;
import sun.misc.Unsafe;

public class RowBlockEncodingBuffer
extends AbstractBlockEncodingBuffer {
    @VisibleForTesting
    static final int POSITION_SIZE = 5;
    private static final String NAME = "ROW";
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RowBlockEncodingBuffer.class).instanceSize();
    private byte[] offsetsBuffer;
    private int offsetsBufferIndex;
    private int[] offsets;
    private int lastOffset;
    private final BlockEncodingBuffer[] fieldBuffers;

    public RowBlockEncodingBuffer(DecodedBlockNode decodedBlockNode, ArrayAllocator bufferAllocator, boolean isNested) {
        super(bufferAllocator, isNested);
        List<DecodedBlockNode> childrenNodes = decodedBlockNode.getChildren();
        this.fieldBuffers = new AbstractBlockEncodingBuffer[childrenNodes.size()];
        for (int i = 0; i < childrenNodes.size(); ++i) {
            this.fieldBuffers[i] = RowBlockEncodingBuffer.createBlockEncodingBuffers(decodedBlockNode.getChildren().get(i), bufferAllocator, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accumulateSerializedRowSizes(int[] serializedRowSizes) {
        int i = 0;
        while (i < this.positionCount) {
            int n = i++;
            serializedRowSizes[n] = serializedRowSizes[n] + 5;
        }
        int[] offsetsCopy = Arrays.ensureCapacity((int[])null, (int)(this.positionCount + 1), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.NONE, (ArrayAllocator)this.bufferAllocator);
        try {
            for (int i2 = 0; i2 < this.fieldBuffers.length; ++i2) {
                System.arraycopy(this.offsets, 0, offsetsCopy, 0, this.positionCount + 1);
                ((AbstractBlockEncodingBuffer)this.fieldBuffers[i2]).accumulateSerializedRowSizes(offsetsCopy, this.positionCount, serializedRowSizes);
            }
        }
        finally {
            this.bufferAllocator.returnArray(offsetsCopy);
        }
    }

    @Override
    public void setNextBatch(int positionsOffset, int batchSize) {
        this.positionsOffset = positionsOffset;
        this.batchSize = batchSize;
        this.flushed = false;
        if (this.positionCount == 0) {
            return;
        }
        int offset = this.offsets[positionsOffset];
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            this.fieldBuffers[i].setNextBatch(offset, this.offsets[positionsOffset + batchSize] - offset);
        }
    }

    @Override
    public void appendDataInBatch() {
        if (this.batchSize == 0) {
            return;
        }
        this.appendNulls();
        this.appendOffsets();
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            this.fieldBuffers[i].appendDataInBatch();
        }
        this.bufferedPositionCount += this.batchSize;
    }

    @Override
    public void serializeTo(SliceOutput output) {
        RowBlockEncodingBuffer.writeLengthPrefixedString(output, NAME);
        output.writeInt(this.fieldBuffers.length);
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            this.fieldBuffers[i].serializeTo(output);
        }
        output.writeInt(this.bufferedPositionCount);
        output.writeInt(0);
        if (this.offsetsBufferIndex > 0) {
            output.appendBytes(this.offsetsBuffer, 0, this.offsetsBufferIndex);
        }
        this.serializeNullsTo(output);
    }

    @Override
    public void resetBuffers() {
        this.bufferedPositionCount = 0;
        this.offsetsBufferIndex = 0;
        this.lastOffset = 0;
        this.flushed = true;
        this.resetNullsBuffer();
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            this.fieldBuffers[i].resetBuffers();
        }
    }

    @Override
    public void noMoreBatches() {
        for (int i = this.fieldBuffers.length - 1; i >= 0; --i) {
            this.fieldBuffers[i].noMoreBatches();
        }
        if (this.flushed && this.offsetsBuffer != null) {
            this.bufferAllocator.returnArray(this.offsetsBuffer);
            this.offsetsBuffer = null;
        }
        super.noMoreBatches();
        if (this.offsets != null) {
            this.bufferAllocator.returnArray(this.offsets);
            this.offsets = null;
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        int size = INSTANCE_SIZE;
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            size = (int)((long)size + this.fieldBuffers[i].getRetainedSizeInBytes());
        }
        return size;
    }

    @Override
    public long getSerializedSizeInBytes() {
        int size = 0;
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            size = (int)((long)size + this.fieldBuffers[i].getSerializedSizeInBytes());
        }
        return (long)(NAME.length() + 4 + 4 + size + 4 + 4 + this.offsetsBufferIndex) + this.getNullsBufferSerializedSizeInBytes();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        sb.append("offsetsBufferCapacity=").append(this.offsetsBuffer == null ? 0 : this.offsetsBuffer.length).append(",");
        sb.append("offsetsBufferIndex=").append(this.offsetsBufferIndex).append(",");
        sb.append("offsetsCapacity=").append(this.offsets == null ? 0 : this.offsets.length).append(",");
        sb.append("lastOffset=").append(this.lastOffset).append(",");
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            sb.append("fieldBuffer_").append(i).append("=").append(this.fieldBuffers[i].toString()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    protected void setupDecodedBlockAndMapPositions(DecodedBlockNode decodedBlockNode) {
        Objects.requireNonNull(decodedBlockNode, "decodedBlockNode is null");
        decodedBlockNode = this.mapPositionsToNestedBlock(decodedBlockNode);
        ColumnarRow columnarRow = (ColumnarRow)decodedBlockNode.getDecodedBlock();
        this.decodedBlock = columnarRow.getNullCheckBlock();
        this.populateNestedPositions(columnarRow);
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            ((AbstractBlockEncodingBuffer)this.fieldBuffers[i]).setupDecodedBlockAndMapPositions(decodedBlockNode.getChildren().get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void accumulateSerializedRowSizes(int[] positionOffsets, int positionCount, int[] serializedRowSizes) {
        if (this.positionCount == 0) {
            return;
        }
        int lastOffset = positionOffsets[0];
        for (int i = 0; i < positionCount; ++i) {
            int offset = positionOffsets[i + 1];
            int n = i;
            serializedRowSizes[n] = serializedRowSizes[n] + 5 * (offset - lastOffset);
            lastOffset = offset;
            positionOffsets[i + 1] = this.offsets[offset];
        }
        int[] offsetsCopy = Arrays.ensureCapacity((int[])null, (int)(positionCount + 1), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.NONE, (ArrayAllocator)this.bufferAllocator);
        try {
            for (int i = 0; i < this.fieldBuffers.length; ++i) {
                System.arraycopy(positionOffsets, 0, offsetsCopy, 0, positionCount + 1);
                ((AbstractBlockEncodingBuffer)this.fieldBuffers[i]).accumulateSerializedRowSizes(offsetsCopy, positionCount, serializedRowSizes);
            }
        }
        finally {
            this.bufferAllocator.returnArray(offsetsCopy);
        }
    }

    private void populateNestedPositions(ColumnarRow columnarRow) {
        for (int i = 0; i < this.fieldBuffers.length; ++i) {
            ((AbstractBlockEncodingBuffer)this.fieldBuffers[i]).resetPositions();
        }
        if (this.positionCount == 0) {
            return;
        }
        this.offsets = Arrays.ensureCapacity((int[])this.offsets, (int)(this.positionCount + 1), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.NONE, (ArrayAllocator)this.bufferAllocator);
        this.offsets[0] = 0;
        int[] positions = this.getPositions();
        int columnarRowBaseOffset = columnarRow.getOffset(0);
        for (int i = 0; i < this.positionCount; ++i) {
            int position = positions[i];
            int beginOffset = columnarRow.getOffset(position);
            int endOffset = columnarRow.getOffset(position + 1);
            int currentRowSize = endOffset - beginOffset;
            this.offsets[i + 1] = this.offsets[i] + currentRowSize;
            if (currentRowSize <= 0) continue;
            for (int j = 0; j < this.fieldBuffers.length; ++j) {
                ((AbstractBlockEncodingBuffer)this.fieldBuffers[j]).appendPositionRange(beginOffset - columnarRowBaseOffset, currentRowSize);
            }
        }
    }

    private void appendOffsets() {
        this.offsetsBuffer = Arrays.ensureCapacity((byte[])this.offsetsBuffer, (int)(this.offsetsBufferIndex + this.batchSize * Unsafe.ARRAY_INT_INDEX_SCALE), (Arrays.ExpansionFactor)Arrays.ExpansionFactor.LARGE, (Arrays.ExpansionOption)Arrays.ExpansionOption.PRESERVE, (ArrayAllocator)this.bufferAllocator);
        int baseOffset = this.lastOffset - this.offsets[this.positionsOffset];
        for (int i = this.positionsOffset; i < this.positionsOffset + this.batchSize; ++i) {
            this.offsetsBufferIndex = UncheckedByteArrays.setIntUnchecked(this.offsetsBuffer, this.offsetsBufferIndex, this.offsets[i + 1] + baseOffset);
        }
        this.lastOffset = this.offsets[this.positionsOffset + this.batchSize] + baseOffset;
    }
}

