/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.BlockToBooleanFunction;
import com.facebook.presto.operator.scalar.BooleanToBooleanFunction;
import com.facebook.presto.operator.scalar.DoubleToBooleanFunction;
import com.facebook.presto.operator.scalar.LongToBooleanFunction;
import com.facebook.presto.operator.scalar.SliceToBooleanFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameterSpecialization;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;

@Description(value="return array containing elements that match the given predicate")
@ScalarFunction(value="filter", deterministic=false)
public final class ArrayFilterFunction {
    private ArrayFilterFunction() {
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="array(T)")
    public static Block filterLong(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") LongToBooleanFunction function) {
        BlockBuilder resultBuilder;
        int position;
        int positionCount = arrayBlock.getPositionCount();
        if (arrayBlock.mayHaveNull()) {
            for (position = 0; position < positionCount && Boolean.TRUE.equals(function.apply(arrayBlock.isNull(position) ? null : Long.valueOf(elementType.getLong(arrayBlock, position)))); ++position) {
            }
            if (position == positionCount) {
                return arrayBlock;
            }
            resultBuilder = elementType.createBlockBuilder(null, positionCount);
            for (int i = 0; i < position; ++i) {
                elementType.appendTo(arrayBlock, i, resultBuilder);
            }
            ++position;
            while (position < positionCount) {
                if (Boolean.TRUE.equals(function.apply(arrayBlock.isNull(position) ? null : Long.valueOf(elementType.getLong(arrayBlock, position))))) {
                    elementType.appendTo(arrayBlock, position, resultBuilder);
                }
                ++position;
            }
        } else {
            while (position < positionCount && Boolean.TRUE.equals(function.apply(elementType.getLong(arrayBlock, position)))) {
                ++position;
            }
            if (position == positionCount) {
                return arrayBlock;
            }
            resultBuilder = elementType.createBlockBuilder(null, positionCount);
            for (int i = 0; i < position; ++i) {
                elementType.appendTo(arrayBlock, i, resultBuilder);
            }
            ++position;
            while (position < positionCount) {
                if (Boolean.TRUE.equals(function.apply(elementType.getLong(arrayBlock, position)))) {
                    elementType.appendTo(arrayBlock, position, resultBuilder);
                }
                ++position;
            }
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="array(T)")
    public static Block filterDouble(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") DoubleToBooleanFunction function) {
        BlockBuilder resultBuilder;
        int position;
        int positionCount = arrayBlock.getPositionCount();
        if (arrayBlock.mayHaveNull()) {
            for (position = 0; position < positionCount && Boolean.TRUE.equals(function.apply(arrayBlock.isNull(position) ? null : Double.valueOf(elementType.getDouble(arrayBlock, position)))); ++position) {
            }
            if (position == positionCount) {
                return arrayBlock;
            }
            resultBuilder = elementType.createBlockBuilder(null, positionCount);
            for (int i = 0; i < position; ++i) {
                elementType.appendTo(arrayBlock, i, resultBuilder);
            }
            ++position;
            while (position < positionCount) {
                if (Boolean.TRUE.equals(function.apply(arrayBlock.isNull(position) ? null : Double.valueOf(elementType.getDouble(arrayBlock, position))))) {
                    elementType.appendTo(arrayBlock, position, resultBuilder);
                }
                ++position;
            }
        } else {
            while (position < positionCount && Boolean.TRUE.equals(function.apply(elementType.getDouble(arrayBlock, position)))) {
                ++position;
            }
            if (position == positionCount) {
                return arrayBlock;
            }
            resultBuilder = elementType.createBlockBuilder(null, positionCount);
            for (int i = 0; i < position; ++i) {
                elementType.appendTo(arrayBlock, i, resultBuilder);
            }
            ++position;
            while (position < positionCount) {
                if (Boolean.TRUE.equals(function.apply(elementType.getDouble(arrayBlock, position)))) {
                    elementType.appendTo(arrayBlock, position, resultBuilder);
                }
                ++position;
            }
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="array(T)")
    public static Block filterBoolean(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") BooleanToBooleanFunction function) {
        BlockBuilder resultBuilder;
        int position;
        int positionCount = arrayBlock.getPositionCount();
        if (arrayBlock.mayHaveNull()) {
            for (position = 0; position < positionCount && Boolean.TRUE.equals(function.apply(arrayBlock.isNull(position) ? null : Boolean.valueOf(elementType.getBoolean(arrayBlock, position)))); ++position) {
            }
            if (position == positionCount) {
                return arrayBlock;
            }
            resultBuilder = elementType.createBlockBuilder(null, positionCount);
            for (int i = 0; i < position; ++i) {
                elementType.appendTo(arrayBlock, i, resultBuilder);
            }
            ++position;
            while (position < positionCount) {
                if (Boolean.TRUE.equals(function.apply(arrayBlock.isNull(position) ? null : Boolean.valueOf(elementType.getBoolean(arrayBlock, position))))) {
                    elementType.appendTo(arrayBlock, position, resultBuilder);
                }
                ++position;
            }
        } else {
            while (position < positionCount && Boolean.TRUE.equals(function.apply(elementType.getBoolean(arrayBlock, position)))) {
                ++position;
            }
            if (position == positionCount) {
                return arrayBlock;
            }
            resultBuilder = elementType.createBlockBuilder(null, positionCount);
            for (int i = 0; i < position; ++i) {
                elementType.appendTo(arrayBlock, i, resultBuilder);
            }
            ++position;
            while (position < positionCount) {
                if (Boolean.TRUE.equals(function.apply(elementType.getBoolean(arrayBlock, position)))) {
                    elementType.appendTo(arrayBlock, position, resultBuilder);
                }
                ++position;
            }
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Slice.class)
    @SqlType(value="array(T)")
    public static Block filterSlice(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") SliceToBooleanFunction function) {
        BlockBuilder resultBuilder;
        int position;
        int positionCount = arrayBlock.getPositionCount();
        if (arrayBlock.mayHaveNull()) {
            for (position = 0; position < positionCount && Boolean.TRUE.equals(function.apply(arrayBlock.isNull(position) ? null : elementType.getSlice(arrayBlock, position))); ++position) {
            }
            if (position == positionCount) {
                return arrayBlock;
            }
            resultBuilder = elementType.createBlockBuilder(null, positionCount);
            for (int i = 0; i < position; ++i) {
                elementType.appendTo(arrayBlock, i, resultBuilder);
            }
            ++position;
            while (position < positionCount) {
                if (Boolean.TRUE.equals(function.apply(arrayBlock.isNull(position) ? null : elementType.getSlice(arrayBlock, position)))) {
                    elementType.appendTo(arrayBlock, position, resultBuilder);
                }
                ++position;
            }
        } else {
            while (position < positionCount && Boolean.TRUE.equals(function.apply(elementType.getSlice(arrayBlock, position)))) {
                ++position;
            }
            if (position == positionCount) {
                return arrayBlock;
            }
            resultBuilder = elementType.createBlockBuilder(null, positionCount);
            for (int i = 0; i < position; ++i) {
                elementType.appendTo(arrayBlock, i, resultBuilder);
            }
            ++position;
            while (position < positionCount) {
                if (Boolean.TRUE.equals(function.apply(elementType.getSlice(arrayBlock, position)))) {
                    elementType.appendTo(arrayBlock, position, resultBuilder);
                }
                ++position;
            }
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Block.class)
    @SqlType(value="array(T)")
    public static Block filterBlock(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") BlockToBooleanFunction function) {
        BlockBuilder resultBuilder;
        int position;
        int positionCount = arrayBlock.getPositionCount();
        if (arrayBlock.mayHaveNull()) {
            for (position = 0; position < positionCount && Boolean.TRUE.equals(function.apply(arrayBlock.isNull(position) ? null : (Block)elementType.getObject(arrayBlock, position))); ++position) {
            }
            if (position == positionCount) {
                return arrayBlock;
            }
            resultBuilder = elementType.createBlockBuilder(null, positionCount);
            for (int i = 0; i < position; ++i) {
                elementType.appendTo(arrayBlock, i, resultBuilder);
            }
            ++position;
            while (position < positionCount) {
                if (Boolean.TRUE.equals(function.apply(arrayBlock.isNull(position) ? null : (Block)elementType.getObject(arrayBlock, position)))) {
                    elementType.appendTo(arrayBlock, position, resultBuilder);
                }
                ++position;
            }
        } else {
            while (position < positionCount && Boolean.TRUE.equals(function.apply((Block)elementType.getObject(arrayBlock, position)))) {
                ++position;
            }
            if (position == positionCount) {
                return arrayBlock;
            }
            resultBuilder = elementType.createBlockBuilder(null, positionCount);
            for (int i = 0; i < position; ++i) {
                elementType.appendTo(arrayBlock, i, resultBuilder);
            }
            ++position;
            while (position < positionCount) {
                if (Boolean.TRUE.equals(function.apply((Block)elementType.getObject(arrayBlock, position)))) {
                    elementType.appendTo(arrayBlock, position, resultBuilder);
                }
                ++position;
            }
        }
        return resultBuilder.build();
    }
}

