/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameters;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.INDETERMINATE)
public final class MapIndeterminateOperator {
    private MapIndeterminateOperator() {
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="boolean")
    public static boolean indeterminate(@OperatorDependency(operator=OperatorType.INDETERMINATE, argumentTypes={"V"}) MethodHandle valueIndeterminateFunction, @TypeParameter(value="K") Type keyType, @TypeParameter(value="V") Type valueType, @SqlType(value="map(K,V)") Block block, @IsNull boolean isNull) {
        if (isNull) {
            return true;
        }
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            if (block.isNull(i + 1)) {
                return true;
            }
            try {
                if (!valueIndeterminateFunction.invoke(TypeUtils.readNativeValue((Type)valueType, (Block)block, (int)(i + 1)), false)) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return false;
    }
}

