/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameters;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;

@ScalarFunction(value="multimap_from_entries")
@Description(value="construct a multimap from an array of entries")
public final class MultimapFromEntriesFunction {
    private static final String NAME = "multimap_from_entries";
    private static final int INITIAL_ENTRY_COUNT = 128;
    private final PageBuilder pageBuilder;
    private IntList[] entryIndicesList;

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    public MultimapFromEntriesFunction(@TypeParameter(value="map(K,array(V))") Type mapType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
        this.initializeEntryIndicesList(128);
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="map(K,array(V))")
    @SqlNullable
    public Block multimapFromEntries(@TypeParameter(value="map(K,array(V))") MapType mapType, @SqlType(value="array(row(K,V))") Block block) {
        int entryCount;
        Type keyType = mapType.getKeyType();
        Type valueType = ((ArrayType)mapType.getValueType()).getElementType();
        RowType rowType = RowType.anonymous((List)ImmutableList.of((Object)keyType, (Object)valueType));
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        if ((entryCount = block.getPositionCount()) > this.entryIndicesList.length) {
            this.initializeEntryIndicesList(entryCount);
        }
        TypedSet keySet = new TypedSet(keyType, entryCount, NAME);
        for (int i = 0; i < entryCount; ++i) {
            if (block.isNull(i)) {
                this.clearEntryIndices(keySet.size());
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map entry cannot be null");
            }
            Block rowBlock = rowType.getObject(block, i);
            if (rowBlock.isNull(0)) {
                this.clearEntryIndices(keySet.size());
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be null");
            }
            if (keySet.contains(rowBlock, 0)) {
                this.entryIndicesList[keySet.positionOf(rowBlock, 0)].add(i);
                continue;
            }
            keySet.add(rowBlock, 0);
            this.entryIndicesList[keySet.size() - 1].add(i);
        }
        BlockBuilder multimapBlockBuilder = this.pageBuilder.getBlockBuilder(0);
        BlockBuilder singleMapWriter = multimapBlockBuilder.beginBlockEntry();
        for (int i = 0; i < keySet.size(); ++i) {
            keyType.appendTo(rowType.getObject(block, this.entryIndicesList[i].getInt(0)), 0, singleMapWriter);
            BlockBuilder singleArrayWriter = singleMapWriter.beginBlockEntry();
            IntListIterator intListIterator = this.entryIndicesList[i].iterator();
            while (intListIterator.hasNext()) {
                int entryIndex = (Integer)intListIterator.next();
                valueType.appendTo(rowType.getObject(block, entryIndex), 1, singleArrayWriter);
            }
            singleMapWriter.closeEntry();
        }
        multimapBlockBuilder.closeEntry();
        this.pageBuilder.declarePosition();
        this.clearEntryIndices(keySet.size());
        return mapType.getObject((Block)multimapBlockBuilder, multimapBlockBuilder.getPositionCount() - 1);
    }

    private void clearEntryIndices(int entryCount) {
        Verify.verify((entryCount <= this.entryIndicesList.length ? 1 : 0) != 0);
        for (int i = 0; i < entryCount; ++i) {
            this.entryIndicesList[i].clear();
        }
    }

    private void initializeEntryIndicesList(int entryCount) {
        this.entryIndicesList = new IntList[entryCount];
        for (int i = 0; i < this.entryIndicesList.length; ++i) {
            this.entryIndicesList[i] = new IntArrayList();
        }
    }
}

