/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.Constraint;
import com.facebook.presto.type.Re2JRegexp;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class Re2JRegexpFunctions {
    private Re2JRegexpFunctions() {
    }

    @Description(value="returns substrings matching a regular expression")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="boolean")
    public static boolean regexpLike(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return pattern.matches(source);
    }

    @Description(value="removes substrings matching a regular expression")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice regexpReplace(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return Re2JRegexpFunctions.regexpReplace(source, pattern, Slices.EMPTY_SLICE);
    }

    @Description(value="replaces substrings matching a regular expression by given string")
    @ScalarFunction
    @LiteralParameters(value={"x", "y", "z"})
    @Constraint(variable="z", expression="min(2147483647, x + max(x * y / 2, y) * (x + 1))")
    @SqlType(value="varchar(z)")
    public static Slice regexpReplace(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern, @SqlType(value="varchar(y)") Slice replacement) {
        return pattern.replace(source, replacement);
    }

    @Description(value="string(s) extracted using the given pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="array<varchar(x)>")
    public static Block regexpExtractAll(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return Re2JRegexpFunctions.regexpExtractAll(source, pattern, 0L);
    }

    @Description(value="group(s) extracted using the given pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="array<varchar(x)>")
    public static Block regexpExtractAll(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern, @SqlType(value="bigint") long groupIndex) {
        return pattern.extractAll(source, groupIndex);
    }

    @SqlNullable
    @Description(value="string extracted using the given pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice regexpExtract(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return Re2JRegexpFunctions.regexpExtract(source, pattern, 0L);
    }

    @SqlNullable
    @Description(value="returns regex group of extracted string with a pattern")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice regexpExtract(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern, @SqlType(value="bigint") long groupIndex) {
        return pattern.extract(source, groupIndex);
    }

    @ScalarFunction
    @Description(value="returns array of strings split by pattern")
    @LiteralParameters(value={"x"})
    @SqlType(value="array<varchar(x)>")
    public static Block regexpSplit(@SqlType(value="varchar(x)") Slice source, @SqlType(value="Re2JRegExp") Re2JRegexp pattern) {
        return pattern.split(source);
    }
}

