/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.annotations;

import com.facebook.presto.metadata.BuiltInFunctionNamespaceManager;
import com.facebook.presto.operator.annotations.FunctionsParserHelper;
import com.facebook.presto.operator.scalar.ScalarHeader;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.QualifiedFunctionName;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ScalarImplementationHeader {
    private final QualifiedFunctionName name;
    private final Optional<OperatorType> operatorType;
    private final ScalarHeader header;

    private ScalarImplementationHeader(String name, ScalarHeader header) {
        this.name = QualifiedFunctionName.of((CatalogSchemaName)BuiltInFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)Objects.requireNonNull(name));
        this.operatorType = Optional.empty();
        this.header = Objects.requireNonNull(header);
    }

    private ScalarImplementationHeader(OperatorType operatorType, ScalarHeader header) {
        this.name = operatorType.getFunctionName();
        this.operatorType = Optional.of(operatorType);
        this.header = Objects.requireNonNull(header);
    }

    private static String annotatedName(AnnotatedElement annotatedElement) {
        if (annotatedElement instanceof Class) {
            return ((Class)annotatedElement).getSimpleName();
        }
        if (annotatedElement instanceof Method) {
            return ((Method)annotatedElement).getName();
        }
        throw new UnsupportedOperationException("Only Classes and Methods are supported as annotated elements.");
    }

    private static String camelToSnake(String name) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
    }

    public static List<ScalarImplementationHeader> fromAnnotatedElement(AnnotatedElement annotated) {
        ImmutableList result;
        ScalarFunction scalarFunction = annotated.getAnnotation(ScalarFunction.class);
        ScalarOperator scalarOperator = annotated.getAnnotation(ScalarOperator.class);
        Optional<String> description = FunctionsParserHelper.parseDescription(annotated);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (scalarFunction != null) {
            String baseName = scalarFunction.value().isEmpty() ? ScalarImplementationHeader.camelToSnake(ScalarImplementationHeader.annotatedName(annotated)) : scalarFunction.value();
            builder.add((Object)new ScalarImplementationHeader(baseName, new ScalarHeader(description, scalarFunction.visibility(), scalarFunction.deterministic(), scalarFunction.calledOnNullInput())));
            for (String alias : scalarFunction.alias()) {
                builder.add((Object)new ScalarImplementationHeader(alias, new ScalarHeader(description, scalarFunction.visibility(), scalarFunction.deterministic(), scalarFunction.calledOnNullInput())));
            }
        }
        if (scalarOperator != null) {
            builder.add((Object)new ScalarImplementationHeader(scalarOperator.value(), new ScalarHeader(description, SqlFunctionVisibility.HIDDEN, true, scalarOperator.value().isCalledOnNullInput())));
        }
        Preconditions.checkArgument((!(result = builder.build()).isEmpty() ? 1 : 0) != 0);
        return result;
    }

    public QualifiedFunctionName getName() {
        return this.name;
    }

    public Optional<OperatorType> getOperatorType() {
        return this.operatorType;
    }

    public Optional<String> getDescription() {
        return this.header.getDescription();
    }

    public SqlFunctionVisibility getVisibility() {
        return this.header.getVisibility();
    }

    public ScalarHeader getHeader() {
        return this.header;
    }
}

