/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.unnest;

import com.facebook.presto.operator.unnest.UnnestOperatorBlockUtil;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;

class ReplicatedBlockBuilder {
    private Block source;
    private int[] ids;
    private int positionCount;

    ReplicatedBlockBuilder() {
    }

    public void resetInputBlock(Block block) {
        this.source = Objects.requireNonNull(block, "block is null");
    }

    public void startNewOutput(int expectedEntries) {
        Preconditions.checkState((this.source != null ? 1 : 0) != 0, (Object)"source is null");
        this.ids = new int[expectedEntries];
        this.positionCount = 0;
    }

    public void appendRepeated(int index, int count) {
        Preconditions.checkState((this.source != null ? 1 : 0) != 0, (Object)"source is null");
        Preconditions.checkElementIndex((int)index, (int)this.source.getPositionCount());
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"count should be >= 0");
        if (this.positionCount + count > this.ids.length) {
            int newSize = Math.max(UnnestOperatorBlockUtil.calculateNewArraySize(this.ids.length), this.positionCount + count);
            this.ids = Arrays.copyOf(this.ids, newSize);
        }
        Arrays.fill(this.ids, this.positionCount, this.positionCount + count, index);
        this.positionCount += count;
    }

    public Block buildOutputAndFlush() {
        DictionaryBlock outputBlock = new DictionaryBlock(this.positionCount, this.source, this.ids);
        this.ids = new int[0];
        this.positionCount = 0;
        return outputBlock;
    }
}

