/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.security;

import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.transaction.TransactionId;
import java.security.Principal;
import java.util.Optional;
import java.util.Set;

public interface AccessControl {
    public void checkCanSetUser(AccessControlContext var1, Optional<Principal> var2, String var3);

    public void checkQueryIntegrity(Identity var1, AccessControlContext var2, String var3);

    public Set<String> filterCatalogs(Identity var1, AccessControlContext var2, Set<String> var3);

    public void checkCanAccessCatalog(Identity var1, AccessControlContext var2, String var3);

    public void checkCanCreateSchema(TransactionId var1, Identity var2, AccessControlContext var3, CatalogSchemaName var4);

    public void checkCanDropSchema(TransactionId var1, Identity var2, AccessControlContext var3, CatalogSchemaName var4);

    public void checkCanRenameSchema(TransactionId var1, Identity var2, AccessControlContext var3, CatalogSchemaName var4, String var5);

    public void checkCanShowSchemas(TransactionId var1, Identity var2, AccessControlContext var3, String var4);

    public Set<String> filterSchemas(TransactionId var1, Identity var2, AccessControlContext var3, String var4, Set<String> var5);

    public void checkCanCreateTable(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanDropTable(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanRenameTable(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4, QualifiedObjectName var5);

    public void checkCanShowTablesMetadata(TransactionId var1, Identity var2, AccessControlContext var3, CatalogSchemaName var4);

    public Set<SchemaTableName> filterTables(TransactionId var1, Identity var2, AccessControlContext var3, String var4, Set<SchemaTableName> var5);

    public void checkCanAddColumns(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanDropColumn(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanRenameColumn(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanInsertIntoTable(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanDeleteFromTable(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanCreateView(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanDropView(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4);

    public void checkCanCreateViewWithSelectFromColumns(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4, Set<String> var5);

    public void checkCanGrantTablePrivilege(TransactionId var1, Identity var2, AccessControlContext var3, Privilege var4, QualifiedObjectName var5, PrestoPrincipal var6, boolean var7);

    public void checkCanRevokeTablePrivilege(TransactionId var1, Identity var2, AccessControlContext var3, Privilege var4, QualifiedObjectName var5, PrestoPrincipal var6, boolean var7);

    public void checkCanSetSystemSessionProperty(Identity var1, AccessControlContext var2, String var3);

    public void checkCanSetCatalogSessionProperty(TransactionId var1, Identity var2, AccessControlContext var3, String var4, String var5);

    public void checkCanSelectFromColumns(TransactionId var1, Identity var2, AccessControlContext var3, QualifiedObjectName var4, Set<String> var5);

    public void checkCanCreateRole(TransactionId var1, Identity var2, AccessControlContext var3, String var4, Optional<PrestoPrincipal> var5, String var6);

    public void checkCanDropRole(TransactionId var1, Identity var2, AccessControlContext var3, String var4, String var5);

    public void checkCanGrantRoles(TransactionId var1, Identity var2, AccessControlContext var3, Set<String> var4, Set<PrestoPrincipal> var5, boolean var6, Optional<PrestoPrincipal> var7, String var8);

    public void checkCanRevokeRoles(TransactionId var1, Identity var2, AccessControlContext var3, Set<String> var4, Set<PrestoPrincipal> var5, boolean var6, Optional<PrestoPrincipal> var7, String var8);

    public void checkCanSetRole(TransactionId var1, Identity var2, AccessControlContext var3, String var4, String var5);

    public void checkCanShowRoles(TransactionId var1, Identity var2, AccessControlContext var3, String var4);

    public void checkCanShowCurrentRoles(TransactionId var1, Identity var2, AccessControlContext var3, String var4);

    public void checkCanShowRoleGrants(TransactionId var1, Identity var2, AccessControlContext var3, String var4);
}

