/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.operator.ExchangeClientConfig;
import com.facebook.presto.server.ForAsyncRpc;
import com.facebook.presto.server.SerializedPageWriteListener;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.util.TaskUtils;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AsyncPageTransportServlet
extends HttpServlet {
    private static final Logger log = Logger.get(AsyncPageTransportServlet.class);
    private final Duration pageTransportTimeout;
    private final TaskManager taskManager;
    private final Executor responseExecutor;
    private final ScheduledExecutorService timeoutExecutor;

    @Inject
    public AsyncPageTransportServlet(TaskManager taskManager, ExchangeClientConfig exchangeClientConfig, @ForAsyncRpc BoundedExecutor responseExecutor, @ForAsyncRpc ScheduledExecutorService timeoutExecutor) {
        this.taskManager = Objects.requireNonNull(taskManager, "taskManager is null");
        this.pageTransportTimeout = Objects.requireNonNull(exchangeClientConfig.getAsyncPageTransportTimeout(), "asyncPageTransportTimeout is null");
        this.responseExecutor = (Executor)Objects.requireNonNull(responseExecutor, "responseExecutor is null");
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
    }

    protected void doGet(HttpServletRequest request, final HttpServletResponse response) throws IOException {
        final String requestURI = request.getRequestURI();
        List<String> requestURIParts = Arrays.asList(requestURI.split("/"));
        if (requestURIParts.size() != 8) {
            response.sendError(400, String.format("Unexpected URI for task result request in async mode: %s", requestURI));
            return;
        }
        TaskId taskId = TaskId.valueOf(requestURIParts.get(4));
        OutputBuffers.OutputBufferId bufferId = OutputBuffers.OutputBufferId.fromString(requestURIParts.get(6));
        long token = Long.parseLong(requestURIParts.get(7));
        DataSize maxSize = DataSize.valueOf((String)request.getHeader("X-Presto-Max-Size"));
        final AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        Duration waitTime = TaskUtils.randomizeWaitTime(TaskUtils.DEFAULT_MAX_WAIT_TIME);
        asyncContext.setTimeout(waitTime.toMillis() + this.pageTransportTimeout.toMillis());
        asyncContext.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) {
            }

            public void onError(AsyncEvent event) throws IOException {
                String errorMessage = String.format("Server error to process task result request %s : %s", requestURI, event.getThrowable().getMessage());
                log.error(event.getThrowable(), errorMessage);
                response.sendError(500, errorMessage);
            }

            public void onStartAsync(AsyncEvent event) {
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                String errorMessage = String.format("Server timeout to process task result request: %s", requestURI);
                log.error(event.getThrowable(), errorMessage);
                response.sendError(500, errorMessage);
            }
        });
        ListenableFuture bufferResultFuture = this.taskManager.getTaskResults(taskId, bufferId, token, maxSize);
        bufferResultFuture = MoreFutures.addTimeout(bufferResultFuture, () -> BufferResult.emptyResults(this.taskManager.getTaskInstanceId(taskId), token, false), (Duration)waitTime, (ScheduledExecutorService)this.timeoutExecutor);
        final ServletOutputStream out = response.getOutputStream();
        Futures.addCallback((ListenableFuture)bufferResultFuture, (FutureCallback)new FutureCallback<BufferResult>(){

            public void onSuccess(BufferResult bufferResult) {
                LinkedList<SerializedPage> serializedPages = new LinkedList<SerializedPage>(bufferResult.getSerializedPages());
                response.setHeader("Content-Type", "application/X-presto-pages");
                response.setHeader("X-Presto-Task-Instance-Id", bufferResult.getTaskInstanceId());
                response.setHeader("X-Presto-Page-Sequence-Id", String.valueOf(bufferResult.getToken()));
                response.setHeader("X-Presto-Page-End-Sequence-Id", String.valueOf(bufferResult.getNextToken()));
                response.setHeader("X-Presto-Buffer-Complete", String.valueOf(bufferResult.isBufferComplete()));
                if (serializedPages.isEmpty()) {
                    response.setStatus(204);
                    asyncContext.complete();
                } else {
                    int contentLength = serializedPages.stream().mapToInt(page -> page.getSizeInBytes() + 13).sum();
                    response.setHeader("Content-Length", String.valueOf(contentLength));
                    out.setWriteListener((WriteListener)new SerializedPageWriteListener(serializedPages, asyncContext, out));
                }
            }

            public void onFailure(Throwable thrown) {
                String errorMessage = String.format("Error getting task result from TaskManager for request %s : %s", requestURI, thrown.getMessage());
                log.error(thrown, errorMessage);
                try {
                    response.sendError(500, errorMessage);
                }
                catch (IOException e) {
                    log.error((Throwable)e, "Failed to send response with error code: %s", new Object[]{e.getMessage()});
                }
                asyncContext.complete();
            }
        }, (Executor)this.responseExecutor);
    }

    public void destroy() {
    }
}

