/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.http.server.AsyncResponseHandler;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.SimpleLocalMemoryContext;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.server.ForStatementResource;
import com.facebook.presto.server.protocol.Query;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/")
public class ExecutingStatementResource {
    private static final Logger log = Logger.get(ExecutingStatementResource.class);
    private static final Duration MAX_WAIT_TIME = new Duration(1.0, TimeUnit.SECONDS);
    private static final Ordering<Comparable<Duration>> WAIT_ORDERING = Ordering.natural().nullsLast();
    private static final DataSize DEFAULT_TARGET_RESULT_SIZE = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private static final DataSize MAX_TARGET_RESULT_SIZE = new DataSize(128.0, DataSize.Unit.MEGABYTE);
    private final QueryManager queryManager;
    private final ExchangeClientSupplier exchangeClientSupplier;
    private final BlockEncodingSerde blockEncodingSerde;
    private final BoundedExecutor responseExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final ConcurrentMap<QueryId, Query> queries = new ConcurrentHashMap<QueryId, Query>();
    private final ScheduledExecutorService queryPurger = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"execution-query-purger"));

    @Inject
    public ExecutingStatementResource(QueryManager queryManager, ExchangeClientSupplier exchangeClientSupplier, BlockEncodingSerde blockEncodingSerde, @ForStatementResource BoundedExecutor responseExecutor, @ForStatementResource ScheduledExecutorService timeoutExecutor) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.exchangeClientSupplier = Objects.requireNonNull(exchangeClientSupplier, "exchangeClientSupplier is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.responseExecutor = Objects.requireNonNull(responseExecutor, "responseExecutor is null");
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        this.queryPurger.scheduleWithFixedDelay(() -> {
            try {
                for (Map.Entry entry : this.queries.entrySet()) {
                    try {
                        queryManager.getQueryState((QueryId)entry.getKey());
                    }
                    catch (NoSuchElementException e) {
                        this.queries.remove(entry.getKey());
                    }
                }
            }
            catch (Throwable e) {
                log.warn(e, "Error removing old queries");
            }
        }, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void stop() {
        this.queryPurger.shutdownNow();
    }

    @GET
    @Path(value="/v1/statement/executing/{queryId}/{token}")
    @Produces(value={"application/json"})
    public void getQueryResults(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="slug") String slug, @QueryParam(value="maxWait") Duration maxWait, @QueryParam(value="targetResultSize") DataSize targetResultSize, @HeaderParam(value="X-Forwarded-Proto") String proto, @Context UriInfo uriInfo, @Suspended AsyncResponse asyncResponse) {
        Query query = this.getQuery(queryId, slug);
        if (Strings.isNullOrEmpty((String)proto)) {
            proto = uriInfo.getRequestUri().getScheme();
        }
        this.asyncQueryResults(query, token, maxWait, targetResultSize, uriInfo, proto, asyncResponse);
    }

    protected Query getQuery(QueryId queryId, String slug) {
        Session session;
        Query query = (Query)this.queries.get(queryId);
        if (query != null) {
            if (!query.isSlugValid(slug)) {
                throw ExecutingStatementResource.notFound("Query not found");
            }
            return query;
        }
        try {
            if (!this.queryManager.isQuerySlugValid(queryId, slug)) {
                throw ExecutingStatementResource.notFound("Query not found");
            }
            session = this.queryManager.getQuerySession(queryId);
        }
        catch (NoSuchElementException e) {
            throw ExecutingStatementResource.notFound("Query not found");
        }
        query = this.queries.computeIfAbsent(queryId, id -> {
            ExchangeClient exchangeClient = this.exchangeClientSupplier.get((LocalMemoryContext)new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), ExecutingStatementResource.class.getSimpleName()));
            return Query.create(session, slug, this.queryManager, exchangeClient, (Executor)this.responseExecutor, this.timeoutExecutor, this.blockEncodingSerde);
        });
        return query;
    }

    private void asyncQueryResults(Query query, long token, Duration maxWait, DataSize targetResultSize, UriInfo uriInfo, String scheme, AsyncResponse asyncResponse) {
        Duration wait = (Duration)WAIT_ORDERING.min((Object)MAX_WAIT_TIME, (Object)maxWait);
        targetResultSize = targetResultSize == null ? DEFAULT_TARGET_RESULT_SIZE : (DataSize)Ordering.natural().min((Object)targetResultSize, (Object)MAX_TARGET_RESULT_SIZE);
        ListenableFuture<QueryResults> queryResultsFuture = query.waitForResults(token, uriInfo, scheme, wait, targetResultSize);
        ListenableFuture response = Futures.transform(queryResultsFuture, queryResults -> ExecutingStatementResource.toResponse(query, queryResults), (Executor)MoreExecutors.directExecutor());
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, (ListenableFuture)response, (Executor)this.responseExecutor);
    }

    private static Response toResponse(Query query, QueryResults queryResults) {
        Response.ResponseBuilder response = Response.ok((Object)queryResults);
        query.getSetCatalog().ifPresent(catalog -> response.header("X-Presto-Set-Catalog", catalog));
        query.getSetSchema().ifPresent(schema -> response.header("X-Presto-Set-Schema", schema));
        query.getSetSessionProperties().forEach((key, value) -> response.header("X-Presto-Set-Session", (Object)(key + '=' + ExecutingStatementResource.urlEncode(value))));
        query.getResetSessionProperties().forEach(name -> response.header("X-Presto-Clear-Session", name));
        query.getSetRoles().forEach((key, value) -> response.header("X-Presto-Set-Role", (Object)(key + '=' + ExecutingStatementResource.urlEncode(value.toString()))));
        for (Map.Entry<String, String> entry : query.getAddedPreparedStatements().entrySet()) {
            String encodedKey = ExecutingStatementResource.urlEncode(entry.getKey());
            String encodedValue = ExecutingStatementResource.urlEncode(entry.getValue());
            response.header("X-Presto-Added-Prepare", (Object)(encodedKey + '=' + encodedValue));
        }
        for (String name2 : query.getDeallocatedPreparedStatements()) {
            response.header("X-Presto-Deallocated-Prepare", (Object)ExecutingStatementResource.urlEncode(name2));
        }
        query.getStartedTransactionId().ifPresent(transactionId -> response.header("X-Presto-Started-Transaction-Id", transactionId));
        if (query.isClearTransactionId()) {
            response.header("X-Presto-Clear-Transaction-Id", (Object)true);
        }
        return response.build();
    }

    @DELETE
    @Path(value="/v1/statement/executing/{queryId}/{token}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="slug") String slug) {
        Query query = (Query)this.queries.get(queryId);
        if (query != null) {
            if (!query.isSlugValid(slug)) {
                throw ExecutingStatementResource.notFound("Query not found");
            }
            query.cancel();
            return Response.noContent().build();
        }
        try {
            if (!this.queryManager.isQuerySlugValid(queryId, slug)) {
                throw ExecutingStatementResource.notFound("Query not found");
            }
            this.queryManager.cancelQuery(queryId);
            return Response.noContent().build();
        }
        catch (NoSuchElementException e) {
            throw ExecutingStatementResource.notFound("Query not found");
        }
    }

    private static WebApplicationException notFound(String message) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)message).build());
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

