/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.ExpressionDeterminismEvaluator;
import com.facebook.presto.sql.planner.ExpressionNodeInliner;
import com.facebook.presto.sql.planner.NullabilityAnalyzer;
import com.facebook.presto.sql.planner.SubExpressionExtractor;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.util.DisjointSet;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Deprecated
public class EqualityInference {
    private static final Ordering<Expression> CANONICAL_ORDERING = Ordering.from((expression1, expression2) -> ComparisonChain.start().compare(VariablesExtractor.extractAllSymbols(expression1).size(), VariablesExtractor.extractAllSymbols(expression2).size()).compare(SubExpressionExtractor.extract(expression1).size(), SubExpressionExtractor.extract(expression2).size()).compare((Comparable)((Object)expression1.toString()), (Comparable)((Object)expression2.toString())).result());
    private final SetMultimap<Expression, Expression> equalitySets;
    private final Map<Expression, Expression> canonicalMap;
    private final Set<Expression> derivedExpressions;

    private EqualityInference(Iterable<Set<Expression>> equalityGroups, Set<Expression> derivedExpressions) {
        ImmutableSetMultimap.Builder setBuilder = ImmutableSetMultimap.builder();
        for (Set<Expression> equalityGroup : equalityGroups) {
            if (equalityGroup.isEmpty()) continue;
            setBuilder.putAll(CANONICAL_ORDERING.min(equalityGroup), equalityGroup);
        }
        this.equalitySets = setBuilder.build();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.equalitySets.entries()) {
            Expression canonical = (Expression)entry.getKey();
            Expression expression = (Expression)entry.getValue();
            mapBuilder.put((Object)expression, (Object)canonical);
        }
        this.canonicalMap = mapBuilder.build();
        this.derivedExpressions = ImmutableSet.copyOf(derivedExpressions);
    }

    public Expression rewriteExpression(Expression expression, Predicate<VariableReferenceExpression> variableScope, TypeProvider types) {
        Preconditions.checkArgument((boolean)ExpressionDeterminismEvaluator.isDeterministic(expression), (Object)"Only deterministic expressions may be considered for rewrite");
        return this.rewriteExpression(expression, variableScope, true, types);
    }

    public Expression rewriteExpressionAllowNonDeterministic(Expression expression, Predicate<VariableReferenceExpression> variableScope, TypeProvider types) {
        return this.rewriteExpression(expression, variableScope, true, types);
    }

    private Expression rewriteExpression(Expression expression, Predicate<VariableReferenceExpression> variableScope, boolean allowFullReplacement, TypeProvider types) {
        Iterable<Object> subExpressions = SubExpressionExtractor.extract(expression);
        if (!allowFullReplacement) {
            subExpressions = Iterables.filter(subExpressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)expression)));
        }
        ImmutableMap.Builder expressionRemap = ImmutableMap.builder();
        for (Expression subExpression : subExpressions) {
            Expression canonical = this.getScopedCanonical(subExpression, variableScope, types);
            if (canonical == null) continue;
            expressionRemap.put((Object)subExpression, (Object)canonical);
        }
        Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionNodeInliner((Map<? extends Expression, ? extends Expression>)expressionRemap.build()), (Expression)expression);
        if (!EqualityInference.variableToExpressionPredicate(variableScope, types).apply((Object)rewritten)) {
            return null;
        }
        return rewritten;
    }

    public EqualityPartition generateEqualitiesPartitionedBy(Predicate<VariableReferenceExpression> variableScope, TypeProvider types) {
        ImmutableSet.Builder scopeEqualities = ImmutableSet.builder();
        ImmutableSet.Builder scopeComplementEqualities = ImmutableSet.builder();
        ImmutableSet.Builder scopeStraddlingEqualities = ImmutableSet.builder();
        for (Collection equalitySet : this.equalitySets.asMap().values()) {
            LinkedHashSet<Expression> scopeExpressions = new LinkedHashSet<Expression>();
            LinkedHashSet<Expression> scopeComplementExpressions = new LinkedHashSet<Expression>();
            LinkedHashSet<Object> scopeStraddlingExpressions = new LinkedHashSet<Object>();
            for (Object expression : Iterables.filter((Iterable)equalitySet, (Predicate)Predicates.not(this.derivedExpressions::contains))) {
                Expression scopeComplementRewritten;
                Expression scopeRewritten = this.rewriteExpression((Expression)expression, variableScope, false, types);
                if (scopeRewritten != null) {
                    scopeExpressions.add(scopeRewritten);
                }
                if ((scopeComplementRewritten = this.rewriteExpression((Expression)expression, (Predicate<VariableReferenceExpression>)Predicates.not(variableScope), false, types)) != null) {
                    scopeComplementExpressions.add(scopeComplementRewritten);
                }
                if (scopeRewritten != null || scopeComplementRewritten != null) continue;
                scopeStraddlingExpressions.add(expression);
            }
            Expression matchingCanonical = EqualityInference.getCanonical(scopeExpressions);
            if (scopeExpressions.size() >= 2) {
                Object expression;
                expression = Iterables.filter(scopeExpressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)matchingCanonical))).iterator();
                while (expression.hasNext()) {
                    Expression expression2 = (Expression)expression.next();
                    scopeEqualities.add((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, matchingCanonical, expression2));
                }
            }
            Expression complementCanonical = EqualityInference.getCanonical(scopeComplementExpressions);
            if (scopeComplementExpressions.size() >= 2) {
                for (Expression expression : Iterables.filter(scopeComplementExpressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)complementCanonical)))) {
                    scopeComplementEqualities.add((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, complementCanonical, expression));
                }
            }
            ImmutableList connectingExpressions = new ArrayList();
            connectingExpressions.add(matchingCanonical);
            connectingExpressions.add(complementCanonical);
            connectingExpressions.addAll(scopeStraddlingExpressions);
            Expression connectingCanonical = EqualityInference.getCanonical((Iterable<Expression>)(connectingExpressions = ImmutableList.copyOf((Iterable)Iterables.filter(connectingExpressions, (Predicate)Predicates.notNull()))));
            if (connectingCanonical == null) continue;
            for (Expression expression : Iterables.filter((Iterable)connectingExpressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)connectingCanonical)))) {
                scopeStraddlingEqualities.add((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, connectingCanonical, expression));
            }
        }
        return new EqualityPartition((Iterable<Expression>)scopeEqualities.build(), (Iterable<Expression>)scopeComplementEqualities.build(), (Iterable<Expression>)scopeStraddlingEqualities.build());
    }

    private static Expression getCanonical(Iterable<Expression> expressions) {
        if (Iterables.isEmpty(expressions)) {
            return null;
        }
        return (Expression)CANONICAL_ORDERING.min(expressions);
    }

    @VisibleForTesting
    Expression getScopedCanonical(Expression expression, Predicate<VariableReferenceExpression> variableScope, TypeProvider types) {
        Expression canonicalIndex = this.canonicalMap.get(expression);
        if (canonicalIndex == null) {
            return null;
        }
        return EqualityInference.getCanonical(Iterables.filter((Iterable)this.equalitySets.get((Object)canonicalIndex), EqualityInference.variableToExpressionPredicate(variableScope, types)));
    }

    private static Predicate<Expression> variableToExpressionPredicate(Predicate<VariableReferenceExpression> variableScope, TypeProvider types) {
        return expression -> Iterables.all(VariablesExtractor.extractUnique(expression, types), (Predicate)variableScope);
    }

    public static Predicate<Expression> isInferenceCandidate() {
        return expression -> {
            ComparisonExpression comparison;
            if ((expression = EqualityInference.normalizeInPredicateToEquality(expression)) instanceof ComparisonExpression && ExpressionDeterminismEvaluator.isDeterministic(expression) && !NullabilityAnalyzer.mayReturnNullOnNonNullInput(expression) && (comparison = (ComparisonExpression)expression).getOperator() == ComparisonExpression.Operator.EQUAL) {
                return !comparison.getLeft().equals((Object)comparison.getRight());
            }
            return false;
        };
    }

    private static Expression normalizeInPredicateToEquality(Expression expression) {
        InListExpression valueList;
        InPredicate inPredicate;
        if (expression instanceof InPredicate && (inPredicate = (InPredicate)expression).getValueList() instanceof InListExpression && (valueList = (InListExpression)inPredicate.getValueList()).getValues().size() == 1) {
            return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, inPredicate.getValue(), (Expression)Iterables.getOnlyElement((Iterable)valueList.getValues()));
        }
        return expression;
    }

    public static Iterable<Expression> nonInferrableConjuncts(Expression expression) {
        return Iterables.filter(ExpressionUtils.extractConjuncts(expression), (Predicate)Predicates.not(EqualityInference.isInferenceCandidate()));
    }

    public static EqualityInference createEqualityInference(Expression ... expressions) {
        Builder builder = new Builder();
        for (Expression expression : expressions) {
            builder.extractInferenceCandidates(expression);
        }
        return builder.build();
    }

    public static class Builder {
        private final DisjointSet<Expression> equalities = new DisjointSet();
        private final Set<Expression> derivedExpressions = new LinkedHashSet<Expression>();

        public Builder extractInferenceCandidates(Expression expression) {
            return this.addAllEqualities(Iterables.filter(ExpressionUtils.extractConjuncts(expression), EqualityInference.isInferenceCandidate()));
        }

        public Builder addAllEqualities(Iterable<Expression> expressions) {
            for (Expression expression : expressions) {
                this.addEquality(expression);
            }
            return this;
        }

        public Builder addEquality(Expression expression) {
            expression = EqualityInference.normalizeInPredicateToEquality(expression);
            Preconditions.checkArgument((boolean)EqualityInference.isInferenceCandidate().apply((Object)expression), (Object)("Expression must be a simple equality: " + expression));
            ComparisonExpression comparison = (ComparisonExpression)expression;
            this.addEquality(comparison.getLeft(), comparison.getRight());
            return this;
        }

        public Builder addEquality(Expression expression1, Expression expression2) {
            Preconditions.checkArgument((!expression1.equals((Object)expression2) ? 1 : 0) != 0, (Object)"Need to provide equality between different expressions");
            Preconditions.checkArgument((boolean)ExpressionDeterminismEvaluator.isDeterministic(expression1), (Object)("Expression must be deterministic: " + expression1));
            Preconditions.checkArgument((boolean)ExpressionDeterminismEvaluator.isDeterministic(expression2), (Object)("Expression must be deterministic: " + expression2));
            this.equalities.findAndUnion(expression1, expression2);
            return this;
        }

        private void generateMoreEquivalences() {
            Collection<Set<Expression>> equivalentClasses = this.equalities.getEquivalentClasses();
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (Set<Expression> expressions : equivalentClasses) {
                expressions.forEach(expression -> mapBuilder.put(expression, (Object)expressions));
            }
            ImmutableMap map = mapBuilder.build();
            for (Expression expression2 : map.keySet()) {
                if (this.derivedExpressions.contains(expression2)) continue;
                for (Expression subExpression : Iterables.filter(SubExpressionExtractor.extract(expression2), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)expression2)))) {
                    Set equivalentSubExpressions = (Set)map.get(subExpression);
                    if (equivalentSubExpressions == null) continue;
                    for (Expression equivalentSubExpression : Iterables.filter((Iterable)equivalentSubExpressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)subExpression)))) {
                        Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionNodeInliner((Map<? extends Expression, ? extends Expression>)ImmutableMap.of((Object)subExpression, (Object)equivalentSubExpression)), (Expression)expression2);
                        this.equalities.findAndUnion(expression2, rewritten);
                        this.derivedExpressions.add(rewritten);
                    }
                }
            }
        }

        public EqualityInference build() {
            this.generateMoreEquivalences();
            return new EqualityInference(this.equalities.getEquivalentClasses(), this.derivedExpressions);
        }
    }

    public static class EqualityPartition {
        private final List<Expression> scopeEqualities;
        private final List<Expression> scopeComplementEqualities;
        private final List<Expression> scopeStraddlingEqualities;

        public EqualityPartition(Iterable<Expression> scopeEqualities, Iterable<Expression> scopeComplementEqualities, Iterable<Expression> scopeStraddlingEqualities) {
            this.scopeEqualities = ImmutableList.copyOf(Objects.requireNonNull(scopeEqualities, "scopeEqualities is null"));
            this.scopeComplementEqualities = ImmutableList.copyOf(Objects.requireNonNull(scopeComplementEqualities, "scopeComplementEqualities is null"));
            this.scopeStraddlingEqualities = ImmutableList.copyOf(Objects.requireNonNull(scopeStraddlingEqualities, "scopeStraddlingEqualities is null"));
        }

        public List<Expression> getScopeEqualities() {
            return this.scopeEqualities;
        }

        public List<Expression> getScopeComplementEqualities() {
            return this.scopeComplementEqualities;
        }

        public List<Expression> getScopeStraddlingEqualities() {
            return this.scopeStraddlingEqualities;
        }
    }
}

