/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.plan.OrderingScheme;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.HashSet;
import java.util.List;

public class PlannerUtils {
    private PlannerUtils() {
    }

    public static SortOrder toSortOrder(SortItem sortItem) {
        if (sortItem.getOrdering() == SortItem.Ordering.ASCENDING) {
            if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
                return SortOrder.ASC_NULLS_FIRST;
            }
            return SortOrder.ASC_NULLS_LAST;
        }
        if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
            return SortOrder.DESC_NULLS_FIRST;
        }
        return SortOrder.DESC_NULLS_LAST;
    }

    public static OrderingScheme toOrderingScheme(OrderBy orderBy, TypeProvider types) {
        return PlannerUtils.toOrderingScheme((List)orderBy.getSortItems().stream().map(SortItem::getSortKey).map(item -> {
            Preconditions.checkArgument((boolean)(item instanceof SymbolReference), (Object)"must be symbol reference");
            return Expressions.variable(((SymbolReference)item).getName(), types.get((Expression)item));
        }).collect(ImmutableList.toImmutableList()), (List)orderBy.getSortItems().stream().map(PlannerUtils::toSortOrder).collect(ImmutableList.toImmutableList()));
    }

    public static OrderingScheme toOrderingScheme(List<VariableReferenceExpression> orderingSymbols, List<SortOrder> sortOrders) {
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet keysSeen = new HashSet();
        Streams.forEachPair(orderingSymbols.stream(), sortOrders.stream(), (variable, sortOrder) -> {
            if (!keysSeen.contains(variable)) {
                keysSeen.add(variable);
                builder.add((Object)new Ordering(variable, sortOrder));
            }
        });
        return new OrderingScheme((List)builder.build());
    }

    public static VariableReferenceExpression toVariableReference(Expression expression, TypeProvider types) {
        Preconditions.checkArgument((boolean)(expression instanceof SymbolReference));
        return Expressions.variable(((SymbolReference)expression).getName(), types.get(expression));
    }
}

