/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.ResolvedIndex;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.ExpressionDomainTranslator;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class IndexJoinOptimizer
implements PlanOptimizer {
    private final Metadata metadata;

    public IndexJoinOptimizer(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider type, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(variableAllocator, idAllocator, this.metadata, session), plan, null);
    }

    public static class IndexKeyTracer {
        public static Map<VariableReferenceExpression, VariableReferenceExpression> trace(PlanNode node, Set<VariableReferenceExpression> lookupVariables) {
            return (Map)node.accept((PlanVisitor)new Visitor(), lookupVariables);
        }

        private static VariableReferenceExpression extractVariable(VariableReferenceExpression key, RowExpression value) {
            if (value instanceof VariableReferenceExpression) {
                return (VariableReferenceExpression)value;
            }
            return Expressions.variable(((SymbolReference)OriginalExpressionUtils.castToExpression(value)).getName(), key.getType());
        }

        private static boolean isVariable(RowExpression expression) {
            if (OriginalExpressionUtils.isExpression(expression)) {
                return OriginalExpressionUtils.castToExpression(expression) instanceof SymbolReference;
            }
            return expression instanceof VariableReferenceExpression;
        }

        private static class Visitor
        extends InternalPlanVisitor<Map<VariableReferenceExpression, VariableReferenceExpression>, Set<VariableReferenceExpression>> {
            private Visitor() {
            }

            public Map<VariableReferenceExpression, VariableReferenceExpression> visitPlan(PlanNode node, Set<VariableReferenceExpression> lookupVariables) {
                throw new UnsupportedOperationException("Node not expected to be part of Index pipeline: " + node);
            }

            public Map<VariableReferenceExpression, VariableReferenceExpression> visitProject(ProjectNode node, Set<VariableReferenceExpression> lookupVariables) {
                Map directVariableTranslationOutputMap = Maps.transformEntries((Map)Maps.filterValues((Map)node.getAssignments().getMap(), x$0 -> IndexKeyTracer.isVariable(x$0)), (x$0, x$1) -> IndexKeyTracer.extractVariable(x$0, x$1));
                Map outputToSourceMap = (Map)lookupVariables.stream().filter(directVariableTranslationOutputMap.keySet()::contains).collect(ImmutableMap.toImmutableMap(java.util.function.Function.identity(), variable -> (VariableReferenceExpression)directVariableTranslationOutputMap.get(variable)));
                Preconditions.checkState((!outputToSourceMap.isEmpty() ? 1 : 0) != 0, (Object)"No lookup variables were able to pass through the projection");
                Map sourceToIndexMap = (Map)node.getSource().accept((PlanVisitor)this, (Object)ImmutableSet.copyOf(outputToSourceMap.values()));
                Map outputToIndexMap = Maps.transformValues((Map)Maps.filterValues((Map)outputToSourceMap, (Predicate)Predicates.in(sourceToIndexMap.keySet())), (Function)Functions.forMap((Map)sourceToIndexMap));
                return ImmutableMap.copyOf((Map)outputToIndexMap);
            }

            public Map<VariableReferenceExpression, VariableReferenceExpression> visitFilter(FilterNode node, Set<VariableReferenceExpression> lookupVariables) {
                return (Map)node.getSource().accept((PlanVisitor)this, lookupVariables);
            }

            @Override
            public Map<VariableReferenceExpression, VariableReferenceExpression> visitWindow(WindowNode node, Set<VariableReferenceExpression> lookupVariables) {
                Set partitionByLookupVariables = (Set)lookupVariables.stream().filter(node.getPartitionBy()::contains).collect(ImmutableSet.toImmutableSet());
                Preconditions.checkState((!partitionByLookupVariables.isEmpty() ? 1 : 0) != 0, (Object)"No lookup variables were able to pass through the aggregation group by");
                return (Map)node.getSource().accept((PlanVisitor)this, (Object)partitionByLookupVariables);
            }

            @Override
            public Map<VariableReferenceExpression, VariableReferenceExpression> visitIndexJoin(IndexJoinNode node, Set<VariableReferenceExpression> lookupVariables) {
                Set probeLookupVariables = (Set)lookupVariables.stream().filter(node.getProbeSource().getOutputVariables()::contains).collect(ImmutableSet.toImmutableSet());
                Preconditions.checkState((!probeLookupVariables.isEmpty() ? 1 : 0) != 0, (Object)"No lookup variables were able to pass through the index join probe source");
                return (Map)node.getProbeSource().accept((PlanVisitor)this, (Object)probeLookupVariables);
            }

            public Map<VariableReferenceExpression, VariableReferenceExpression> visitAggregation(AggregationNode node, Set<VariableReferenceExpression> lookupVariables) {
                Set groupByLookupVariables = (Set)lookupVariables.stream().filter(node.getGroupingKeys()::contains).collect(ImmutableSet.toImmutableSet());
                Preconditions.checkState((!groupByLookupVariables.isEmpty() ? 1 : 0) != 0, (Object)"No lookup variables were able to pass through the aggregation group by");
                return (Map)node.getSource().accept((PlanVisitor)this, (Object)groupByLookupVariables);
            }

            @Override
            public Map<VariableReferenceExpression, VariableReferenceExpression> visitSort(SortNode node, Set<VariableReferenceExpression> lookupVariables) {
                return (Map)node.getSource().accept((PlanVisitor)this, lookupVariables);
            }

            @Override
            public Map<VariableReferenceExpression, VariableReferenceExpression> visitIndexSource(IndexSourceNode node, Set<VariableReferenceExpression> lookupVariables) {
                Preconditions.checkState((boolean)node.getLookupVariables().equals(lookupVariables), (Object)"lookupVariables must be the same as IndexSource lookup variables");
                return (Map)lookupVariables.stream().collect(ImmutableMap.toImmutableMap(java.util.function.Function.identity(), java.util.function.Function.identity()));
            }
        }
    }

    private static class IndexSourceRewriter
    extends SimplePlanRewriter<Context> {
        private final PlanVariableAllocator variableAllocator;
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final ExpressionDomainTranslator domainTranslator;
        private final Session session;

        private IndexSourceRewriter(PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.domainTranslator = new ExpressionDomainTranslator(new LiteralEncoder(metadata.getBlockEncodingSerde()));
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public static Optional<PlanNode> rewriteWithIndex(PlanNode planNode, Set<VariableReferenceExpression> lookupVariables, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session) {
            AtomicBoolean success = new AtomicBoolean();
            IndexSourceRewriter indexSourceRewriter = new IndexSourceRewriter(variableAllocator, idAllocator, metadata, session);
            PlanNode rewritten = SimplePlanRewriter.rewriteWith(indexSourceRewriter, planNode, new Context(lookupVariables, success));
            if (success.get()) {
                return Optional.of(rewritten);
            }
            return Optional.empty();
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            return node;
        }

        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            return this.planTableScan(node, (Expression)BooleanLiteral.TRUE_LITERAL, context.get());
        }

        private PlanNode planTableScan(TableScanNode node, Expression predicate, Context context) {
            ExpressionDomainTranslator.ExtractionResult decomposedPredicate = ExpressionDomainTranslator.fromPredicate(this.metadata, this.session, predicate, this.variableAllocator.getTypes());
            TupleDomain simplifiedConstraint = decomposedPredicate.getTupleDomain().transform(variableName -> (ColumnHandle)((ImmutableMap)node.getAssignments().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((VariableReferenceExpression)entry.getKey()).getName(), Map.Entry::getValue))).get(variableName)).intersect(node.getEnforcedConstraint());
            Preconditions.checkState((boolean)node.getOutputVariables().containsAll(context.getLookupVariables()));
            Set lookupColumns = (Set)context.getLookupVariables().stream().map(variable -> (ColumnHandle)node.getAssignments().get(variable)).collect(ImmutableSet.toImmutableSet());
            Set outputColumns = (Set)node.getOutputVariables().stream().map(node.getAssignments()::get).collect(ImmutableSet.toImmutableSet());
            Optional<ResolvedIndex> optionalResolvedIndex = this.metadata.resolveIndex(this.session, node.getTable(), lookupColumns, outputColumns, (TupleDomain<ColumnHandle>)simplifiedConstraint);
            if (!optionalResolvedIndex.isPresent()) {
                return node;
            }
            ResolvedIndex resolvedIndex = optionalResolvedIndex.get();
            Map inverseAssignments = (Map)node.getAssignments().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, entry -> ((VariableReferenceExpression)entry.getKey()).getName()));
            IndexSourceNode source = new IndexSourceNode(this.idAllocator.getNextId(), resolvedIndex.getIndexHandle(), node.getTable(), context.getLookupVariables(), node.getOutputVariables(), node.getAssignments(), (TupleDomain<ColumnHandle>)simplifiedConstraint);
            Expression[] expressionArray = new Expression[2];
            expressionArray[0] = this.domainTranslator.toPredicate((TupleDomain<String>)resolvedIndex.getUnresolvedTupleDomain().transform(inverseAssignments::get));
            expressionArray[1] = decomposedPredicate.getRemainingExpression();
            Expression resultingPredicate = ExpressionUtils.combineConjuncts(expressionArray);
            if (!resultingPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                source = new FilterNode(this.idAllocator.getNextId(), (PlanNode)source, OriginalExpressionUtils.castToRowExpression(resultingPredicate));
            }
            context.markSuccess();
            return source;
        }

        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            ImmutableSet.Builder newLookupVariablesBuilder = ImmutableSet.builder();
            for (VariableReferenceExpression variable : context.get().getLookupVariables()) {
                RowExpression expression = node.getAssignments().get(variable);
                if (!(OriginalExpressionUtils.castToExpression(expression) instanceof SymbolReference)) continue;
                newLookupVariablesBuilder.add((Object)new VariableReferenceExpression(((SymbolReference)OriginalExpressionUtils.castToExpression(expression)).getName(), variable.getType()));
            }
            ImmutableSet newLookupVariables = newLookupVariablesBuilder.build();
            if (newLookupVariables.isEmpty()) {
                return node;
            }
            return context.defaultRewrite((PlanNode)node, new Context((Set<VariableReferenceExpression>)newLookupVariables, context.get().getSuccess()));
        }

        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            if (node.getSource() instanceof TableScanNode) {
                return this.planTableScan((TableScanNode)node.getSource(), OriginalExpressionUtils.castToExpression(node.getPredicate()), context.get());
            }
            return context.defaultRewrite((PlanNode)node, new Context(context.get().getLookupVariables(), context.get().getSuccess()));
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            if (!node.getWindowFunctions().values().stream().allMatch(function -> this.metadata.getFunctionManager().getFunctionMetadata(function.getFunctionHandle()).getFunctionKind() == FunctionKind.AGGREGATE)) {
                return node;
            }
            if (node.getOrderingScheme().isPresent()) {
                return node;
            }
            if (node.getFrames().stream().map(WindowNode.Frame::getType).anyMatch(type -> type != WindowNode.Frame.WindowType.RANGE)) {
                return node;
            }
            Set partitionByLookupVariables = (Set)context.get().getLookupVariables().stream().filter(node.getPartitionBy()::contains).collect(ImmutableSet.toImmutableSet());
            if (partitionByLookupVariables.isEmpty()) {
                return node;
            }
            return context.defaultRewrite(node, new Context(partitionByLookupVariables, context.get().getSuccess()));
        }

        @Override
        public PlanNode visitIndexSource(IndexSourceNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            throw new IllegalStateException("Should not be trying to generate an Index on something that has already been determined to use an Index");
        }

        @Override
        public PlanNode visitIndexJoin(IndexJoinNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            Set probeLookupVariables = (Set)context.get().getLookupVariables().stream().filter(node.getProbeSource().getOutputVariables()::contains).collect(ImmutableSet.toImmutableSet());
            if (probeLookupVariables.isEmpty()) {
                return node;
            }
            PlanNode rewrittenProbeSource = context.rewrite(node.getProbeSource(), new Context(probeLookupVariables, context.get().getSuccess()));
            IndexJoinNode source = node;
            if (rewrittenProbeSource != node.getProbeSource()) {
                source = new IndexJoinNode(node.getId(), node.getType(), rewrittenProbeSource, node.getIndexSource(), node.getCriteria(), node.getProbeHashVariable(), node.getIndexHashVariable());
            }
            return source;
        }

        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            Set groupByLookupVariables = (Set)context.get().getLookupVariables().stream().filter(node.getGroupingKeys()::contains).collect(ImmutableSet.toImmutableSet());
            if (groupByLookupVariables.isEmpty()) {
                return node;
            }
            return context.defaultRewrite((PlanNode)node, new Context(groupByLookupVariables, context.get().getSuccess()));
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Context> context) {
            return context.rewrite(node.getSource(), context.get());
        }

        public static class Context {
            private final Set<VariableReferenceExpression> lookupVariables;
            private final AtomicBoolean success;

            public Context(Set<VariableReferenceExpression> lookupVariables, AtomicBoolean success) {
                Objects.requireNonNull(lookupVariables, "lookupVariables is null");
                Preconditions.checkArgument((!lookupVariables.isEmpty() ? 1 : 0) != 0, (Object)"lookupVariables can not be empty");
                this.lookupVariables = ImmutableSet.copyOf(lookupVariables);
                this.success = Objects.requireNonNull(success, "success is null");
            }

            public Set<VariableReferenceExpression> getLookupVariables() {
                return this.lookupVariables;
            }

            public AtomicBoolean getSuccess() {
                return this.success;
            }

            public void markSuccess() {
                Preconditions.checkState((boolean)this.success.compareAndSet(false, true), (Object)"Can only have one success per context");
            }
        }
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final PlanVariableAllocator variableAllocator;
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final Session session;

        private Rewriter(PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session) {
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode leftRewritten = context.rewrite(node.getLeft());
            PlanNode rightRewritten = context.rewrite(node.getRight());
            if (!node.getCriteria().isEmpty()) {
                Optional<PlanNode> rightIndexCandidate;
                List leftJoinVariables = Lists.transform(node.getCriteria(), JoinNode.EquiJoinClause::getLeft);
                List rightJoinVariables = Lists.transform(node.getCriteria(), JoinNode.EquiJoinClause::getRight);
                Optional<PlanNode> leftIndexCandidate = IndexSourceRewriter.rewriteWithIndex(leftRewritten, (Set<VariableReferenceExpression>)ImmutableSet.copyOf((Collection)leftJoinVariables), this.variableAllocator, this.idAllocator, this.metadata, this.session);
                if (leftIndexCandidate.isPresent()) {
                    Map<VariableReferenceExpression, VariableReferenceExpression> trace = IndexKeyTracer.trace(leftIndexCandidate.get(), (Set<VariableReferenceExpression>)ImmutableSet.copyOf((Collection)leftJoinVariables));
                    Preconditions.checkState((!trace.isEmpty() && leftJoinVariables.containsAll(trace.keySet()) ? 1 : 0) != 0);
                }
                if ((rightIndexCandidate = IndexSourceRewriter.rewriteWithIndex(rightRewritten, (Set<VariableReferenceExpression>)ImmutableSet.copyOf((Collection)rightJoinVariables), this.variableAllocator, this.idAllocator, this.metadata, this.session)).isPresent()) {
                    Map<VariableReferenceExpression, VariableReferenceExpression> trace = IndexKeyTracer.trace(rightIndexCandidate.get(), (Set<VariableReferenceExpression>)ImmutableSet.copyOf((Collection)rightJoinVariables));
                    Preconditions.checkState((!trace.isEmpty() && rightJoinVariables.containsAll(trace.keySet()) ? 1 : 0) != 0);
                }
                switch (node.getType()) {
                    case INNER: {
                        IndexJoinNode indexJoinNode = null;
                        if (rightIndexCandidate.isPresent()) {
                            indexJoinNode = new IndexJoinNode(this.idAllocator.getNextId(), IndexJoinNode.Type.INNER, leftRewritten, rightIndexCandidate.get(), Rewriter.createEquiJoinClause(leftJoinVariables, rightJoinVariables), Optional.empty(), Optional.empty());
                        } else if (leftIndexCandidate.isPresent()) {
                            indexJoinNode = new IndexJoinNode(this.idAllocator.getNextId(), IndexJoinNode.Type.INNER, rightRewritten, leftIndexCandidate.get(), Rewriter.createEquiJoinClause(rightJoinVariables, leftJoinVariables), Optional.empty(), Optional.empty());
                        }
                        if (indexJoinNode == null) break;
                        if (node.getFilter().isPresent()) {
                            indexJoinNode = new FilterNode(this.idAllocator.getNextId(), (PlanNode)indexJoinNode, node.getFilter().get());
                        }
                        if (!indexJoinNode.getOutputVariables().equals(node.getOutputVariables())) {
                            indexJoinNode = new ProjectNode(this.idAllocator.getNextId(), (PlanNode)indexJoinNode, AssignmentUtils.identityAssignmentsAsSymbolReferences(node.getOutputVariables()));
                        }
                        return indexJoinNode;
                    }
                    case LEFT: {
                        if (node.getFilter().isPresent() || !rightIndexCandidate.isPresent()) break;
                        return Rewriter.createIndexJoinWithExpectedOutputs(node.getOutputVariables(), IndexJoinNode.Type.SOURCE_OUTER, leftRewritten, rightIndexCandidate.get(), Rewriter.createEquiJoinClause(leftJoinVariables, rightJoinVariables), this.idAllocator);
                    }
                    case RIGHT: {
                        if (node.getFilter().isPresent() || !leftIndexCandidate.isPresent()) break;
                        return Rewriter.createIndexJoinWithExpectedOutputs(node.getOutputVariables(), IndexJoinNode.Type.SOURCE_OUTER, rightRewritten, leftIndexCandidate.get(), Rewriter.createEquiJoinClause(rightJoinVariables, leftJoinVariables), this.idAllocator);
                    }
                    case FULL: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)node.getType()));
                    }
                }
            }
            if (leftRewritten != node.getLeft() || rightRewritten != node.getRight()) {
                return new JoinNode(node.getId(), node.getType(), leftRewritten, rightRewritten, node.getCriteria(), node.getOutputVariables(), node.getFilter(), node.getLeftHashVariable(), node.getRightHashVariable(), node.getDistributionType());
            }
            return node;
        }

        private static PlanNode createIndexJoinWithExpectedOutputs(List<VariableReferenceExpression> expectedOutputs, IndexJoinNode.Type type, PlanNode probe, PlanNode index, List<IndexJoinNode.EquiJoinClause> equiJoinClause, PlanNodeIdAllocator idAllocator) {
            IndexJoinNode result = new IndexJoinNode(idAllocator.getNextId(), type, probe, index, equiJoinClause, Optional.empty(), Optional.empty());
            if (!result.getOutputVariables().equals(expectedOutputs)) {
                result = new ProjectNode(idAllocator.getNextId(), (PlanNode)result, AssignmentUtils.identityAssignmentsAsSymbolReferences(expectedOutputs));
            }
            return result;
        }

        private static List<IndexJoinNode.EquiJoinClause> createEquiJoinClause(List<VariableReferenceExpression> probeVariables, List<VariableReferenceExpression> indexVariables) {
            Preconditions.checkArgument((probeVariables.size() == indexVariables.size() ? 1 : 0) != 0);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < probeVariables.size(); ++i) {
                builder.add((Object)new IndexJoinNode.EquiJoinClause(probeVariables.get(i), indexVariables.get(i)));
            }
            return builder.build();
        }
    }
}

