/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class OriginalExpressionUtils {
    private OriginalExpressionUtils() {
    }

    public static RowExpression castToRowExpression(Expression expression) {
        return new OriginalExpression(expression);
    }

    public static SymbolReference asSymbolReference(VariableReferenceExpression variable) {
        return new SymbolReference(variable.getName());
    }

    public static Expression castToExpression(RowExpression rowExpression) {
        Preconditions.checkArgument((boolean)OriginalExpressionUtils.isExpression(rowExpression));
        return ((OriginalExpression)rowExpression).getExpression();
    }

    public static boolean isExpression(RowExpression rowExpression) {
        return rowExpression instanceof OriginalExpression;
    }

    private static final class OriginalExpression
    extends RowExpression {
        private final Expression expression;

        OriginalExpression(Expression expression) {
            this.expression = Objects.requireNonNull(expression, "expression is null");
        }

        public Expression getExpression() {
            return this.expression;
        }

        public Type getType() {
            throw new UnsupportedOperationException("OriginalExpression does not have a type");
        }

        public String toString() {
            return this.expression.toString();
        }

        public int hashCode() {
            return Objects.hash(this.expression);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            OriginalExpression other = (OriginalExpression)((Object)obj);
            return Objects.equals(this.expression, other.expression);
        }

        public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
            throw new UnsupportedOperationException("OriginalExpression cannot appear in a RowExpression tree");
        }
    }
}

