/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.SqlFunctionProperties;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DecimalParseResult;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.JsonType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BinaryLiteral;
import com.facebook.presto.sql.tree.BindExpression;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CharLiteral;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentUser;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.type.LikePatternType;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.LegacyRowFieldOrdinalAccessUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public final class SqlToRowExpressionTranslator {
    private SqlToRowExpressionTranslator() {
    }

    public static RowExpression translate(Expression expression, Map<NodeRef<Expression>, Type> types, Map<VariableReferenceExpression, Integer> layout, FunctionManager functionManager, TypeManager typeManager, Session session) {
        return SqlToRowExpressionTranslator.translate(expression, types, layout, functionManager, typeManager, Optional.of(session.getUser()), session.getTransactionId(), session.getSqlFunctionProperties());
    }

    public static RowExpression translate(Expression expression, Map<NodeRef<Expression>, Type> types, Map<VariableReferenceExpression, Integer> layout, FunctionManager functionManager, TypeManager typeManager, Optional<String> user, Optional<TransactionId> transactionId, SqlFunctionProperties sqlFunctionProperties) {
        Visitor visitor = new Visitor(types, layout, typeManager, functionManager, user, transactionId, sqlFunctionProperties);
        RowExpression result = (RowExpression)visitor.process((Node)expression, null);
        Objects.requireNonNull(result, "translated expression is null");
        return result;
    }

    private static class Visitor
    extends AstVisitor<RowExpression, Void> {
        private final Map<NodeRef<Expression>, Type> types;
        private final Map<VariableReferenceExpression, Integer> layout;
        private final TypeManager typeManager;
        private final FunctionManager functionManager;
        private final Optional<String> user;
        private final Optional<TransactionId> transactionId;
        private final SqlFunctionProperties sqlFunctionProperties;
        private final FunctionResolution functionResolution;

        private Visitor(Map<NodeRef<Expression>, Type> types, Map<VariableReferenceExpression, Integer> layout, TypeManager typeManager, FunctionManager functionManager, Optional<String> user, Optional<TransactionId> transactionId, SqlFunctionProperties sqlFunctionProperties) {
            this.types = ImmutableMap.copyOf(Objects.requireNonNull(types, "types is null"));
            this.layout = layout;
            this.typeManager = typeManager;
            this.functionManager = functionManager;
            this.user = user;
            this.transactionId = transactionId;
            this.sqlFunctionProperties = sqlFunctionProperties;
            this.functionResolution = new FunctionResolution(functionManager);
        }

        private Type getType(Expression node) {
            return this.types.get(NodeRef.of((Node)node));
        }

        protected RowExpression visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: expression translator for " + node.getClass().getName());
        }

        protected RowExpression visitIdentifier(Identifier node, Void context) {
            return new VariableReferenceExpression(node.getValue(), this.getType((Expression)node));
        }

        protected RowExpression visitCurrentUser(CurrentUser node, Void context) {
            return (RowExpression)this.user.map(user -> Expressions.constant(Slices.utf8Slice((String)user), (Type)VarcharType.VARCHAR)).orElseThrow(() -> new UnsupportedOperationException("Do not have current user"));
        }

        protected RowExpression visitFieldReference(FieldReference node, Void context) {
            return Expressions.field(node.getFieldIndex(), this.getType((Expression)node));
        }

        protected RowExpression visitNullLiteral(NullLiteral node, Void context) {
            return Expressions.constantNull((Type)UnknownType.UNKNOWN);
        }

        protected RowExpression visitBooleanLiteral(BooleanLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)BooleanType.BOOLEAN);
        }

        protected RowExpression visitLongLiteral(LongLiteral node, Void context) {
            if (node.getValue() >= Integer.MIN_VALUE && node.getValue() <= Integer.MAX_VALUE) {
                return Expressions.constant(node.getValue(), (Type)IntegerType.INTEGER);
            }
            return Expressions.constant(node.getValue(), (Type)BigintType.BIGINT);
        }

        protected RowExpression visitDoubleLiteral(DoubleLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)DoubleType.DOUBLE);
        }

        protected RowExpression visitDecimalLiteral(DecimalLiteral node, Void context) {
            DecimalParseResult parseResult = Decimals.parse((String)node.getValue());
            return Expressions.constant(parseResult.getObject(), (Type)parseResult.getType());
        }

        protected RowExpression visitStringLiteral(StringLiteral node, Void context) {
            return Expressions.constant(node.getSlice(), (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)node.getSlice())));
        }

        protected RowExpression visitCharLiteral(CharLiteral node, Void context) {
            return Expressions.constant(node.getSlice(), (Type)CharType.createCharType((long)node.getValue().length()));
        }

        protected RowExpression visitBinaryLiteral(BinaryLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)VarbinaryType.VARBINARY);
        }

        protected RowExpression visitGenericLiteral(GenericLiteral node, Void context) {
            Type type;
            try {
                type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unsupported type: " + node.getType());
            }
            try {
                if (TinyintType.TINYINT.equals((Object)type)) {
                    return Expressions.constant(Byte.parseByte(node.getValue()), (Type)TinyintType.TINYINT);
                }
                if (SmallintType.SMALLINT.equals((Object)type)) {
                    return Expressions.constant(Short.parseShort(node.getValue()), (Type)SmallintType.SMALLINT);
                }
                if (BigintType.BIGINT.equals((Object)type)) {
                    return Expressions.constant(Long.parseLong(node.getValue()), (Type)BigintType.BIGINT);
                }
            }
            catch (NumberFormatException e) {
                throw new SemanticException(SemanticErrorCode.INVALID_LITERAL, (Node)node, String.format("Invalid formatted generic %s literal: %s", type, node), new Object[0]);
            }
            if (JsonType.JSON.equals((Object)type)) {
                return Expressions.call("json_parse", this.functionManager.lookupFunction("json_parse", TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR})), this.getType((Expression)node), new RowExpression[]{Expressions.constant(Slices.utf8Slice((String)node.getValue()), (Type)VarcharType.VARCHAR)});
            }
            return Expressions.call(CastType.CAST.name(), this.functionManager.lookupCast(CastType.CAST, VarcharType.VARCHAR.getTypeSignature(), this.getType((Expression)node).getTypeSignature()), this.getType((Expression)node), new RowExpression[]{Expressions.constant(Slices.utf8Slice((String)node.getValue()), (Type)VarcharType.VARCHAR)});
        }

        protected RowExpression visitTimeLiteral(TimeLiteral node, Void context) {
            long value = this.getType((Expression)node).equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) ? DateTimeUtils.parseTimeWithTimeZone(node.getValue()) : (this.sqlFunctionProperties.isLegacyTimestamp() ? DateTimeUtils.parseTimeWithoutTimeZone(this.sqlFunctionProperties.getTimeZoneKey(), node.getValue()) : DateTimeUtils.parseTimeWithoutTimeZone(node.getValue()));
            return Expressions.constant(value, this.getType((Expression)node));
        }

        protected RowExpression visitTimestampLiteral(TimestampLiteral node, Void context) {
            long value = this.sqlFunctionProperties.isLegacyTimestamp() ? DateTimeUtils.parseTimestampLiteral(this.sqlFunctionProperties.getTimeZoneKey(), node.getValue()) : DateTimeUtils.parseTimestampLiteral(node.getValue());
            return Expressions.constant(value, this.getType((Expression)node));
        }

        protected RowExpression visitIntervalLiteral(IntervalLiteral node, Void context) {
            long value = node.isYearToMonth() ? (long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField()) : (long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField());
            return Expressions.constant(value, this.getType((Expression)node));
        }

        protected RowExpression visitComparisonExpression(ComparisonExpression node, Void context) {
            RowExpression left = (RowExpression)this.process((Node)node.getLeft(), context);
            RowExpression right = (RowExpression)this.process((Node)node.getRight(), context);
            return Expressions.call(node.getOperator().name(), this.functionResolution.comparisonFunction(node.getOperator(), left.getType(), right.getType()), (Type)BooleanType.BOOLEAN, left, right);
        }

        protected RowExpression visitFunctionCall(FunctionCall node, Void context) {
            List arguments = (List)node.getArguments().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            List argumentTypes = (List)arguments.stream().map(RowExpression::getType).map(Type::getTypeSignature).map(TypeSignatureProvider::new).collect(ImmutableList.toImmutableList());
            return Expressions.call(node.getName().toString(), this.functionManager.resolveFunction(this.transactionId, node.getName(), (List<TypeSignatureProvider>)argumentTypes), this.getType((Expression)node), (List<RowExpression>)arguments);
        }

        protected RowExpression visitSymbolReference(SymbolReference node, Void context) {
            VariableReferenceExpression variable = new VariableReferenceExpression(node.getName(), this.getType((Expression)node));
            Integer channel = this.layout.get(variable);
            if (channel != null) {
                return Expressions.field(channel, variable.getType());
            }
            return variable;
        }

        protected RowExpression visitLambdaExpression(LambdaExpression node, Void context) {
            RowExpression body = (RowExpression)this.process((Node)node.getBody(), context);
            Type type = this.getType((Expression)node);
            List typeParameters = type.getTypeParameters();
            List argumentTypes = typeParameters.subList(0, typeParameters.size() - 1);
            List argumentNames = (List)node.getArguments().stream().map(LambdaArgumentDeclaration::getName).map(Identifier::getValue).collect(ImmutableList.toImmutableList());
            return new LambdaDefinitionExpression(argumentTypes, argumentNames, body);
        }

        protected RowExpression visitBindExpression(BindExpression node, Void context) {
            ImmutableList.Builder valueTypesBuilder = ImmutableList.builder();
            ImmutableList.Builder argumentsBuilder = ImmutableList.builder();
            for (Expression value : node.getValues()) {
                RowExpression valueRowExpression = (RowExpression)this.process((Node)value, context);
                valueTypesBuilder.add((Object)valueRowExpression.getType());
                argumentsBuilder.add((Object)valueRowExpression);
            }
            RowExpression function = (RowExpression)this.process((Node)node.getFunction(), context);
            argumentsBuilder.add((Object)function);
            return Expressions.specialForm(SpecialFormExpression.Form.BIND, this.getType((Expression)node), (List<RowExpression>)argumentsBuilder.build());
        }

        protected RowExpression visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            RowExpression left = (RowExpression)this.process((Node)node.getLeft(), context);
            RowExpression right = (RowExpression)this.process((Node)node.getRight(), context);
            return Expressions.call(node.getOperator().name(), this.functionResolution.arithmeticFunction(node.getOperator(), left.getType(), right.getType()), this.getType((Expression)node), left, right);
        }

        protected RowExpression visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            switch (node.getSign()) {
                case PLUS: {
                    return expression;
                }
                case MINUS: {
                    return Expressions.call(OperatorType.NEGATION.name(), this.functionManager.resolveOperator(OperatorType.NEGATION, TypeSignatureProvider.fromTypes(expression.getType())), this.getType((Expression)node), expression);
                }
            }
            throw new UnsupportedOperationException("Unsupported unary operator: " + node.getSign());
        }

        protected RowExpression visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            SpecialFormExpression.Form form;
            switch (node.getOperator()) {
                case AND: {
                    form = SpecialFormExpression.Form.AND;
                    break;
                }
                case OR: {
                    form = SpecialFormExpression.Form.OR;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown logical operator: " + node.getOperator());
                }
            }
            return Expressions.specialForm(form, (Type)BooleanType.BOOLEAN, (RowExpression)this.process((Node)node.getLeft(), context), (RowExpression)this.process((Node)node.getRight(), context));
        }

        protected RowExpression visitCast(Cast node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getExpression(), context);
            if (node.isSafe()) {
                return Expressions.call(CastType.TRY_CAST.name(), this.functionManager.lookupCast(CastType.TRY_CAST, value.getType().getTypeSignature(), this.getType((Expression)node).getTypeSignature()), this.getType((Expression)node), value);
            }
            return Expressions.call(CastType.CAST.name(), this.functionManager.lookupCast(CastType.CAST, value.getType().getTypeSignature(), this.getType((Expression)node).getTypeSignature()), this.getType((Expression)node), value);
        }

        protected RowExpression visitCoalesceExpression(CoalesceExpression node, Void context) {
            List arguments = (List)node.getOperands().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            return Expressions.specialForm(SpecialFormExpression.Form.COALESCE, this.getType((Expression)node), arguments);
        }

        protected RowExpression visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add(this.process((Node)node.getOperand(), context));
            for (WhenClause clause : node.getWhenClauses()) {
                arguments.add((Object)Expressions.specialForm(SpecialFormExpression.Form.WHEN, this.getType((Expression)clause), (RowExpression)this.process((Node)clause.getOperand(), context), (RowExpression)this.process((Node)clause.getResult(), context)));
            }
            Type returnType = this.getType((Expression)node);
            arguments.add((Object)node.getDefaultValue().map(value -> (RowExpression)this.process((Node)value, context)).orElse((RowExpression)Expressions.constantNull(returnType)));
            return Expressions.specialForm(SpecialFormExpression.Form.SWITCH, returnType, (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            RowExpression expression = node.getDefaultValue().map(value -> (RowExpression)this.process((Node)value, context)).orElse((RowExpression)Expressions.constantNull(this.getType((Expression)node)));
            for (WhenClause clause : Lists.reverse((List)node.getWhenClauses())) {
                expression = Expressions.specialForm(SpecialFormExpression.Form.IF, this.getType((Expression)node), (RowExpression)this.process((Node)clause.getOperand(), context), (RowExpression)this.process((Node)clause.getResult(), context), expression);
            }
            return expression;
        }

        protected RowExpression visitDereferenceExpression(DereferenceExpression node, Void context) {
            OptionalInt rowIndex;
            RowType rowType = (RowType)this.getType(node.getBase());
            String fieldName = node.getField().getValue();
            List fields = rowType.getFields();
            int index = -1;
            for (int i = 0; i < fields.size(); ++i) {
                RowType.Field field = (RowType.Field)fields.get(i);
                if (!field.getName().isPresent() || !((String)field.getName().get()).equalsIgnoreCase(fieldName)) continue;
                Preconditions.checkArgument((index < 0 ? 1 : 0) != 0, (String)"Ambiguous field %s in type %s", (Object)field, (Object)rowType.getDisplayName());
                index = i;
            }
            if (this.sqlFunctionProperties.isLegacyRowFieldOrdinalAccessEnabled() && index < 0 && (rowIndex = LegacyRowFieldOrdinalAccessUtil.parseAnonymousRowFieldOrdinalAccess(fieldName, fields)).isPresent()) {
                index = rowIndex.getAsInt();
            }
            Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"could not find field name: %s", (Object)node.getField());
            Type returnType = this.getType((Expression)node);
            return Expressions.specialForm(SpecialFormExpression.Form.DEREFERENCE, returnType, new RowExpression[]{(RowExpression)this.process((Node)node.getBase(), context), Expressions.constant(index, (Type)IntegerType.INTEGER)});
        }

        protected RowExpression visitIfExpression(IfExpression node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add(this.process((Node)node.getCondition(), context)).add(this.process((Node)node.getTrueValue(), context));
            if (node.getFalseValue().isPresent()) {
                arguments.add(this.process((Node)node.getFalseValue().get(), context));
            } else {
                arguments.add((Object)Expressions.constantNull(this.getType((Expression)node)));
            }
            return Expressions.specialForm(SpecialFormExpression.Form.IF, this.getType((Expression)node), (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitTryExpression(TryExpression node, Void context) {
            throw new UnsupportedOperationException("Must desugar TryExpression before translate it into RowExpression");
        }

        protected RowExpression visitInPredicate(InPredicate node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add(this.process((Node)node.getValue(), context));
            InListExpression values = (InListExpression)node.getValueList();
            for (Expression value : values.getValues()) {
                arguments.add(this.process((Node)value, context));
            }
            return Expressions.specialForm(SpecialFormExpression.Form.IN, (Type)BooleanType.BOOLEAN, (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            return Expressions.call("not", this.functionResolution.notFunction(), (Type)BooleanType.BOOLEAN, new RowExpression[]{Expressions.specialForm(SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)expression))});
        }

        protected RowExpression visitIsNullPredicate(IsNullPredicate node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            return Expressions.specialForm(SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, expression);
        }

        protected RowExpression visitNotExpression(NotExpression node, Void context) {
            return Expressions.call("not", this.functionResolution.notFunction(), (Type)BooleanType.BOOLEAN, (RowExpression)this.process((Node)node.getValue(), context));
        }

        protected RowExpression visitNullIfExpression(NullIfExpression node, Void context) {
            RowExpression first = (RowExpression)this.process((Node)node.getFirst(), context);
            RowExpression second = (RowExpression)this.process((Node)node.getSecond(), context);
            return Expressions.specialForm(SpecialFormExpression.Form.NULL_IF, this.getType((Expression)node), first, second);
        }

        protected RowExpression visitBetweenPredicate(BetweenPredicate node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getValue(), context);
            RowExpression min = (RowExpression)this.process((Node)node.getMin(), context);
            RowExpression max = (RowExpression)this.process((Node)node.getMax(), context);
            return Expressions.call(OperatorType.BETWEEN.name(), this.functionManager.resolveOperator(OperatorType.BETWEEN, TypeSignatureProvider.fromTypes(value.getType(), min.getType(), max.getType())), (Type)BooleanType.BOOLEAN, value, min, max);
        }

        protected RowExpression visitLikePredicate(LikePredicate node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getValue(), context);
            RowExpression pattern = (RowExpression)this.process((Node)node.getPattern(), context);
            if (node.getEscape().isPresent()) {
                RowExpression escape = (RowExpression)this.process((Node)node.getEscape().get(), context);
                return this.likeFunctionCall(value, (RowExpression)Expressions.call("LIKE_PATTERN", this.functionResolution.likePatternFunction(), (Type)LikePatternType.LIKE_PATTERN, pattern, escape));
            }
            return this.likeFunctionCall(value, (RowExpression)Expressions.call(CastType.CAST.name(), this.functionManager.lookupCast(CastType.CAST, VarcharType.VARCHAR.getTypeSignature(), LikePatternType.LIKE_PATTERN.getTypeSignature()), (Type)LikePatternType.LIKE_PATTERN, pattern));
        }

        private RowExpression likeFunctionCall(RowExpression value, RowExpression pattern) {
            if (value.getType() instanceof VarcharType) {
                return Expressions.call("LIKE", this.functionResolution.likeVarcharFunction(), (Type)BooleanType.BOOLEAN, value, pattern);
            }
            Preconditions.checkState((boolean)(value.getType() instanceof CharType), (Object)"LIKE value type is neither VARCHAR or CHAR");
            return Expressions.call("LIKE", this.functionResolution.likeCharFunction(value.getType()), (Type)BooleanType.BOOLEAN, value, pattern);
        }

        protected RowExpression visitSubscriptExpression(SubscriptExpression node, Void context) {
            RowExpression base = (RowExpression)this.process((Node)node.getBase(), context);
            RowExpression index = (RowExpression)this.process((Node)node.getIndex(), context);
            if (base.getType() instanceof RowType) {
                Preconditions.checkState((boolean)(index instanceof ConstantExpression), (Object)"Subscript expression on ROW requires a ConstantExpression");
                ConstantExpression position = (ConstantExpression)index;
                Preconditions.checkState((boolean)(position.getValue() instanceof Long), (Object)"ConstantExpression should contain a valid integer index into the row");
                Long offset = (Long)position.getValue();
                Preconditions.checkState((offset >= 1L && offset <= (long)base.getType().getTypeParameters().size() ? 1 : 0) != 0, (String)"Subscript index out of bounds %s: should be >= 1 and <= %s", (Object)offset, (int)base.getType().getTypeParameters().size());
                return Expressions.specialForm(SpecialFormExpression.Form.DEREFERENCE, this.getType((Expression)node), new RowExpression[]{base, Expressions.constant(offset - 1L, (Type)IntegerType.INTEGER)});
            }
            return Expressions.call(OperatorType.SUBSCRIPT.name(), this.functionManager.resolveOperator(OperatorType.SUBSCRIPT, TypeSignatureProvider.fromTypes(base.getType(), index.getType())), this.getType((Expression)node), base, index);
        }

        protected RowExpression visitArrayConstructor(ArrayConstructor node, Void context) {
            List arguments = (List)node.getValues().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            List argumentTypes = (List)arguments.stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList());
            return Expressions.call("ARRAY", this.functionResolution.arrayConstructor(argumentTypes), this.getType((Expression)node), (List<RowExpression>)arguments);
        }

        protected RowExpression visitRow(Row node, Void context) {
            List arguments = (List)node.getItems().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            Type returnType = this.getType((Expression)node);
            return Expressions.specialForm(SpecialFormExpression.Form.ROW_CONSTRUCTOR, returnType, arguments);
        }
    }
}

